/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister.xstream;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.persister.PersisterException;
import com.atlassian.bamboo.utils.XmlDiffFinder;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class XStreamAdminConfigPersister {
    private static final Logger log = Logger.getLogger(XStreamAdminConfigPersister.class);
    private final String myConfigurationDirectory;
    private final XStream xStream;

    public XStreamAdminConfigPersister(String configurationDirectory, XStream xStream) {
        this.myConfigurationDirectory = configurationDirectory;
        this.xStream = xStream;
    }

    @Nullable
    public AdministrationConfiguration loadConfiguation() throws PersisterException {
        File adminConfigFile = new File(this.myConfigurationDirectory, "administration.xml");
        if (adminConfigFile.exists()) {
            try {
                String xml = FileUtils.readFileToString((File)adminConfigFile);
                return (AdministrationConfiguration)this.xStream.fromXML(xml);
            }
            catch (IOException e) {
                throw new PersisterException("Could not load administration configuration", e);
            }
        }
        return null;
    }

    public void saveConfiguration(AdministrationConfiguration administrationConfiguration) throws PersisterException {
        new File(this.myConfigurationDirectory).mkdirs();
        try {
            String data;
            File configFile = new File(this.myConfigurationDirectory, "administration.xml");
            if (this.isSetupComplete()) {
                this.logChanges(configFile, administrationConfiguration);
            }
            Preconditions.checkArgument((!(data = this.xStream.toXML((Object)administrationConfiguration)).contains("</outer-class>") ? 1 : 0) != 0, (Object)("AdministrationConfiguration contains references to inner classes: " + data));
            FileUtils.writeStringToFile((File)configFile, (String)data, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new PersisterException("Failed to save administration configuration", e);
        }
    }

    private void logChanges(File adminConfigFile, AdministrationConfiguration administrationConfiguration) {
        if (adminConfigFile.exists()) {
            XmlDiffFinder xmlDiffFinder;
            List<AuditLogService.FieldChange> changes;
            String oldConfigString;
            try {
                oldConfigString = FileUtils.readFileToString((File)adminConfigFile);
            }
            catch (IOException e) {
                log.error((Object)"Unable to load administration configuration. No audit entries will be recorded.");
                return;
            }
            String newConfigString = this.xStream.toXML((Object)administrationConfiguration);
            if (!oldConfigString.equals(newConfigString) && !(changes = (xmlDiffFinder = new XmlDiffFinder(oldConfigString, newConfigString)).findChanges()).isEmpty()) {
                this.getAuditLog().log(changes, (AuditLogEntity)null);
            }
        } else {
            log.error((Object)"Unable to load administration configuration. No audit entries will be recorded.");
        }
    }

    private AuditLogService getAuditLog() {
        return (AuditLogService)ContainerManager.getComponent((String)"auditLogService");
    }

    protected boolean isSetupComplete() {
        return BootstrapUtils.getBootstrapManager().isSetupComplete();
    }
}

