/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister.xstream;

import com.atlassian.bamboo.configuration.SerializationSecurityMethod;
import com.atlassian.bamboo.serialization.SerializationSecurityManager;
import com.atlassian.bamboo.utils.BambooReflectionUtils;
import com.thoughtworks.xstream.security.TypePermission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XStreamTypePermission
implements TypePermission {
    private static final Logger log = LoggerFactory.getLogger(XStreamTypePermission.class);
    protected final SerializationSecurityManager serializationSecurityManager;

    public XStreamTypePermission(SerializationSecurityManager serializationSecurityManager) {
        this.serializationSecurityManager = serializationSecurityManager;
    }

    public boolean allows(@Nullable Class type) {
        if (type == null) {
            return true;
        }
        SerializationSecurityMethod serializationSecurityMethod = this.getSerializationSecurityMethod();
        String className = BambooReflectionUtils.getSimpleType((Class)type).getName();
        if (log.isTraceEnabled()) {
            log.trace(String.format("Checking if %s is allowed by %s", className, serializationSecurityMethod));
        }
        switch (serializationSecurityMethod) {
            case WHITELIST: {
                boolean allowedByWhitelist = this.serializationSecurityManager.getClassNameWhitelist().contains(className);
                if (!allowedByWhitelist) {
                    log.warn(className + " is not allowed by Allow list");
                }
                return allowedByWhitelist;
            }
            case STRICT_BLACKLIST: 
            case BLACKLIST: {
                boolean blockedByBlacklist = this.serializationSecurityManager.isBlacklisted(type, serializationSecurityMethod);
                if (blockedByBlacklist) {
                    if (this.serializationSecurityManager.getClassNameWhitelist().contains(className)) {
                        log.trace(className + " is not allowed by Block list, but allowed by Allow list. Class is allowed");
                        return true;
                    }
                    log.warn(className + " is not allowed by Block list. If you think it should be allowed, add it to Allow list at BAMBOO_HOME");
                }
                return !blockedByBlacklist;
            }
        }
        log.error("Unknown method - " + serializationSecurityMethod + ", don't allow class - " + className);
        return false;
    }

    @NotNull
    protected abstract SerializationSecurityMethod getSerializationSecurityMethod();
}

