/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.path.Path;
import com.thoughtworks.xstream.io.path.PathTracker;
import com.thoughtworks.xstream.io.path.PathTrackingWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public final class XStreamUtils {
    private XStreamUtils() {
    }

    public static void writeNode(HierarchicalStreamWriter writer, String nodeName, @Nullable String text) {
        writer.startNode(nodeName);
        if (text != null) {
            writer.setValue(text);
        }
        writer.endNode();
    }

    public static Pair<String, String> readNextChildNodeValue(HierarchicalStreamReader reader) {
        reader.moveDown();
        String value = reader.getValue();
        String name = reader.getNodeName();
        reader.moveUp();
        return Pair.of((Object)name, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T fromUtfXml(XStream xStream, File file) throws FileNotFoundException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        try {
            Object object = xStream.fromXML((Reader)br);
            return (T)object;
        }
        finally {
            IOUtils.closeQuietly((Reader)br);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toUtfXml(XStream xStream, Object buildResults, File file) throws FileNotFoundException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
        try {
            xStream.toXML(buildResults, (Writer)writer);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toXml(XStream xStream, Object object, File file) throws FileNotFoundException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            xStream.toXML(object, (OutputStream)os);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    @Nullable
    public static Path getPath(HierarchicalStreamWriter writer) {
        if (!(writer instanceof PathTrackingWriter)) {
            return null;
        }
        try {
            Field field = writer.getClass().getDeclaredField("pathTracker");
            field.setAccessible(true);
            PathTracker pathTracker = (PathTracker)field.get(writer);
            return pathTracker.getPath();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

