/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.ChainStageImpl;
import com.atlassian.bamboo.chains.ChainStorageTag;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.notification.NotificationSetImpl;
import com.atlassian.bamboo.plan.AbstractPlan;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plan.VcsBambooSpecsSourceImpl;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.number.PlanBuildNumbers;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryDefinitionImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.collectors.CollectorsUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MappedSuperclass
public abstract class AbstractChain
extends AbstractPlan
implements Plan,
Chain {
    private static final Logger log = Logger.getLogger(AbstractChain.class);
    public static final int NUMBER_OF_RESULTS = 10;
    private List<ChainStage> allStages = new LinkedList<ChainStage>();
    private NotificationSet notificationSet;
    protected Chain master;
    private ChainStorageTag storageTag;
    private ChainExecutionManager chainExecutionManager;
    private RepositoryDefinitionManager repositoryDefinitionManager;
    private PlanBuildNumbers buildNumbers;
    @Column(name="VCS_SPECS_SOURCE_ID")
    @Fetch(value=FetchMode.JOIN)
    @ManyToOne
    private VcsBambooSpecsSourceImpl vcsBambooSpecsSource;

    public ChainStorageTag getStorageTag() {
        return this.storageTag;
    }

    public void setStorageTag(ChainStorageTag storageTag) {
        this.storageTag = storageTag;
    }

    @NotNull
    public List<ChainStage> getStages() {
        return this.allStages.stream().filter(BambooPredicates::isNotDeleted).collect(Collectors.toCollection(LinkedList::new));
    }

    public ChainStage addNewStage(@NotNull String name, @NotNull String description, boolean manual) {
        return this.addNewStage(name, description, manual, false);
    }

    @NotNull
    private ChainStage addNewStage(@NotNull String name, @NotNull String description, boolean manual, boolean finalStage) {
        ChainStageImpl stage = new ChainStageImpl(this, name, description, manual, finalStage);
        this.addStage(stage);
        return stage;
    }

    public void addStage(@NotNull ChainStage chainStage) {
        chainStage.setChain((Chain)this);
        this.allStages.add(chainStage);
    }

    public void removeStage(long chainStageId) {
        this.allStages.removeIf(chainStage -> chainStage != null && chainStage.getId() == chainStageId);
    }

    public int getJobCount() {
        return this.getAllJobs().size();
    }

    @NotNull
    public List<Job> getAllJobs() {
        ArrayList<Job> allJobs = new ArrayList<Job>();
        List<ChainStage> stages = this.getStages();
        for (ChainStage stage : stages) {
            allJobs.addAll(stage.getJobs());
        }
        return allJobs;
    }

    public boolean containsStage(@Nullable String stageName) {
        if (stageName != null) {
            for (ChainStage stage : this.getStages()) {
                if (!stage.getName().equals(stageName)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getCurrentStatus() {
        return PlanHelper.getCurrentStatus(this);
    }

    public boolean isExecuting() {
        return this.chainExecutionManager.isExecuting(this.getPlanKey());
    }

    public boolean isActive() {
        return this.chainExecutionManager.isActive(this.getPlanKey());
    }

    public PlanResultKey getLastResultKey() {
        List chainExecutions = this.chainExecutionManager.getExecutingChains(this.getPlanKey());
        if (!chainExecutions.isEmpty()) {
            PlanResultKey resultKey = ((ChainExecution)Iterables.getFirst((Iterable)chainExecutions, null)).getPlanResultKey();
            for (ChainExecution chainExecution : Iterables.skip((Iterable)chainExecutions, (int)1)) {
                if (chainExecution.getPlanResultKey().getBuildNumber() <= resultKey.getBuildNumber()) continue;
                resultKey = chainExecution.getPlanResultKey();
            }
            return resultKey;
        }
        ResultsSummary latestResultsSummary = this.getLatestResultsSummary();
        return latestResultsSummary == null ? null : latestResultsSummary.getPlanResultKey();
    }

    public long getAverageBuildDuration() {
        return this.resultsSummaryManager.getAveragePlanExecutionDuration((ImmutablePlan)this, 10);
    }

    @NotNull
    public List<RepositoryDefinition> getEffectiveRepositoryDefinitions() {
        return (List)this.getPlanRepositoryDefinitions().stream().map(RepositoryDefinitionImpl::new).collect(CollectorsUtil.toImmutableList());
    }

    @NotNull
    public List<PlanRepositoryDefinition> getPlanRepositoryDefinitions() {
        return ImmutableList.copyOf((Collection)this.repositoryDefinitionManager.getPlanRepositoryDefinitions((PlanIdentifier)this));
    }

    public NotificationSet getNotificationSet() {
        if (this.notificationSet == null) {
            this.notificationSet = new NotificationSetImpl();
        }
        return this.notificationSet;
    }

    public final void setNotificationSet(NotificationSet notificationSet) {
        this.notificationSet = notificationSet;
    }

    public final NotificationSet getNotificationSetField() {
        if (this.notificationSet == null) {
            this.notificationSet = new NotificationSetImpl();
        }
        return this.notificationSet;
    }

    public Chain getMaster() {
        return this.master;
    }

    public boolean isSuspended() {
        return this.isSuspendedFromBuilding();
    }

    @NotNull
    public List<TriggerDefinition> getTriggerDefinitions() {
        return this.getBuildDefinition().getTriggerDefinitions();
    }

    @NotNull
    public List<ChainStage> getAllStages() {
        return this.allStages;
    }

    public void setAllStages(@NotNull List<ChainStage> allStages) {
        this.allStages = allStages;
    }

    public void setChainExecutionManager(ChainExecutionManager chainExecutionManager) {
        this.chainExecutionManager = chainExecutionManager;
    }

    private PlanBuildNumbers getBuildNumbers() {
        return this.buildNumbers;
    }

    private void setBuildNumbers(PlanBuildNumbers buildNumbers) {
        this.buildNumbers = buildNumbers;
    }

    public void setRepositoryDefinitionManager(RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    @Nullable
    public VcsBambooSpecsSource getVcsBambooSpecsSource() {
        return this.vcsBambooSpecsSource;
    }

    public void setVcsBambooSpecsSource(VcsBambooSpecsSourceImpl vcsBambooSpecsSource) {
        this.vcsBambooSpecsSource = vcsBambooSpecsSource;
    }
}

