/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.hibernate.HibernateBambooEntityWithOid;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.LabelFunctions;
import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.helpers.EffectivePlanPropertiesHelper;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.tests.TestClass;
import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.collectors.CollectorsUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.atlassian.util.concurrent.LazyReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Table(name="BUILD")
@MappedSuperclass
@AttributeOverride(name="id", column=@Column(name="BUILD_ID"))
public abstract class AbstractPlan
extends HibernateBambooEntityWithOid
implements ImmutablePlan,
Plan,
Comparable<Plan> {
    @Column(name="PROJECT_ID")
    @ManyToOne
    private Project project;
    private BuildDefinitionForBuild buildDefinitionXml;
    private String discriminator;
    @Column(name="FULL_KEY")
    @Type(type="com.atlassian.bamboo.plan.PlanKeyUserType")
    private PlanKey planKey;
    private String name;
    private String description;
    private String buildName;
    private String buildKey;
    private boolean suspendedFromBuilding;
    private boolean markedForDeletion;
    private List<Labelling> labellings = new ArrayList<Labelling>();
    private Set<TestClass> testClasses = new HashSet<TestClass>();
    private final LazyReference<ResultsSummary> latestResultsSummaryRef = new LazyReference<ResultsSummary>(){

        protected ResultsSummary create() throws Exception {
            return AbstractPlan.this.resultsSummaryManager.getLastResultsSummary(AbstractPlan.this.getKey(), ResultsSummary.class);
        }
    };
    private PlanExecutionManager planExecutionManager;
    private BuildDefinitionManager buildDefinitionManager;
    private BuildLoggerManager buildLoggerManager;
    protected ResultsSummaryManager resultsSummaryManager;
    private volatile BuildLogger buildLogger;
    private VariableDefinitionManager variableDefinitionManager;
    private LabelManager labelManager;

    @NotNull
    public Optional<Long> getDatabaseId() {
        return Optional.of(this.getId());
    }

    @NotNull
    public PlanKey getPlanKey() {
        return this.planKey;
    }

    @NotNull
    public String getKey() {
        return this.planKey.getKey();
    }

    public void setKey(String fullKey) {
        this.planKey = PlanKeys.getPlanKey((String)fullKey);
    }

    public void setPlanKey(@NotNull PlanKey planKey) {
        this.planKey = planKey;
    }

    @NotNull
    public String getBuildKey() {
        return this.buildKey;
    }

    public void setBuildKey(String buildKey) {
        this.buildKey = buildKey;
    }

    @NotNull
    public String getName() {
        if (this.name == null && this.project != null) {
            this.name = this.hasMaster() ? this.project.getName() + " - " + this.getMaster().getBuildName() + " - " + this.getBuildName() : this.project.getName() + " - " + this.getBuildName();
        }
        return this.name;
    }

    public void setName(@NotNull String name) {
    }

    @NotNull
    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = BambooInterners.intern((String)buildName);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = BambooInterners.intern((String)description);
    }

    @NotNull
    public String getType() {
        return this.getPlanType().name();
    }

    public boolean hasMaster() {
        return this.getMaster() != null;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public void setMarkedForDeletion(boolean markedForDeletion) {
        this.markedForDeletion = markedForDeletion;
    }

    public void setSuspendedFromBuilding(boolean suspendedFromBuilding) {
        this.suspendedFromBuilding = suspendedFromBuilding;
    }

    public boolean isSuspendedFromBuilding() {
        return this.suspendedFromBuilding;
    }

    public boolean isBusy() {
        return this.planExecutionManager.isBusy(this.getPlanKey());
    }

    @NotNull
    public BuildLogger getBuildLogger() {
        if (this.buildLogger == null) {
            this.buildLogger = this.buildLoggerManager.getLogger((Key)this.getPlanKey());
        }
        return this.buildLogger;
    }

    public int getLastBuildNumber() {
        return (Integer)this.resultsSummaryManager.findBuildResultNumbersRange(this.planKey).getMaximum();
    }

    public int getFirstBuildNumber() {
        return (Integer)this.resultsSummaryManager.findBuildResultNumbersRange(this.planKey).getMinimum();
    }

    @Deprecated
    @NotNull
    public List<TestClass> getTestClasses() {
        return ImmutableList.copyOf(this.testClasses);
    }

    @Deprecated
    public void setTestClasses(List<TestClass> testCases) {
        this.testClasses = new HashSet<TestClass>(testCases);
    }

    @Nullable
    public ResultsSummary getLatestResultsSummary() {
        return (ResultsSummary)this.latestResultsSummaryRef.get();
    }

    @NotNull
    public List<VariableDefinition> getVariables() {
        return this.variableDefinitionManager.getPlanVariables((PlanIdentifier)this);
    }

    @NotNull
    public List<VariableDefinition> getEffectiveVariables() {
        return EffectivePlanPropertiesHelper.createEffectiveVariableDefinitions(this, this.getVariables());
    }

    public void setProject(Project project) {
        this.project = project;
        this.name = null;
    }

    @NotNull
    public BuildDefinition getBuildDefinition() {
        Preconditions.checkState((this.buildDefinitionManager != null ? 1 : 0) != 0, (String)"buildDefinitionManager is null in %s", (Object[])new Object[]{this.getPlanKey().getKey()});
        return this.buildDefinitionManager.getBuildDefinition((Plan)this);
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    public long getMasterId() {
        ImmutablePlan master = this.getMaster();
        return master != null ? master.getId() : -1L;
    }

    @NotNull
    public Optional<Long> getMasterIdIfExists() {
        ImmutablePlan master = this.getMaster();
        return master != null ? Optional.of(master.getId()) : Optional.empty();
    }

    @Nullable
    public BuildDefinitionForBuild getBuildDefinitionXml() {
        return this.buildDefinitionXml;
    }

    public void setBuildDefinitionXml(@Nullable BuildDefinitionForBuild buildDefinitionXml) {
        if (buildDefinitionXml != null) {
            buildDefinitionXml.setPlan((Plan)this);
        }
        this.buildDefinitionXml = buildDefinitionXml;
    }

    @NotNull
    public List<Labelling> getLabellings() {
        return this.labellings;
    }

    @NotNull
    public List<Labelling> getRelatedLabellings() {
        return this.getLabellings().stream().filter(LabelFunctions::isPlanRelated).collect(Collectors.toList());
    }

    @NotNull
    public List<String> getLabelNames() {
        return (List)this.labelManager.getPlanLabels((ImmutablePlan)this).stream().map(Label::getName).collect(CollectorsUtil.toImmutableList());
    }

    public void setLabellings(List<Labelling> labellings) {
        this.labellings = labellings;
    }

    public void setPlanExecutionManager(PlanExecutionManager planExecutionManager) {
        this.planExecutionManager = planExecutionManager;
    }

    public void setBuildDefinitionManager(BuildDefinitionManager buildDefinitionManager) {
        this.buildDefinitionManager = buildDefinitionManager;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setVariableDefinitionManager(VariableDefinitionManager variableDefinitionManager) {
        this.variableDefinitionManager = variableDefinitionManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(String discriminator) {
        this.discriminator = discriminator;
    }

    public int hashCode() {
        return new HashCodeBuilder(457, 23).append((Object)this.getPlanKey()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImmutablePlan)) {
            return false;
        }
        ImmutablePlan rhs = (ImmutablePlan)o;
        return new EqualsBuilder().append((Object)this.getPlanKey(), (Object)rhs.getPlanKey()).isEquals();
    }

    @Override
    public int compareTo(Plan plan) {
        return new CompareToBuilder().append((Object)this.getPlanKey(), (Object)plan.getPlanKey()).toComparison();
    }
}

