/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanPermissionsService;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.PermissionsServiceUtils;
import com.atlassian.bamboo.security.acegi.acls.BambooAclHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.user.Authority;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;

public class DefaultPlanPermissionsService
implements PlanPermissionsService {
    private static final Collection<BambooPermission> SUPPORTED_PERMISSIONS = ImmutableSet.of((Object)BambooPermission.READ, (Object)BambooPermission.WRITE, (Object)BambooPermission.BUILD, (Object)BambooPermission.CLONE, (Object)BambooPermission.ADMINISTRATION);
    private static final Multimap<BambooPermission, BambooPermission> PERMISSION_DEPENDENCIES = ImmutableMultimap.builder().put((Object)BambooPermission.WRITE, (Object)BambooPermission.READ).put((Object)BambooPermission.BUILD, (Object)BambooPermission.READ).put((Object)BambooPermission.CLONE, (Object)BambooPermission.READ).put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.WRITE).put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.BUILD).put((Object)BambooPermission.ADMINISTRATION, (Object)BambooPermission.CLONE).build();
    private final Function<String, ManagedLock> lockFactory = ManagedLocks.weakManagedLockFactory();
    private final TransactionAndHibernateTemplate hibernateTemplate;
    private final HibernateMutableAclService aclService;
    private final BambooAclHelper aclHelper;
    private final PlanManager planManager;
    private final BambooPermissionManager bambooPermissionManager;
    private final BambooUserManager bambooUserManager;

    @Autowired
    public DefaultPlanPermissionsService(TransactionAndHibernateTemplate hibernateTemplate, HibernateMutableAclService aclService, BambooAclHelper aclHelper, PlanManager planManager, BambooPermissionManager bambooPermissionManager, BambooUserManager bambooUserManager) {
        this.hibernateTemplate = hibernateTemplate;
        this.aclService = aclService;
        this.aclHelper = aclHelper;
        this.planManager = planManager;
        this.bambooPermissionManager = bambooPermissionManager;
        this.bambooUserManager = bambooUserManager;
    }

    @NotNull
    private MutableAcl getAclForPlan(@NotNull Plan plan) {
        return this.aclService.readMutableAclById((ObjectIdentity)new HibernateObjectIdentityImpl(plan));
    }

    @NotNull
    public Iterable<String> listUsersWithPermissionsForPlan(@NotNull String planKey) {
        Plan plan = this.validatePlan(planKey);
        this.hasPermissionForPlan(plan);
        MutableAcl planAcl = this.getAclForPlan(plan);
        return this.aclHelper.listUsersWithPermissions((Acl)planAcl, this.supportedPermissions());
    }

    @NotNull
    public List<BambooPermission> getUserPermissionsForPlan(@NotNull String planKey, @NotNull String username) {
        Plan plan = this.validatePlan(planKey);
        this.hasPermissionForPlan(plan);
        User user = this.validateUser(username);
        MutableAcl planAcl = this.getAclForPlan(plan);
        return this.aclHelper.getUserPermissions((Acl)planAcl, user.getName(), this.supportedPermissions());
    }

    public boolean addUserPermissionsToPlan(@NotNull String planKey, @NotNull String username, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.withExclusiveLock(planKey, () -> {
            Plan plan = this.validatePlan(planKey);
            this.hasPermissionForPlan(plan);
            User user = this.validateUser(username);
            this.validatePermissionsForPlan(permissionsToAdd);
            this.validateDependenciesAfterGranting(this.getUserPermissionsForPlan(planKey, user.getName()), permissionsToAdd);
            List<String> permissionKeysToAdd = permissionsToAdd.stream().map(permission -> BambooAclUpdateHelper.createUserPermissionKey(user.getName(), permission.getName())).collect(Collectors.toList());
            return this.addPermissionKeysToPlan(planKey, permissionKeysToAdd);
        });
    }

    public boolean removeUserPermissionsFromPlan(@NotNull String planKey, @NotNull String username, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.withExclusiveLock(planKey, () -> {
            Plan plan = this.validatePlan(planKey);
            this.hasPermissionForPlan(plan);
            User user = this.validateUser(username);
            this.validateDependenciesAfterRevoking(this.getUserPermissionsForPlan(planKey, user.getName()), permissionsToRemove);
            List<String> permissionKeysToAdd = permissionsToRemove.stream().map(permission -> BambooAclUpdateHelper.createUserPermissionKey(user.getName(), permission.getName())).collect(Collectors.toList());
            return this.removePermissionKeysFromPlan(planKey, permissionKeysToAdd);
        });
    }

    @NotNull
    public Iterable<String> listGroupsWithPermissionsForPlan(@NotNull String planKey) {
        Plan plan = this.validatePlan(planKey);
        this.hasPermissionForPlan(plan);
        MutableAcl planAcl = this.getAclForPlan(plan);
        return this.aclHelper.listGroupsWithPermissions((Acl)planAcl, this.supportedPermissions());
    }

    @NotNull
    public List<BambooPermission> getGroupPermissionsForPlan(@NotNull String planKey, @NotNull String groupName) {
        Plan plan = this.validatePlan(planKey);
        this.hasPermissionForPlan(plan);
        Group group = this.validateGroup(groupName);
        MutableAcl planAcl = this.getAclForPlan(plan);
        return this.aclHelper.getGroupPermissions((Acl)planAcl, group.getName(), this.supportedPermissions());
    }

    public boolean addGroupPermissionsToPlan(@NotNull String planKey, @NotNull String groupName, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.withExclusiveLock(planKey, () -> {
            Plan plan = this.validatePlan(planKey);
            this.hasPermissionForPlan(plan);
            Group group = this.validateGroup(groupName);
            this.validatePermissionsForPlan(permissionsToAdd);
            this.validateDependenciesAfterGranting(this.getGroupPermissionsForPlan(planKey, group.getName()), permissionsToAdd);
            List<String> permissionKeysToAdd = permissionsToAdd.stream().map(permission -> BambooAclUpdateHelper.createGroupPermissionKey(group.getName(), permission.getName())).collect(Collectors.toList());
            return this.addPermissionKeysToPlan(planKey, permissionKeysToAdd);
        });
    }

    public boolean removeGroupPermissionsFromPlan(@NotNull String planKey, @NotNull String groupName, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.withExclusiveLock(planKey, () -> {
            Plan plan = this.validatePlan(planKey);
            this.hasPermissionForPlan(plan);
            Group group = this.validateGroup(groupName);
            this.validateDependenciesAfterRevoking(this.getGroupPermissionsForPlan(planKey, group.getName()), permissionsToRemove);
            List<String> permissionKeysToRemove = permissionsToRemove.stream().map(permission -> BambooAclUpdateHelper.createGroupPermissionKey(group.getName(), permission.getName())).collect(Collectors.toList());
            return this.removePermissionKeysFromPlan(planKey, permissionKeysToRemove);
        });
    }

    @NotNull
    public List<BambooPermission> getLoggedInPermissionsForPlan(@NotNull String planKey) {
        Plan plan = this.validatePlan(planKey);
        this.hasPermissionForPlan(plan);
        MutableAcl planAcl = this.getAclForPlan(plan);
        return this.aclHelper.getLoggedInPermissions((Acl)planAcl, this.supportedPermissions());
    }

    public boolean addLoggedInPermissionsToPlan(@NotNull String planKey, @NotNull List<BambooPermission> permissionsToAdd) {
        return this.withExclusiveLock(planKey, () -> {
            Plan plan = this.validatePlan(planKey);
            this.hasPermissionForPlan(plan);
            this.validatePermissionsForPlan(permissionsToAdd);
            this.validateDependenciesAfterGranting(this.getLoggedInPermissionsForPlan(planKey), permissionsToAdd);
            List<String> permissionKeysToAdd = permissionsToAdd.stream().map(permission -> BambooAclUpdateHelper.createRolePermissionKey(Authority.USER.getAuthority(), permission.getName())).collect(Collectors.toList());
            return this.addPermissionKeysToPlan(planKey, permissionKeysToAdd);
        });
    }

    public boolean removeLoggedInPermissionsFromPlan(@NotNull String planKey, @NotNull List<BambooPermission> permissionsToRemove) {
        return this.withExclusiveLock(planKey, () -> {
            Plan plan = this.validatePlan(planKey);
            this.hasPermissionForPlan(plan);
            this.validateDependenciesAfterRevoking(this.getLoggedInPermissionsForPlan(planKey), permissionsToRemove);
            List<String> permissionKeysToRemove = permissionsToRemove.stream().map(permission -> BambooAclUpdateHelper.createRolePermissionKey(Authority.USER.getAuthority(), permission.getName())).collect(Collectors.toList());
            return this.removePermissionKeysFromPlan(planKey, permissionKeysToRemove);
        });
    }

    @NotNull
    public List<BambooPermission> getAnonymousPermissionsForPlan(@NotNull String planKey) {
        Plan plan = this.validatePlan(planKey);
        this.hasPermissionForPlan(plan);
        MutableAcl planAcl = this.getAclForPlan(plan);
        return this.aclHelper.getAnonymousPermissions((Acl)planAcl, this.supportedPermissions());
    }

    public boolean addAnonymousPermissionsToPlan(@NotNull String planKey) {
        return this.withExclusiveLock(planKey, () -> {
            Plan plan = this.validatePlan(planKey);
            this.hasPermissionForPlan(plan);
            String permission = BambooAclUpdateHelper.createRolePermissionKey(Authority.ANONYMOUS.getAuthority(), BambooPermission.READ.getName());
            return this.addPermissionKeysToPlan(planKey, Collections.singletonList(permission));
        });
    }

    public boolean removeAnonymousPermissionsFromPlan(@NotNull String planKey) {
        return this.withExclusiveLock(planKey, () -> {
            Plan plan = this.validatePlan(planKey);
            this.hasPermissionForPlan(plan);
            String permission = BambooAclUpdateHelper.createRolePermissionKey(Authority.ANONYMOUS.getAuthority(), BambooPermission.READ.getName());
            return this.removePermissionKeysFromPlan(planKey, Collections.singletonList(permission));
        });
    }

    @NotNull
    public Collection<BambooPermission> supportedPermissions() {
        return SUPPORTED_PERMISSIONS;
    }

    @NotNull
    public Collection<BambooPermission> permissionDependencies(@NotNull BambooPermission permission) {
        return PermissionsServiceUtils.extractDependencies(PERMISSION_DEPENDENCIES, this.supportedPermissions(), permission);
    }

    private Plan validatePlan(String planKey) {
        Plan plan = this.planManager.getPlanByKey(PlanKeys.getPlanKey((String)planKey));
        Preconditions.checkArgument((plan != null ? 1 : 0) != 0, (Object)String.format("Plan: %s does not exist", planKey));
        return plan;
    }

    private void hasPermissionForPlan(Plan plan) {
        if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.ADMINISTRATION, plan.getPlanKey())) {
            throw new AccessDeniedException(String.format("Not allowed to access plan: %s permissions", plan.getPlanKey()));
        }
    }

    private User validateUser(String username) {
        return PermissionsServiceUtils.validateUser(username, this.bambooUserManager);
    }

    private Group validateGroup(String groupName) {
        return PermissionsServiceUtils.validateGroup(groupName, this.bambooUserManager);
    }

    private void validatePermissionsForPlan(List<BambooPermission> permissions) throws IllegalArgumentException {
        PermissionsServiceUtils.validatePermissions(permissions, this.supportedPermissions(), "plan");
    }

    private void validateDependenciesAfterGranting(List<BambooPermission> currentPermissions, List<BambooPermission> permissionsToAdd) {
        Sets.SetView effectivePermissions = Sets.union(new HashSet<BambooPermission>(currentPermissions), new HashSet<BambooPermission>(permissionsToAdd));
        PermissionsServiceUtils.validateDependenciesAfterGranting((Collection<BambooPermission>)effectivePermissions, this::permissionDependencies);
    }

    private void validateDependenciesAfterRevoking(List<BambooPermission> currentPermissions, List<BambooPermission> permissionsToRemove) {
        Sets.SetView effectivePermissions = Sets.difference(new HashSet<BambooPermission>(currentPermissions), new HashSet<BambooPermission>(permissionsToRemove));
        PermissionsServiceUtils.validateDependenciesAfterRevoking((Collection<BambooPermission>)effectivePermissions, this::permissionDependencies);
    }

    private boolean addPermissionKeysToPlan(String planKey, List<String> permissionKeysToAdd) {
        Plan plan = this.validatePlan(planKey);
        MutableAcl acl = this.getAclForPlan(plan);
        return this.aclHelper.addPermissionKeys(acl, permissionKeysToAdd);
    }

    private boolean removePermissionKeysFromPlan(String planKey, List<String> permissionKeysToRemove) {
        Plan plan = this.validatePlan(planKey);
        MutableAcl acl = this.getAclForPlan(plan);
        return this.aclHelper.removePermissionKeys(acl, permissionKeysToRemove);
    }

    private <T> T withExclusiveLock(String planKey, Supplier<T> supplier) {
        return (T)this.lockFactory.apply(planKey).withLock(() -> this.hibernateTemplate.execute(arg_0 -> DefaultPlanPermissionsService.lambda$null$14((Supplier)supplier, arg_0)));
    }

    private static /* synthetic */ Object lambda$null$14(Supplier supplier, TransactionStatus transactionStatus) {
        return supplier.get();
    }
}

