/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.build.BuildDetectionAction;
import com.atlassian.bamboo.chains.BuildExecution;
import com.atlassian.bamboo.plan.ExecutionRequestResult;
import com.atlassian.bamboo.plan.ExecutionRequestResultImpl;
import com.atlassian.bamboo.plan.ExecutionStatus;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanExecutionManagerCallWatcher;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.util.AcquisitionPolicy;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegatingPlanExecutionManager
implements PlanExecutionManager {
    private static final Logger log = Logger.getLogger(DelegatingPlanExecutionManager.class);
    private final PlanExecutionManager target;
    private final PlanExecutionManagerCallWatcher planExecutionManagerCallWatcher;

    public DelegatingPlanExecutionManager(@NotNull PlanExecutionManager target, @NotNull PlanExecutionManagerCallWatcher planExecutionManagerCallWatcher) {
        this.target = target;
        this.planExecutionManagerCallWatcher = planExecutionManagerCallWatcher;
    }

    private ExecutionRequestResult notStarting() {
        return new ExecutionRequestResultImpl((ErrorCollection)new SimpleErrorCollection("Not starting new builds since server is not running"), null);
    }

    public boolean isBusy() {
        return this.target.isBusy();
    }

    public boolean isBusy(@NotNull PlanKey planKey) {
        return this.target.isBusy(planKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExecutionRequestResult start(@NotNull ImmutableChain chain, @NotNull BuildDetectionAction buildDetectionAction, @NotNull AcquisitionPolicy acquisitionPolicy) {
        if (this.planExecutionManagerCallWatcher.startCall()) {
            try {
                ExecutionRequestResult executionRequestResult = this.target.start(chain, buildDetectionAction, acquisitionPolicy);
                return executionRequestResult;
            }
            finally {
                this.planExecutionManagerCallWatcher.endCall();
            }
        }
        return this.notStarting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExecutionRequestResult start(@NotNull Triggerable triggerable, @NotNull BuildDetectionAction buildDetectionAction, @NotNull AcquisitionPolicy acquisitionPolicy) {
        if (this.planExecutionManagerCallWatcher.startCall()) {
            try {
                ExecutionRequestResult executionRequestResult = this.target.start(triggerable, buildDetectionAction, acquisitionPolicy);
                return executionRequestResult;
            }
            finally {
                this.planExecutionManagerCallWatcher.endCall();
            }
        }
        return this.notStarting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExecutionRequestResult start(@NotNull ImmutableChain chain, @Nullable PlanExecutionConfig planExecutionConfig, @NotNull String triggerReasonPluginKey, @NotNull String planTriggerPluginKey, @NotNull Map<String, String> params, @NotNull Map<String, String> variables, @NotNull AcquisitionPolicy acquisitionPolicy) {
        if (this.planExecutionManagerCallWatcher.startCall()) {
            try {
                ExecutionRequestResult executionRequestResult = this.target.start(chain, planExecutionConfig, triggerReasonPluginKey, planTriggerPluginKey, params, variables, acquisitionPolicy);
                return executionRequestResult;
            }
            finally {
                this.planExecutionManagerCallWatcher.endCall();
            }
        }
        return this.notStarting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExecutionRequestResult startManualExecution(@NotNull ImmutableChain chain, @NotNull User user, @NotNull Map<String, String> params, @NotNull Map<String, String> variables) {
        if (this.planExecutionManagerCallWatcher.startCall()) {
            try {
                ExecutionRequestResult executionRequestResult = this.target.startManualExecution(chain, user, params, variables);
                return executionRequestResult;
            }
            finally {
                this.planExecutionManagerCallWatcher.endCall();
            }
        }
        return this.notStarting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExecutionRequestResult startManualExecution(@NotNull ImmutableChain chain, PlanExecutionConfig planExecutionConfig, @NotNull User user, @NotNull Map<String, String> params, @NotNull Map<String, String> variables) {
        if (this.planExecutionManagerCallWatcher.startCall()) {
            try {
                ExecutionRequestResult executionRequestResult = this.target.startManualExecution(chain, planExecutionConfig, user, params, variables);
                return executionRequestResult;
            }
            finally {
                this.planExecutionManagerCallWatcher.endCall();
            }
        }
        return this.notStarting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExecutionRequestResult startManualExecution(@NotNull ImmutableChain chain, PlanExecutionConfig planExecutionConfig, @NotNull User user, @NotNull String triggerReasonPluginKey, @NotNull String planTriggerPluginKey, @NotNull Map<String, String> params, @NotNull Map<String, String> variables) {
        if (this.planExecutionManagerCallWatcher.startCall()) {
            try {
                ExecutionRequestResult executionRequestResult = this.target.startManualExecution(chain, planExecutionConfig, user, params, variables);
                return executionRequestResult;
            }
            finally {
                this.planExecutionManagerCallWatcher.endCall();
            }
        }
        return this.notStarting();
    }

    public boolean isBuildingAllowed(@NotNull ImmutableChain chain) {
        return !this.planExecutionManagerCallWatcher.isShutdownRequested() && this.target.isBuildingAllowed(chain);
    }

    @NotNull
    public List<CurrentlyBuilding> getCurrentlyBuildingForPlan(PlanKey planKey) {
        return this.target.getCurrentlyBuildingForPlan(planKey);
    }

    @NotNull
    public List<CurrentlyBuilding> getCurrentlyBuildingForPlanResult(PlanResultKey planKey) {
        return this.target.getCurrentlyBuildingForPlanResult(planKey);
    }

    public void stopPlan(@NotNull PlanResultKey planResultKey, boolean abandonResult, String userName) {
        this.target.stopPlan(planResultKey, abandonResult, userName);
    }

    public void stopPlan(@NotNull PlanKey planKey, boolean abandonResult, String userName) throws InterruptedException {
        this.target.stopPlan(planKey, abandonResult, userName);
    }

    public void stopRequest(@NotNull PlanKey planKey) {
        this.target.stopRequest(planKey);
    }

    public int numberOfExecutions(@NotNull PlanKey planKey) {
        return this.target.numberOfExecutions(planKey);
    }

    @NotNull
    public Collection<? extends ExecutionStatus> getExecutionStatus(@NotNull PlanKey planKey) {
        return this.target.getExecutionStatus(planKey);
    }

    @Nullable
    public ExecutionStatus getExecutionStatus(@NotNull PlanResultKey planResultKey) {
        return this.target.getExecutionStatus(planResultKey);
    }

    @Nullable
    public BuildExecution getJobExecution(@NotNull PlanResultKey planResultKey) {
        return this.target.getJobExecution(planResultKey);
    }

    public Future<Boolean> shutdown() {
        return this.planExecutionManagerCallWatcher.shutdown();
    }
}

