/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plan.PlanKey;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Internal
public class DetectionQueue {
    private final Set<PlanKey> planKeySet = new HashSet<PlanKey>();
    private final Deque<PlanKey> queue = new ArrayDeque<PlanKey>();

    public synchronized boolean push(@NotNull PlanKey planKey) {
        boolean isAdded = this.planKeySet.add(planKey);
        if (isAdded) {
            this.queue.addLast(planKey);
        }
        return isAdded;
    }

    public synchronized boolean pushFront(@NotNull PlanKey planKey) {
        boolean isAdded = this.planKeySet.add(planKey);
        if (!isAdded) {
            this.queue.remove(planKey);
        }
        this.queue.addFirst(planKey);
        return isAdded;
    }

    @NotNull
    public synchronized PlanKey pop() {
        PlanKey planKey = this.queue.removeFirst();
        this.planKeySet.remove(planKey);
        return planKey;
    }

    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public synchronized int getKeysSize() {
        return this.planKeySet.size();
    }
}

