/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationAccessor;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentMap;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.buildqueue.manager.ExecutableAgentsMatrix;
import com.atlassian.bamboo.buildqueue.manager.ExecutableAgentsMatrixImpl;
import com.atlassian.bamboo.capability.CapabilitySetProvider;
import com.atlassian.bamboo.chains.BuildExecution;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plan.ExecutableAgentsHelper;
import com.atlassian.bamboo.plan.ExecutionStatus;
import com.atlassian.bamboo.plan.ExecutionStatusProvider;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.utils.scopedcaches.ThreadScopedCaches;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.BuildAgentRequirementFilter;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementsMatcher;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManagerUtils;
import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirementSet;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;

public class ExecutableAgentsHelperImpl
implements ExecutableAgentsHelper {
    private static final Logger log = Logger.getLogger(ExecutableAgentsHelperImpl.class);
    private final CachedPlanManager cachedPlanManager;
    private final ExecutionStatusProvider executionStatusProvider;
    @Lazy
    @Inject
    private AgentManager agentManager;
    private final AgentAssignmentService agentAssignmentService;
    private final CapabilityRequirementsMatcher capabilityRequirementsMatcher;
    private final CapabilitySetManager capabilitySetManager;
    private final ElasticInstanceManager elasticInstanceManager;
    private final ElasticImageConfigurationAccessor elasticImageConfigurationManager;
    @Lazy
    @Inject
    private BuildQueueManager buildQueueManager;
    @Inject
    private EnvironmentService environmentService;
    private final PluginAccessor pluginAccessor;
    private final ThreadScopedCaches.Key<String, Map<Class<? extends CapabilitySet>, CapabilitySet>> CAPABILITY_CACHE_KEY = ThreadScopedCaches.makeKey(this.getClass());
    private final ThreadScopedCaches.Key<String, AgentAssignmentMap> ASSIGNMENT_CACHE_KEY = ThreadScopedCaches.makeKey(this.getClass());
    private final ThreadScopedCaches.Key<String, List<BuildAgentRequirementFilter>> AGENT_FILTERS_CACHE_KEY = ThreadScopedCaches.makeKey(this.getClass());

    public ExecutableAgentsHelperImpl(CachedPlanManager cachedPlanManager, ExecutionStatusProvider executionStatusProvider, PluginAccessor pluginAccessor, AgentAssignmentService agentAssignmentService, CapabilityRequirementsMatcher capabilityRequirementsMatcher, CapabilitySetManager capabilitySetManager, ElasticInstanceManager elasticInstanceManager, ElasticImageConfigurationAccessor elasticImageConfigurationAccessor) {
        this.cachedPlanManager = cachedPlanManager;
        this.executionStatusProvider = executionStatusProvider;
        this.pluginAccessor = pluginAccessor;
        this.agentAssignmentService = agentAssignmentService;
        this.capabilityRequirementsMatcher = capabilityRequirementsMatcher;
        this.capabilitySetManager = capabilitySetManager;
        this.elasticInstanceManager = elasticInstanceManager;
        this.elasticImageConfigurationManager = elasticImageConfigurationAccessor;
    }

    @Override
    @Transactional
    @NotNull
    public Collection<BuildAgent> getExecutableAgents(@NotNull ExecutableAgentsHelper.ExecutorQuery executorQuery) {
        ImmutableRequirementSet requirementSet = executorQuery.getRequirements();
        log.debug((Object)("Trying to match requirements... " + requirementSet));
        List buildAgents = this.agentManager.getAllAgents();
        log.debug((Object)("found " + buildAgents.size() + " agents to be tested"));
        log.debug((Object)"check plugin filters first");
        Collection<BuildAgent> pluginFilterResults = this.filterWithPlugins(buildAgents, executorQuery.getContext(), executorQuery.getRequirements());
        log.debug((Object)("found " + pluginFilterResults.size() + " agents which pass plugin filter"));
        List<BuildAgent> result = pluginFilterResults.stream().filter(agent -> this.canExecute((BuildAgent)agent, requirementSet, executorQuery)).collect(Collectors.toList());
        log.debug((Object)("found " + result.size() + " agents which can execute buildable"));
        return result;
    }

    @Override
    public boolean canExecute(@NotNull BuildAgent buildAgent, @NotNull CommonContext context, @NotNull ImmutableRequirementSet requirements) {
        ExecutableAgentsHelper.ExecutorQuery executorQuery = ExecutableAgentsHelper.ExecutorQuery.newQuery(requirements, AgentAssignmentServiceHelper.asExecutable((CommonContext)context)).withDisabledExcluded().withOfflineExcluded();
        Collection<BuildAgent> buildAgents = this.filterWithPlugins(Collections.singleton(buildAgent), context, requirements);
        return !buildAgents.isEmpty() && this.canExecute(buildAgent, requirements, executorQuery);
    }

    private boolean canExecute(BuildAgent buildAgent, ImmutableRequirementSet requirementSet, ExecutableAgentsHelper.ExecutorQuery executorQuery) {
        log.debug((Object)("Trying to match requirements... " + requirementSet));
        if (!this.shouldConsiderAgent(buildAgent, executorQuery)) {
            log.trace((Object)("skip " + buildAgent));
            return false;
        }
        AgentAssignmentMap agentAssignments = (AgentAssignmentMap)ThreadScopedCaches.getValue(this.ASSIGNMENT_CACHE_KEY, (Object)"agentAssignments", () -> ((AgentAssignmentService)this.agentAssignmentService).getAgentAssignments());
        AgentAssignmentMap.AgentAssignmentCheckResult agentAssignmentCheckResult = agentAssignments.checkAssignmentRequirements(executorQuery.getAssignedExecutables(), AgentAssignmentServiceHelper.asExecutors((BuildAgent)buildAgent));
        if (!agentAssignmentCheckResult.isCanExecute()) {
            log.debug((Object)("Agent " + buildAgent.getName() + " failed assignment check: " + agentAssignmentCheckResult));
            return false;
        }
        if (requirementSet.getRequirements().isEmpty()) {
            log.debug((Object)("No requirements, added agent " + buildAgent.getName() + "(id = " + buildAgent.getId() + ")"));
            return true;
        }
        CapabilitySet capabilitySet = CapabilitySetProvider.getAgentCapabilitySet(buildAgent);
        if (capabilitySet == null) {
            log.debug((Object)("Rejected agent as capability set is null " + buildAgent.getName()));
            return false;
        }
        Map sharedCapabilityCache = (Map)ThreadScopedCaches.getValue(this.CAPABILITY_CACHE_KEY, (Object)"sharedCapabilityCache", HashMap::new);
        CapabilitySet sharedCapabilitySet = this.getSharedCapabilitySet(sharedCapabilityCache, capabilitySet);
        ReadOnlyCapabilitySet readOnlyCapabilitySet = this.capabilitySetManager.getCombinedCapabilitySet(capabilitySet, sharedCapabilitySet);
        if (!this.capabilityRequirementsMatcher.matches(readOnlyCapabilitySet, requirementSet)) {
            log.debug((Object)("Capabilities don't match for agent and requirement " + buildAgent));
            return false;
        }
        log.debug((Object)("Added agent " + buildAgent.getName() + "(id = " + buildAgent.getId() + ")"));
        return true;
    }

    @Override
    public ExecutableAgentsMatrix getExecutableAgentsMatrix(@NotNull ExecutableAgentsHelper.ExecutorQuery executorQuery) {
        boolean matchAll;
        AgentAssignmentMap.AgentAssignmentCheckResult agentAssignmentCheckResult;
        ExecutableAgentsMatrixImpl executableAgents = new ExecutableAgentsMatrixImpl();
        AgentAssignmentMap agentAssignments = this.agentAssignmentService.getAgentAssignments();
        List buildAgents = this.agentManager.getAllNonElasticAgents();
        ImmutableRequirementSet requirementSet = executorQuery.getRequirements();
        CapabilitySet localSharedCapabilitySet = this.capabilitySetManager.getSharedLocalCapabilitySet();
        CapabilitySet remoteSharedCapabilitySet = this.capabilitySetManager.getSharedRemoteCapabilitySet();
        executableAgents.setRequirementCount(requirementSet.getRequirements().size());
        for (BuildAgent buildAgent : buildAgents) {
            if (!this.shouldConsiderAgent(buildAgent, executorQuery)) continue;
            agentAssignmentCheckResult = agentAssignments.checkAssignmentRequirements(executorQuery.getAssignedExecutables(), AgentAssignmentServiceHelper.asExecutors((BuildAgent)buildAgent));
            if (!agentAssignmentCheckResult.isCanExecute()) {
                log.debug((Object)("Agent " + buildAgent.getName() + " failed assignment check: " + agentAssignmentCheckResult));
                continue;
            }
            if (requirementSet.getRequirements().isEmpty()) {
                executableAgents.addBuildAgent(buildAgent);
                continue;
            }
            matchAll = true;
            CapabilitySet capabilitySet = CapabilitySetProvider.getAgentCapabilitySet(buildAgent);
            ReadOnlyCapabilitySet readOnlyCapabilitySet = buildAgent instanceof LocalBuildAgent ? this.capabilitySetManager.getCombinedCapabilitySet(capabilitySet, localSharedCapabilitySet) : this.capabilitySetManager.getCombinedCapabilitySet(capabilitySet, remoteSharedCapabilitySet);
            for (ImmutableRequirement requirement : requirementSet.getRequirements()) {
                if (this.capabilityRequirementsMatcher.matches(readOnlyCapabilitySet, requirement)) {
                    executableAgents.put(requirement.getKey(), buildAgent);
                    continue;
                }
                executableAgents.addRequirementWithNoAgentMatch(requirement);
                matchAll = false;
            }
            if (matchAll) {
                executableAgents.addBuildAgent(buildAgent);
                continue;
            }
            if (agentAssignmentCheckResult != AgentAssignmentMap.AgentAssignmentCheckResult.AGENT_MEETS_ASSIGNMENT_REQUIREMENTS) continue;
            executableAgents.addDedicatedNonMatchingBuildAgent(buildAgent);
        }
        executableAgents.setElasticBambooEnabled(this.elasticInstanceManager.isElasticSupportEnabled());
        if (this.elasticInstanceManager.isElasticSupportEnabled()) {
            for (ElasticImageConfiguration elasticImageConfiguration : this.elasticImageConfigurationManager.getAllElasticImageConfigurationsForCurrentRegion()) {
                agentAssignmentCheckResult = agentAssignments.checkAssignmentRequirements(executorQuery.getAssignedExecutables(), AgentAssignmentServiceHelper.asExecutors((ElasticImageConfiguration)elasticImageConfiguration));
                if (!agentAssignmentCheckResult.isCanExecute()) {
                    log.debug((Object)("Image " + elasticImageConfiguration.getConfigurationName() + " failed assignment check: " + agentAssignmentCheckResult));
                    continue;
                }
                if (requirementSet.getRequirements().isEmpty()) {
                    executableAgents.addImageMatch(elasticImageConfiguration);
                    continue;
                }
                matchAll = true;
                for (ImmutableRequirement requirement : requirementSet.getRequirements()) {
                    if (this.capabilityRequirementsMatcher.matches((ReadOnlyCapabilitySet)elasticImageConfiguration.getCapabilitySet(), requirement)) {
                        executableAgents.addImageToMatrix(requirement.getKey(), elasticImageConfiguration);
                        continue;
                    }
                    executableAgents.addRequirementWithNoImageMatch(requirement);
                    matchAll = false;
                }
                if (matchAll) {
                    executableAgents.addImageMatch(elasticImageConfiguration);
                    continue;
                }
                if (agentAssignmentCheckResult != AgentAssignmentMap.AgentAssignmentCheckResult.AGENT_MEETS_ASSIGNMENT_REQUIREMENTS) continue;
                executableAgents.addDedicatedNonMatchingImage(elasticImageConfiguration);
            }
        }
        return executableAgents;
    }

    @Override
    public boolean isAgentEligibleForReceivingJobs(long agentId) {
        BuildAgent agent = this.agentManager.getAgent(agentId);
        return agent != null && agent.isActive();
    }

    @Override
    public Collection<ElasticImageConfiguration> getExecutableImages(@NotNull ExecutableAgentsHelper.ExecutorQuery executorQuery) {
        Iterable<AgentAssignmentService.AgentAssignmentExecutable> executables = executorQuery.getAssignedExecutables();
        AgentAssignmentMap agentAssignments = this.agentAssignmentService.getAgentAssignments();
        ArrayList<ElasticImageConfiguration> elasticImageConfigurations = new ArrayList<ElasticImageConfiguration>();
        if (this.elasticInstanceManager.isElasticSupportEnabled()) {
            for (ElasticImageConfiguration elasticImageConfiguration : this.elasticImageConfigurationManager.getAllElasticImageConfigurationsForCurrentRegion()) {
                if (!executorQuery.areDisabledIncluded() && elasticImageConfiguration.isDisabled()) continue;
                ImmutableRequirementSet requirements = executorQuery.getRequirements();
                AgentAssignmentMap.AgentAssignmentCheckResult agentAssignmentCheckResult = agentAssignments.checkAssignmentRequirements(executables, AgentAssignmentServiceHelper.asExecutors((ElasticImageConfiguration)elasticImageConfiguration));
                if (!agentAssignmentCheckResult.isCanExecute() || !this.capabilityRequirementsMatcher.matches((ReadOnlyCapabilitySet)elasticImageConfiguration.getCapabilitySet(), requirements)) continue;
                elasticImageConfigurations.add(elasticImageConfiguration);
            }
        }
        return elasticImageConfigurations;
    }

    @Override
    @Transactional
    public boolean planHasExecutableAgents(@NotNull PlanKey planKey, boolean includeDisabled) {
        boolean planFoundInQueue = false;
        for (BuildQueueManager.QueuedResultKey queuedExecutable : this.buildQueueManager.getQueuedExecutables()) {
            Set executorsForQueuedExecutable;
            ResultKey resultKey = queuedExecutable.getResultKey();
            if (!resultKey.getEntityKey().equals(planKey) || (executorsForQueuedExecutable = this.buildQueueManager.getExecutorsForQueuedExecutable(resultKey)) == null) continue;
            planFoundInQueue = true;
            if (executorsForQueuedExecutable.isEmpty()) continue;
            return true;
        }
        if (planFoundInQueue) {
            return false;
        }
        Collection executionStatuses = this.executionStatusProvider.getExecutionStatus(planKey);
        if (!executionStatuses.isEmpty()) {
            return true;
        }
        ImmutableBuildable buildable = (ImmutableBuildable)this.cachedPlanManager.getPlanByKey(planKey, ImmutableBuildable.class);
        if (buildable != null) {
            ExecutableAgentsHelper.ExecutorQuery executorQuery = ExecutableAgentsHelper.ExecutorQuery.newQuery((MinimalRequirementSet)buildable.getEffectiveRequirementSet(), AgentAssignmentServiceHelper.asExecutable((ImmutableBuildable)buildable)).withOfflineExcluded();
            if (includeDisabled) {
                executorQuery.withDisabledIncluded();
            }
            return !this.getExecutableAgents(executorQuery).isEmpty();
        }
        throw new IllegalArgumentException(planKey + " is not a key of an existing job");
    }

    @Override
    @Transactional
    public boolean planHasExecutableAgents(@NotNull PlanResultKey planResultKey) {
        ImmutableBuildable buildable;
        Set executorsForQueuedExecutable = this.buildQueueManager.getExecutorsForQueuedExecutable((ResultKey)planResultKey);
        if (executorsForQueuedExecutable != null) {
            return executorsForQueuedExecutable.isEmpty();
        }
        ExecutionStatus executionStatus = this.executionStatusProvider.getExecutionStatus(planResultKey);
        if (executionStatus != null) {
            return true;
        }
        BuildExecution buildExecution = this.executionStatusProvider.getJobExecution(planResultKey);
        if (buildExecution != null && (buildable = (ImmutableBuildable)this.cachedPlanManager.getPlanByKey(planResultKey.getPlanKey(), ImmutableBuildable.class)) != null) {
            ExecutableAgentsHelper.ExecutorQuery executorQuery = ExecutableAgentsHelper.ExecutorQuery.newQuery((MinimalRequirementSet)buildable.getEffectiveRequirementSet(), AgentAssignmentServiceHelper.asExecutable((ImmutableBuildable)buildable)).withContext((CommonContext)buildExecution.getBuildContext()).withOfflineExcluded().withDisabledIncluded();
            return !this.getExecutableAgents(executorQuery).isEmpty();
        }
        throw new IllegalArgumentException(planResultKey + " is not a key of a running job in jobHasExecutableAgents");
    }

    @Override
    @NotNull
    public Collection<ImmutableBuildable> getExecutableBuildables(@NotNull ExecutableAgentsHelper.ExecutableQuery executableQuery) {
        return this.getExecutableBuildables(executableQuery, ImmutableBuildable.class);
    }

    @Override
    @NotNull
    public Collection<Environment> getExecutableEnvironments(@NotNull ExecutableAgentsHelper.ExecutableQuery executableQuery) {
        ArrayList<Environment> executableEnvironments = new ArrayList<Environment>();
        ReadOnlyCapabilitySet capabilitySet = executableQuery.getCapabilities();
        Iterable<AgentAssignmentService.AgentAssignmentExecutor> executors = executableQuery.getExecutors();
        for (Environment environment : this.environmentService.getAllEnvironments()) {
            ImmutableRequirementSet requirementSet = environment.getRequirementSet();
            if (!this.capabilityRequirementsMatcher.matches(capabilitySet, requirementSet)) continue;
            if (Iterables.isEmpty(executors)) {
                executableEnvironments.add(environment);
                continue;
            }
            AgentAssignmentMap.AgentAssignmentCheckResult agentAssignmentCheckResult = this.agentAssignmentService.getAgentAssignments().checkAssignmentRequirements(AgentAssignmentServiceHelper.environmentToExecutables((long)environment.getId(), (long)environment.getDeploymentProjectId()), executors);
            if (!agentAssignmentCheckResult.isCanExecute()) continue;
            executableEnvironments.add(environment);
        }
        return executableEnvironments;
    }

    @NotNull
    private Collection<BuildAgent> filterWithPlugins(@NotNull Collection<BuildAgent> executableAgents, @Nullable CommonContext context, ImmutableRequirementSet requirements) {
        if (context == null) {
            return executableAgents;
        }
        List agentFilters = (List)ThreadScopedCaches.getValue(this.AGENT_FILTERS_CACHE_KEY, (Object)"BuildAgentRequirementFilter", () -> this.pluginAccessor.getEnabledModulesByClass(BuildAgentRequirementFilter.class));
        for (BuildAgentRequirementFilter agentFilter : agentFilters) {
            executableAgents = agentFilter.filter(context, executableAgents, (MinimalRequirementSet)requirements);
        }
        return executableAgents;
    }

    private boolean shouldConsiderAgent(BuildAgent buildAgent, ExecutableAgentsHelper.ExecutorQuery executorQuery) {
        boolean onlineOrDontCare = buildAgent.isActive() || executorQuery.areOfflineIncluded();
        boolean enabledOrDontCare = buildAgent.isEnabled() || executorQuery.areDisabledIncluded();
        return onlineOrDontCare && enabledOrDontCare;
    }

    private CapabilitySet getSharedCapabilitySet(Map<Class<? extends CapabilitySet>, CapabilitySet> cache, CapabilitySet agentCapabilitySet) {
        Class<?> capabilitySetClass = agentCapabilitySet.getClass();
        CapabilitySet cachedCapabilitySet = cache.get(capabilitySetClass);
        if (cachedCapabilitySet != null) {
            return cachedCapabilitySet;
        }
        CapabilitySet sharedCapabilitySet = CapabilitySetManagerUtils.getSharedCapabilitySet(this.capabilitySetManager, agentCapabilitySet.getClass());
        cache.put(capabilitySetClass, sharedCapabilitySet);
        return sharedCapabilitySet;
    }

    @NotNull
    private <T extends ImmutableBuildable> Collection<T> getExecutableBuildables(@NotNull ExecutableAgentsHelper.ExecutableQuery executableQuery, @NotNull Class<T> clazz) {
        ArrayList<ImmutableBuildable> executableBuilds = new ArrayList<ImmutableBuildable>();
        for (ImmutableBuildable build : this.cachedPlanManager.getPlans(clazz)) {
            RequirementSet requirementSet = build.getEffectiveRequirementSet();
            if (!this.capabilityRequirementsMatcher.matches(executableQuery.getCapabilities(), (MinimalRequirementSet)requirementSet)) continue;
            Iterable<AgentAssignmentService.AgentAssignmentExecutor> executors = executableQuery.getExecutors();
            if (Iterables.isEmpty(executors)) {
                executableBuilds.add(build);
                continue;
            }
            AgentAssignmentMap.AgentAssignmentCheckResult agentAssignmentCheckResult = this.agentAssignmentService.getAgentAssignments().checkAssignmentRequirements(AgentAssignmentServiceHelper.asExecutables((ImmutableBuildable)build), executors);
            if (!agentAssignmentCheckResult.isCanExecute()) continue;
            executableBuilds.add(build);
        }
        return executableBuilds;
    }
}

