/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ServerLifecycleProvider;
import com.atlassian.bamboo.ServerLifecycleState;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.BuildSuspensionCheckBean;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.plan.AbstractPlanExecutionPermitter;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.storage.StorageCappingService;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionLimitsServiceImpl
extends AbstractPlanExecutionPermitter {
    private static final Logger log = Logger.getLogger(ExecutionLimitsServiceImpl.class);
    private final BambooLicenseManager bambooLicenseManager;
    private final BuildSuspensionCheckBean buildSuspensionCheckBean;
    private final BuildLoggerManager buildLoggerManager;
    private final ServerLifecycleProvider serverLifecycleProvider;
    private final StorageCappingService storageCappingService;

    public ExecutionLimitsServiceImpl(BambooLicenseManager bambooLicenseManager, BuildSuspensionCheckBean buildSuspensionCheckBean, BuildLoggerManager buildLoggerManager, ServerLifecycleProvider serverLifecycleProvider, StorageCappingService storageCappingService) {
        this.bambooLicenseManager = bambooLicenseManager;
        this.buildSuspensionCheckBean = buildSuspensionCheckBean;
        this.buildLoggerManager = buildLoggerManager;
        this.serverLifecycleProvider = serverLifecycleProvider;
        this.storageCappingService = storageCappingService;
    }

    public boolean isPermittedToExecuteImpl(@NotNull ImmutableChain chain, @Nullable PlanResultKey resultKey, @NotNull ErrorCollection errorCollection) {
        PlanKey planKey = chain.getPlanKey();
        ServerLifecycleState serverLifecycle = this.serverLifecycleProvider.getServerLifecycleState();
        if (serverLifecycle != ServerLifecycleState.RUNNING) {
            this.reportFailure(errorCollection, (Priority)Level.INFO, planKey, "cannot be run because the system is " + serverLifecycle);
            return false;
        }
        if (!this.bambooLicenseManager.isLicenseValid()) {
            this.reportFailure(errorCollection, (Priority)Level.WARN, planKey, "is suspended from building as Bamboo could not find a license for this instance.");
            return false;
        }
        if (this.buildSuspensionCheckBean.isSuspended()) {
            this.reportFailure(errorCollection, (Priority)Level.WARN, planKey, "is suspended from building as you are currently over your Job quota. To rectify this situation please delete some Jobs");
            return false;
        }
        if (this.storageCappingService.isHardLimitExceeded()) {
            this.reportFailure(errorCollection, (Priority)Level.WARN, planKey, "is suspended from building because your storage limit has been exceeded. Please contact your admin to re-enable builds.");
            return false;
        }
        if (chain.isSuspendedFromBuilding()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Change detection ignored for plan " + planKey + ", plan is disabled..."));
            }
            this.reportFailure(errorCollection, (Priority)Level.DEBUG, planKey, "will not build since plan is disabled");
            return false;
        }
        return true;
    }

    private void reportFailure(ErrorCollection errorCollection, Priority priority, PlanKey planKey, String msg) {
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((Key)planKey);
        log.log(priority, (Object)buildLogger.addBuildLogEntry(planKey + " " + msg));
        String message = "Change detection ignored for plan " + planKey + ", plan " + msg;
        errorCollection.addErrorMessage(message);
    }
}

