/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.CurrentlyBuildingContainer;
import com.atlassian.bamboo.chains.BuildExecution;
import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.plan.ExecutionStatus;
import com.atlassian.bamboo.plan.ExecutionStatusProvider;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class ExecutionStatusProviderImpl
implements ExecutionStatusProvider {
    @Lazy
    @Inject
    private CurrentlyBuildingContainer currentlyBuildingContainer;
    @Lazy
    @Inject
    private ChainExecutionManager chainExecutionManager;

    public int numberOfExecutions(@NotNull PlanKey planKey) {
        return this.currentlyBuildingContainer.numberOfCurrentlyBuildingForKey((Key)planKey) + this.chainExecutionManager.numberOfChainsExecuting(planKey);
    }

    @NotNull
    public Collection<? extends ExecutionStatus> getExecutionStatus(@NotNull PlanKey planKey) {
        List executionStatuses = this.currentlyBuildingContainer.getCurrentlyBuildingByKey((Key)planKey);
        if (executionStatuses.isEmpty()) {
            executionStatuses = this.chainExecutionManager.getExecutingChains(planKey);
        }
        return executionStatuses;
    }

    @Nullable
    public ExecutionStatus getExecutionStatus(@NotNull PlanResultKey planResultKey) {
        CurrentlyBuilding executionStatus = this.currentlyBuildingContainer.getCurrentlyBuildingByResultKey((ResultKey)planResultKey);
        if (executionStatus == null) {
            executionStatus = this.chainExecutionManager.getJobExecution(planResultKey);
        }
        if (executionStatus == null) {
            executionStatus = this.chainExecutionManager.getChainExecution(planResultKey);
        }
        return executionStatus;
    }

    @Nullable
    public BuildExecution getJobExecution(@NotNull PlanResultKey planResultKey) {
        return this.chainExecutionManager.getJobExecution(planResultKey);
    }
}

