/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plan.DetectionQueue;
import com.atlassian.bamboo.plan.PlanKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NotNull;

@Internal
public class ItemDetections {
    private static final Logger log = Logger.getLogger(ItemDetections.class);
    private final DetectionQueue queuedDetections = new DetectionQueue();
    private final Set<PlanKey> detectionsInProgress = Collections.synchronizedSet(new HashSet());

    public boolean queue(@NotNull PlanKey planKey) {
        return this.queue(planKey, false);
    }

    public boolean queue(@NotNull PlanKey planKey, boolean withTopPriority) {
        boolean isAdded = this.queueInternal(planKey, withTopPriority);
        if (log.isDebugEnabled()) {
            this.logQueueStats(Level.DEBUG, planKey, isAdded);
        }
        return isAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueInternal(@NotNull PlanKey planKey, boolean withTopPriority) {
        DetectionQueue detectionQueue = this.queuedDetections;
        synchronized (detectionQueue) {
            boolean isAdded;
            if (this.detectionsInProgress.contains(planKey)) {
                return true;
            }
            boolean bl = isAdded = withTopPriority ? this.queuedDetections.pushFront(planKey) : this.queuedDetections.push(planKey);
            if (isAdded) {
                this.queuedDetections.notify();
            }
            return isAdded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanKey getDetectionRequest() {
        DetectionQueue detectionQueue = this.queuedDetections;
        synchronized (detectionQueue) {
            while (this.queuedDetections.isEmpty()) {
                try {
                    this.queuedDetections.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            PlanKey dequeuedDetection = this.queuedDetections.pop();
            this.start(dequeuedDetection);
            return dequeuedDetection;
        }
    }

    public boolean start(@NotNull PlanKey planKey) {
        return this.detectionsInProgress.add(planKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(@NotNull PlanKey planKey) {
        Set<PlanKey> set = this.detectionsInProgress;
        synchronized (set) {
            this.detectionsInProgress.remove(planKey);
            this.detectionsInProgress.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEnd(@NotNull PlanKey planKey) {
        Set<PlanKey> set = this.detectionsInProgress;
        synchronized (set) {
            while (this.detectionsInProgress.contains(planKey)) {
                try {
                    this.detectionsInProgress.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public DetectionQueue getQueuedDetections() {
        return this.queuedDetections;
    }

    private void logQueueStats(Level level, @NotNull PlanKey planKey, boolean isAdded) {
        log.log((Priority)level, (Object)("Queued branch detections: " + this.queuedDetections.getKeysSize() + ", detections in progress: " + this.detectionsInProgress.size() + " plan " + planKey + " queued for detection: " + isAdded));
    }
}

