/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.build.BuildDetectionAction;
import com.atlassian.bamboo.build.pipeline.concurrent.SystemAuthorityThreadFactory;
import com.atlassian.bamboo.event.spi.EventLoggingThreadPoolExecutor;
import com.atlassian.bamboo.event.spi.ExecutorStats;
import com.atlassian.bamboo.event.spi.ExecutorStatsImpl;
import com.atlassian.bamboo.plan.ExecutionRequestResult;
import com.atlassian.bamboo.plan.NonBlockingPlanExecutionService;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.TriggerableInternalKeyImpl;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.trigger.TriggerableInternalKey;
import com.atlassian.bamboo.util.AcquisitionPolicy;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonBlockingPlanExecutionServiceImpl
implements NonBlockingPlanExecutionService {
    private static final Logger log = Logger.getLogger(NonBlockingPlanExecutionServiceImpl.class);
    private static final int THREAD_COUNT = SystemProperty.PLAN_EXECUTION_DETECTION_THREADS.getValue(4);
    private final PlanExecutionManager planExecutionManager;
    private final EventLoggingThreadPoolExecutor executor;
    private final ConcurrentMap<TriggerableInternalKey, Boolean> currentlyDetectingPlansMap = new ConcurrentHashMap<TriggerableInternalKey, Boolean>();
    private final LoadingCache<TriggerableInternalKey, BuildDetectionActionQueue> buildDetectionActionQueues = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<TriggerableInternalKey, BuildDetectionActionQueue>(){

        public BuildDetectionActionQueue load(@NotNull TriggerableInternalKey key) {
            return new BuildDetectionActionQueue();
        }
    });
    private final AtomicBoolean shuttingDown = new AtomicBoolean(false);

    public NonBlockingPlanExecutionServiceImpl(PlanExecutionManager planExecutionManager) {
        this.planExecutionManager = planExecutionManager;
        this.executor = new EventLoggingThreadPoolExecutor(THREAD_COUNT, THREAD_COUNT * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), (ThreadFactory)new SystemAuthorityThreadFactory("BAM::PlanExec"));
    }

    public void enqueueTrigger(@NotNull Triggerable triggerable, @NotNull Long triggerId, @NotNull BuildDetectionAction buildDetectionAction) {
        TriggerableInternalKeyImpl triggerableIdentifier = new TriggerableInternalKeyImpl(triggerable);
        String triggerIdString = triggerableIdentifier.getKey() + ":" + triggerId;
        BuildDetectionActionQueue planActionQueue = (BuildDetectionActionQueue)this.buildDetectionActionQueues.getUnchecked((Object)triggerableIdentifier);
        log.trace((Object)String.format("Enqueueing %s for execution, trigger id: %d", triggerableIdentifier.getKey(), triggerId));
        planActionQueue.enqueue(triggerIdString, buildDetectionAction, CacheAwareness.getDisabledCachesTimestamp());
        this.createQueuePollingJob(triggerableIdentifier, planActionQueue);
    }

    @Nullable
    public Future<ExecutionRequestResult> tryToStart(@NotNull Triggerable triggerable, final @NotNull BuildDetectionAction buildDetectionAction) {
        final TriggerableInternalKeyImpl triggerableIdentifier = new TriggerableInternalKeyImpl(triggerable);
        return this.executor.submit(new Callable<ExecutionRequestResult>(){

            @Override
            public ExecutionRequestResult call() {
                Triggerable plan = triggerableIdentifier.getTriggerable();
                if (plan != null) {
                    return NonBlockingPlanExecutionServiceImpl.this.planExecutionManager.start(plan, buildDetectionAction, AcquisitionPolicy.WAIT);
                }
                log.info((Object)("Object " + triggerableIdentifier.getKey() + " has been deleted."));
                return null;
            }

            public String toString() {
                return buildDetectionAction.getClass().getName() + " for " + triggerableIdentifier;
            }
        });
    }

    public Future<Boolean> shutdown() {
        this.shuttingDown.set(true);
        this.executor.shutdown();
        this.buildDetectionActionQueues.invalidateAll();
        final Future planExecutionManagerShutdownFuture = this.planExecutionManager.shutdown();
        log.info((Object)("Shutdown requested. Number of active threads: " + this.executor.getActiveCount()));
        return new Future<Boolean>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return NonBlockingPlanExecutionServiceImpl.this.executor.isTerminated() && planExecutionManagerShutdownFuture.isDone();
            }

            @Override
            public Boolean get() throws InterruptedException, ExecutionException {
                this.logIfNeeded();
                while (!NonBlockingPlanExecutionServiceImpl.this.executor.isTerminated()) {
                    NonBlockingPlanExecutionServiceImpl.this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                return (Boolean)planExecutionManagerShutdownFuture.get();
            }

            @Override
            public Boolean get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                this.logIfNeeded();
                long time = System.nanoTime();
                if (!NonBlockingPlanExecutionServiceImpl.this.executor.awaitTermination(timeout, unit)) {
                    return false;
                }
                long remainingTime = unit.toNanos(timeout) - (System.nanoTime() - time);
                return (Boolean)planExecutionManagerShutdownFuture.get(remainingTime, TimeUnit.NANOSECONDS);
            }

            private void logIfNeeded() {
                if (!this.isDone()) {
                    log.info((Object)"Waiting for change detection threads to stop...");
                }
            }
        };
    }

    @NotNull
    public ExecutorStats getExecutorStats() {
        return new ExecutorStatsImpl(this.executor);
    }

    @Nullable
    private Future<ExecutionRequestResult> createQueuePollingJob(final @NotNull TriggerableInternalKey triggerableIdentifier, final @NotNull BuildDetectionActionQueue planActionQueue) {
        if (this.currentlyDetectingPlansMap.putIfAbsent(triggerableIdentifier, Boolean.TRUE) != null) {
            log.debug((Object)String.format("Did not start queue polling job, %s is already being executed", triggerableIdentifier.getKey()));
            return null;
        }
        log.debug((Object)String.format("Starting queue polling job to handle execution of %s", triggerableIdentifier.getKey()));
        return this.executor.submit(new Callable<ExecutionRequestResult>(){

            @Override
            @Nullable
            public ExecutionRequestResult call() {
                log.trace((Object)String.format("Started handling execution of %s", triggerableIdentifier.getKey()));
                Pair<BuildDetectionAction, Pair<Iterable<CacheAwareness.CacheInfo>, Long>> queuedItem = planActionQueue.peekFront();
                if (queuedItem == null) {
                    log.debug((Object)String.format("No entries found in the queue, stopping queue polling job; was triggered for: %s", triggerableIdentifier.getKey()));
                    this.ensureQueueIsDrained();
                    return null;
                }
                Pair disabledCaches = (Pair)queuedItem.getSecond();
                AtomicReference result = new AtomicReference();
                CacheAwareness.withValuesOlderThanTimestampReloaded(() -> result.set(this.startPlanExecution((BuildDetectionAction)queuedItem.getFirst())), (long)((Long)disabledCaches.getSecond()), (Iterable)disabledCaches.getFirst());
                return (ExecutionRequestResult)result.get();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public ExecutionRequestResult startPlanExecution(@NotNull BuildDetectionAction localBuildDetectionAction) {
                try {
                    Triggerable plan = triggerableIdentifier.getTriggerable();
                    if (plan != null) {
                        log.trace((Object)String.format("Starting immediate execution of %s", triggerableIdentifier.getKey()));
                        ExecutionRequestResult executionRequestResult = NonBlockingPlanExecutionServiceImpl.this.planExecutionManager.start(plan, localBuildDetectionAction, AcquisitionPolicy.IMMEDIATE);
                        return executionRequestResult;
                    }
                    log.info((Object)("Object " + triggerableIdentifier.getKey() + " has been deleted."));
                    ExecutionRequestResult executionRequestResult = null;
                    return executionRequestResult;
                }
                finally {
                    this.ensureQueueIsDrained();
                }
            }

            private void ensureQueueIsDrained() {
                NonBlockingPlanExecutionServiceImpl.this.currentlyDetectingPlansMap.remove(triggerableIdentifier);
                if (planActionQueue.popFront()) {
                    log.debug((Object)String.format("Scheduling another execution of %s because the queue is not empty", triggerableIdentifier.getKey()));
                    NonBlockingPlanExecutionServiceImpl.this.createQueuePollingJob(triggerableIdentifier, planActionQueue);
                }
            }

            public String toString() {
                return "BuildDetectionAction queue polling for " + triggerableIdentifier;
            }
        });
    }

    private class BuildDetectionActionQueue {
        private final LinkedHashMap<String, Pair<BuildDetectionAction, Pair<Iterable<CacheAwareness.CacheInfo>, Long>>> actions = new LinkedHashMap();

        private BuildDetectionActionQueue() {
        }

        public synchronized void enqueue(@NotNull String identifier, @NotNull BuildDetectionAction buildDetectionAction, @NotNull Pair<Iterable<CacheAwareness.CacheInfo>, Long> disableCaches) {
            this.actions.computeIfAbsent(identifier, key -> Pair.make((Object)buildDetectionAction, (Object)disableCaches));
        }

        @Nullable
        public synchronized Pair<BuildDetectionAction, Pair<Iterable<CacheAwareness.CacheInfo>, Long>> peekFront() {
            String identifier = (String)Iterables.getFirst(this.actions.keySet(), null);
            return !NonBlockingPlanExecutionServiceImpl.this.shuttingDown.get() && identifier != null ? this.actions.get(identifier) : null;
        }

        public synchronized boolean popFront() {
            String identifier = (String)Iterables.getFirst(this.actions.keySet(), null);
            if (identifier != null) {
                this.actions.remove(identifier);
            }
            return !NonBlockingPlanExecutionServiceImpl.this.shuttingDown.get() && !this.actions.isEmpty();
        }
    }
}

