/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanAwareContext;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PlanAwareContextImpl
implements PlanAwareContext {
    private static final Logger log = Logger.getLogger(PlanAwareContextImpl.class);
    private static final ThreadLocal<PlanKey> threadLocal = new ThreadLocal();
    private final PlanManager planManager;

    public PlanAwareContextImpl(PlanManager planManager) {
        this.planManager = planManager;
    }

    public PlanKey getPlanKey() {
        return threadLocal.get();
    }

    public Plan getPlan() {
        PlanKey planKey = this.getPlanKey();
        if (planKey != null) {
            return this.planManager.getPlanByKey(planKey);
        }
        return null;
    }

    public void setPlanKey(@Nullable PlanKey planKey) {
        threadLocal.set(planKey);
    }

    public void clearContext() {
        threadLocal.remove();
    }
}

