/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;

public class PlanComparators {
    private static final Logger log = Logger.getLogger(PlanComparators.class);

    public static Comparator<ImmutableJob> jobStageIndexComparator() {
        return JobStageIndexComparator.INSTANCE;
    }

    public static Comparator<PlanIdentifier> planKeyComparator() {
        return PlanKeyComparator.INSTANCE;
    }

    public static Ordering<PlanIdentifier> planKeyOrdering() {
        return PlanKeyComparator.ORDERING;
    }

    public static Comparator<ImmutableChainStage> stageIndexComparator() {
        return StageIndexComparator.INSTANCE;
    }

    private static enum StageIndexComparator implements Comparator<ImmutableChainStage>
    {
        INSTANCE;


        @Override
        public int compare(ImmutableChainStage o1, ImmutableChainStage o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            int i1 = o1.getChain() == null ? -1 : o1.getChain().getAllStages().indexOf(o1);
            int i2 = o2.getChain() == null ? -1 : o2.getChain().getAllStages().indexOf(o2);
            return new CompareToBuilder().append(i1, i2).toComparison();
        }
    }

    private static enum PlanKeyComparator implements Comparator<PlanIdentifier>
    {
        INSTANCE;

        static Ordering<PlanIdentifier> ORDERING;

        @Override
        public int compare(PlanIdentifier o1, PlanIdentifier o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return o1.getPlanKey().getKey().compareToIgnoreCase(o2.getPlanKey().getKey());
        }

        static {
            ORDERING = Ordering.from((Comparator)INSTANCE);
        }
    }

    private static enum JobStageIndexComparator implements Comparator<ImmutableJob>
    {
        INSTANCE;


        @Override
        public int compare(ImmutableJob o1, ImmutableJob o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return PlanComparators.stageIndexComparator().compare(o1.getStage(), o2.getStage());
        }
    }
}

