/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.build.configuration.ConcurrentBuildConfigForPlan;
import com.atlassian.bamboo.plan.AbstractPlanExecutionPermitter;
import com.atlassian.bamboo.plan.ExecutionStatusProvider;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.TextProviderUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.TextProvider;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanExecutionConcurrencyServiceImpl
extends AbstractPlanExecutionPermitter {
    private static final Logger log = Logger.getLogger(PlanExecutionConcurrencyServiceImpl.class);
    private final TextProvider textProvider;
    private final ExecutionStatusProvider executionStatusProvider;

    public PlanExecutionConcurrencyServiceImpl(TextProvider textProvider, ExecutionStatusProvider executionStatusProvider) {
        this.textProvider = textProvider;
        this.executionStatusProvider = executionStatusProvider;
    }

    public boolean isPermittedToExecuteImpl(@NotNull ImmutableChain chain, @Nullable PlanResultKey resultKey, @NotNull ErrorCollection errorCollection) {
        Preconditions.checkNotNull((Object)chain, (Object)"plan");
        ConcurrentBuildConfigForPlan concurrentBuildPlanConfig = PlanHelper.getConfigObject((ImmutablePlan)chain, "custom.concurrentBuilds.planLevelConfig", ConcurrentBuildConfigForPlan.class);
        if (concurrentBuildPlanConfig == null) {
            throw new IllegalStateException("concurrentBuildPlanConfig is null for plan '" + chain.getPlanKey() + "'");
        }
        int numberOfAllowedConcurrentBuilds = concurrentBuildPlanConfig.getEffectiveNumberOfConcurrentBuilds();
        if (this.executionStatusProvider.numberOfExecutions(chain.getPlanKey()) >= numberOfAllowedConcurrentBuilds) {
            errorCollection.addErrorMessage(TextProviderUtils.getText(this.textProvider, "build.concurrent.buildDenied", Integer.toString(numberOfAllowedConcurrentBuilds)));
            return false;
        }
        return true;
    }
}

