/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.StageIdentifier;
import com.atlassian.bamboo.plan.StageIdentifierImpl;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.utils.BambooPredicates;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanExecutionConfigImpl
implements PlanExecutionConfig {
    private StageIdentifier firstStageToExecute;
    @Nullable
    private String lastManualStageForAutomaticExecution;
    private boolean executeAllStages;
    private final PlanExecutionConfig.PlanExecutionType planExecutionType;
    private ImmutableChain chain;
    private ChainResultsSummary resultsSummary;
    private Set<ChainStageResult> stageResultsToExecute;
    private Set<ImmutableChainStage> stagesToExecute;
    private String stageToStopAt;
    private boolean stageToStopIsFinal;
    private boolean branchMergePushOverride;
    private boolean continueFromFailed;

    public PlanExecutionConfigImpl(PlanExecutionConfig.PlanExecutionType planExecutionType) {
        this.planExecutionType = planExecutionType;
    }

    public PlanExecutionConfig setChain(ImmutableChain chain) {
        this.chain = chain;
        return this;
    }

    public PlanExecutionConfig setChainResultSummary(ChainResultsSummary chainResultsSummary) {
        this.resultsSummary = chainResultsSummary;
        return this;
    }

    public PlanExecutionConfig setLatestManualStageForAutomaticExecution(@Nullable String latestManualStageForAutomaticExecution) {
        this.lastManualStageForAutomaticExecution = latestManualStageForAutomaticExecution;
        return this;
    }

    public PlanExecutionConfig setExecuteAllStages() {
        this.executeAllStages = true;
        return this;
    }

    @NotNull
    public StageIdentifier getStartStage() {
        return this.firstStageToExecute;
    }

    public PlanExecutionConfig.PlanExecutionType getPlanExecutionType() {
        return this.planExecutionType;
    }

    public boolean isScheduledForExecution(String stageName) {
        switch (this.planExecutionType) {
            case REGULAR: 
            case ENFORCE_MANUAL_AS_AUTOMATIC: 
            case RERUN: {
                return PlanExecutionConfigImpl.stagesContain(this.stagesToExecute, stageName);
            }
            case CONTINUE: 
            case RESTART: {
                return PlanExecutionConfigImpl.stageResultsContain(this.stageResultsToExecute, stageName);
            }
        }
        return false;
    }

    @NotNull
    public PlanResultKey getResultToRerun() {
        return this.resultsSummary.getPlanResultKey();
    }

    @NotNull
    public PlanExecutionConfig build() {
        if (this.executeAllStages) {
            this.lastManualStageForAutomaticExecution = "@#$__EXECUTE_ALL_STAGES__@#$";
        }
        switch (this.planExecutionType) {
            case REGULAR: 
            case RERUN: {
                this.buildForRegularExecution(this.chain.getStages());
                break;
            }
            case ENFORCE_MANUAL_AS_AUTOMATIC: {
                this.buildForEnforcedExecution(this.chain.getStages());
                break;
            }
            case RESTART: {
                this.buildForRestart(this.resultsSummary.getStageResults());
                break;
            }
            case CONTINUE: {
                this.buildForContinue(this.resultsSummary.getStageResults());
                break;
            }
        }
        return this;
    }

    public Set<ImmutableChainStage> getStagesToExecute() {
        return this.stagesToExecute;
    }

    public boolean isGoingToStopAtManualStage() {
        return this.stageToStopAt != null;
    }

    public boolean isStageToStopFinal() {
        return this.isGoingToStopAtManualStage() && this.stageToStopIsFinal;
    }

    public boolean isBranchMergePushOverride() {
        return this.branchMergePushOverride;
    }

    public boolean isContinueFromFailed() {
        return this.continueFromFailed;
    }

    public void setBranchMergePushOverride(boolean branchMergePushOverride) {
        this.branchMergePushOverride = branchMergePushOverride;
    }

    private void buildForRegularExecution(List<? extends ImmutableChainStage> chainStages) {
        this.stagesToExecute = new HashSet<ImmutableChainStage>();
        this.firstStageToExecute = PlanExecutionConfigImpl.getFirstStageToExecute(chainStages, 0);
        boolean stopStageReached = false;
        for (ImmutableChainStage immutableChainStage : chainStages) {
            if ((stopStageReached |= immutableChainStage.isManual()) && PlanExecutionConfigImpl.containsEnabledJob(immutableChainStage)) {
                this.stageToStopAt = immutableChainStage.getName();
                this.stageToStopIsFinal = immutableChainStage.isFinal();
                break;
            }
            this.stagesToExecute.add(immutableChainStage);
        }
    }

    private void buildForRestart(List<ChainStageResult> allStageResults) {
        this.validateStageName(this.resultsSummary, this.lastManualStageForAutomaticExecution);
        this.stageResultsToExecute = new HashSet<ChainStageResult>();
        List<ChainStageResult> stagesForRestartOrRerun = PlanExecutionConfigImpl.getStagesForRestartOrRerun(this.planExecutionType, allStageResults);
        this.firstStageToExecute = PlanExecutionConfigImpl.getFirstStageToExecuteFromResult(stagesForRestartOrRerun, allStageResults.size() - stagesForRestartOrRerun.size());
        boolean stopStagePassed = this.lastManualStageForAutomaticExecution == null;
        boolean shouldStopOnFirstNonEmptyStage = false;
        for (ChainStageResult chainStageResult : stagesForRestartOrRerun) {
            if (!this.stageResultsToExecute.isEmpty() && (shouldStopOnFirstNonEmptyStage |= chainStageResult.isManual() && stopStagePassed) && !chainStageResult.getBuildResults().isEmpty()) {
                this.stageToStopAt = chainStageResult.getName();
                this.stageToStopIsFinal = chainStageResult.isFinal();
                break;
            }
            this.stageResultsToExecute.add(chainStageResult);
            stopStagePassed |= chainStageResult.getName().equals(this.lastManualStageForAutomaticExecution);
        }
    }

    private void buildForContinue(List<ChainStageResult> allStageResults) {
        this.validateStageName(this.resultsSummary, this.lastManualStageForAutomaticExecution);
        if (!this.resultsSummary.isSuccessful()) {
            this.continueFromFailed = true;
        }
        List<ChainStageResult> runnableStages = PlanExecutionConfigImpl.getRunnableStages(allStageResults);
        this.firstStageToExecute = PlanExecutionConfigImpl.getFirstStageToExecuteFromResult(runnableStages, allStageResults.size() - runnableStages.size());
        boolean stopStagePassed = this.lastManualStageForAutomaticExecution == null;
        boolean shouldStopOnFirstNonEmptyStage = false;
        this.stageResultsToExecute = new HashSet<ChainStageResult>();
        for (ChainStageResult chainStageResult : runnableStages) {
            boolean isFirstStage = this.stageResultsToExecute.isEmpty();
            if ((shouldStopOnFirstNonEmptyStage |= chainStageResult.isManual() && !isFirstStage && stopStagePassed) && !chainStageResult.getBuildResults().isEmpty()) {
                this.stageToStopAt = chainStageResult.getName();
                this.stageToStopIsFinal = chainStageResult.isFinal();
                break;
            }
            this.stageResultsToExecute.add(chainStageResult);
            stopStagePassed |= chainStageResult.getName().equals(this.lastManualStageForAutomaticExecution);
        }
    }

    private void buildForEnforcedExecution(List<? extends ImmutableChainStage> chainStages) {
        this.validateStageName(this.chain, this.lastManualStageForAutomaticExecution);
        this.stagesToExecute = new HashSet<ImmutableChainStage>();
        this.firstStageToExecute = PlanExecutionConfigImpl.getFirstStageToExecute(chainStages, 0);
        boolean stopStagePassed = false;
        boolean shouldStopOnFirstNonEmptyStage = false;
        for (ImmutableChainStage immutableChainStage : chainStages) {
            if ((shouldStopOnFirstNonEmptyStage |= immutableChainStage.isManual() && stopStagePassed) && !immutableChainStage.getJobs().isEmpty()) {
                this.stageToStopAt = immutableChainStage.getName();
                this.stageToStopIsFinal = immutableChainStage.isFinal();
                break;
            }
            this.stagesToExecute.add(immutableChainStage);
            stopStagePassed |= immutableChainStage.getName().equals(this.lastManualStageForAutomaticExecution);
        }
    }

    @Nullable
    private static StageIdentifierImpl getFirstStageToExecute(List<? extends ImmutableChainStage> chainStages, int offset) {
        if (chainStages.isEmpty()) {
            return null;
        }
        return new StageIdentifierImpl(chainStages.get(0).getName(), offset);
    }

    @Nullable
    private static StageIdentifierImpl getFirstStageToExecuteFromResult(List<ChainStageResult> chainStages, int offset) {
        if (chainStages.isEmpty()) {
            return null;
        }
        return new StageIdentifierImpl(chainStages.get(0).getName(), offset);
    }

    private static List<ChainStageResult> getStagesForRestartOrRerun(PlanExecutionConfig.PlanExecutionType planExecutionType, List<ChainStageResult> stageResults) {
        if (planExecutionType == PlanExecutionConfig.PlanExecutionType.RERUN) {
            return stageResults;
        }
        return PlanExecutionConfigImpl.getAllStagesAfterPredicateMatch(stageResults, ChainStageResult::isRestartable);
    }

    private static List<ChainStageResult> getRunnableStages(List<ChainStageResult> stageResults) {
        return PlanExecutionConfigImpl.getAllStagesAfterPredicateMatch(stageResults, ChainStageResult::isRunnable);
    }

    @NotNull
    private static List<ChainStageResult> getAllStagesAfterPredicateMatch(List<ChainStageResult> stageResults, Predicate<ChainStageResult> predicate) {
        return stageResults.stream().filter(BambooPredicates.onceTrueAlwaysTrue(predicate)).collect(Collectors.toList());
    }

    private static boolean containsEnabledJob(ImmutableChainStage chainStage) {
        return chainStage.getJobs().stream().anyMatch(job -> !job.isSuspendedFromBuilding());
    }

    private static boolean stageResultsContain(Collection<ChainStageResult> stageResults, String stageName) {
        return stageResults.stream().anyMatch(csr -> csr.getName().equals(stageName));
    }

    private static boolean stagesContain(Collection<? extends ImmutableChainStage> stages, String stageName) {
        return stages.stream().anyMatch(stage -> stage.getName().equals(stageName));
    }

    private void validateStageName(ImmutableChain chain, String stageName) {
        if (this.executeAllStages || stageName == null) {
            return;
        }
        if (!PlanExecutionConfigImpl.stagesContain(chain.getStages(), stageName)) {
            throw new IllegalArgumentException("Stage " + stageName + " not found");
        }
        for (ImmutableChainStage chainStage : chain.getStages()) {
            if (!chainStage.getName().equals(stageName)) continue;
            return;
        }
    }

    private void validateStageName(@NotNull ChainResultsSummary resultsSummary, @Nullable String stageName) {
        if (this.executeAllStages || stageName == null) {
            return;
        }
        if (!PlanExecutionConfigImpl.stageResultsContain(resultsSummary.getStageResults(), stageName)) {
            throw new IllegalArgumentException("Stage " + stageName + " not found");
        }
    }
}

