/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.plan.InterruptibleProcessLock;
import com.atlassian.bamboo.plan.PlanExecutionLockService;
import com.atlassian.bamboo.trigger.TriggerableInternalKey;
import com.atlassian.bamboo.util.AcquisitionPolicy;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanExecutionLockServiceImpl
implements PlanExecutionLockService {
    private static final Logger log = Logger.getLogger(PlanExecutionLockServiceImpl.class);
    private final ManagedLock.ReadWrite globalExecutionReadWriteLock = ManagedLocks.manageReadWrite((ReadWriteLock)new ReentrantReadWriteLock());
    private final LoadingCache<TriggerableInternalKey, InterruptibleProcessLock> processLocks = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<TriggerableInternalKey, InterruptibleProcessLock>(){

        public InterruptibleProcessLock load(@NotNull TriggerableInternalKey from) {
            return new InterruptibleProcessLock();
        }
    });
    private final LoadingCache<TriggerableInternalKey, InterruptibleProcessLock> inlineProcessLocks = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<TriggerableInternalKey, InterruptibleProcessLock>(){

        public InterruptibleProcessLock load(@NotNull TriggerableInternalKey from) {
            return new InterruptibleProcessLock();
        }
    });

    public <V> V runWhenNoExecutionRequestsAreBeingMade(@NotNull Callable<V> callable) throws Exception {
        return (V)this.globalExecutionReadWriteLock.write().withLock(callable);
    }

    public boolean isLocked(@NotNull TriggerableInternalKey internalKey) {
        return ((InterruptibleProcessLock)this.processLocks.getUnchecked((Object)internalKey)).isLocked() || ((InterruptibleProcessLock)this.inlineProcessLocks.getUnchecked((Object)internalKey)).isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <V> V lock(@NotNull TriggerableInternalKey internalKey, @NotNull AcquisitionPolicy acquisitionPolicy, @NotNull Callable<V> callable) throws Exception {
        Lock lock = (Lock)this.processLocks.get((Object)internalKey);
        if (acquisitionPolicy.acquire(lock)) {
            try {
                Object object = this.globalExecutionReadWriteLock.read().withLock(callable);
                return (V)object;
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <V> V inlineProcessLocks(@NotNull TriggerableInternalKey internalKey, @NotNull AcquisitionPolicy acquisitionPolicy, @NotNull Callable<V> callable) throws Exception {
        Lock lock = (Lock)this.inlineProcessLocks.get((Object)internalKey);
        if (acquisitionPolicy.acquire(lock)) {
            try {
                Object object = this.globalExecutionReadWriteLock.read().withLock(callable);
                return (V)object;
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    public void interruptLockOwner(@NotNull TriggerableInternalKey internalKey) {
        ((InterruptibleProcessLock)this.processLocks.getUnchecked((Object)internalKey)).interruptOwner();
        ((InterruptibleProcessLock)this.inlineProcessLocks.getUnchecked((Object)internalKey)).interruptOwner();
    }
}

