/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildDetectionAction;
import com.atlassian.bamboo.build.BuildDetectionActionFactory;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.BuildRequestResultImpl;
import com.atlassian.bamboo.build.ConditionalBuildDetectionAction;
import com.atlassian.bamboo.build.DelayedChangeDetectionAction;
import com.atlassian.bamboo.build.StopBuildManager;
import com.atlassian.bamboo.build.UnconditionalBuildDetectionAction;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.pipeline.concurrent.SystemAuthorityThreadFactory;
import com.atlassian.bamboo.chains.BuildExecution;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.chains.ChainState;
import com.atlassian.bamboo.chains.ChainStateCreationRequestResult;
import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.InternalEnvironment;
import com.atlassian.bamboo.deployments.execution.DeploymentPermitter;
import com.atlassian.bamboo.deployments.execution.service.DeploymentExecutionService;
import com.atlassian.bamboo.deployments.execution.triggering.EnvironmentTriggeringAction;
import com.atlassian.bamboo.deployments.execution.triggering.EnvironmentTriggeringResult;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.plan.ExecutionRequestResult;
import com.atlassian.bamboo.plan.ExecutionRequestResultImpl;
import com.atlassian.bamboo.plan.ExecutionStatus;
import com.atlassian.bamboo.plan.ExecutionStatusProvider;
import com.atlassian.bamboo.plan.IncorrectPlanTypeException;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanExecutionLockService;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanExecutionManagerCallWatcher;
import com.atlassian.bamboo.plan.PlanExecutionPermitter;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.StageIdentifier;
import com.atlassian.bamboo.plan.TriggerableInternalKeyImpl;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.PlanTrigger;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.repository.InvalidRepositoryException;
import com.atlassian.bamboo.serialization.ServerSideOnly;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.trigger.TriggerableInternalKey;
import com.atlassian.bamboo.util.AcquisitionPolicy;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooCallables;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.build.trigger.UnknownTriggerReason;
import com.atlassian.bamboo.v2.trigger.ContinuedBuildDetectionAction;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

@ServerSideOnly
public class PlanExecutionManagerImpl
implements PlanExecutionManager {
    private static final Logger log = Logger.getLogger(PlanExecutionManagerImpl.class);
    @Lazy
    @Inject
    private ChainExecutionManager chainExecutionManager;
    private final BuildExecutionManager buildExecutionManager;
    @Lazy
    @Inject
    private BuildDetectionActionFactory buildDetectionActionFactory;
    private final PlanExecutionPermitter planExecutionPermitter;
    private final ExecutionStatusProvider executionStatusProvider;
    private final CachedPlanManager cachedPlanManager;
    private final StopBuildManager stopBuildManager;
    private final TriggerManager triggerManager;
    private final PlanExecutionLockService planExecutionLockService;
    private final SystemAuthorityThreadFactory threadFactory;
    @Inject
    private DeploymentExecutionService deploymentExecutionService;
    private final EventPublisher eventPublisher;
    private final ErrorHandler errorHandler;
    private final DeploymentPermitter deploymentPermitter;
    private final PlanExecutionManagerCallWatcher planExecutionManagerCallWatcher;

    public PlanExecutionManagerImpl(BuildExecutionManager buildExecutionManager, PlanExecutionPermitter planExecutionPermitter, ExecutionStatusProvider executionStatusProvider, CachedPlanManager cachedPlanManager, StopBuildManager stopBuildManager, TriggerManager triggerManager, PlanExecutionLockService planExecutionLockService, EventPublisher eventPublisher, ErrorHandler errorHandler, DeploymentPermitter deploymentPermitter, PlanExecutionManagerCallWatcher planExecutionManagerCallWatcher) {
        this.buildExecutionManager = buildExecutionManager;
        this.planExecutionPermitter = planExecutionPermitter;
        this.executionStatusProvider = executionStatusProvider;
        this.cachedPlanManager = cachedPlanManager;
        this.stopBuildManager = stopBuildManager;
        this.triggerManager = triggerManager;
        this.planExecutionLockService = planExecutionLockService;
        this.eventPublisher = eventPublisher;
        this.errorHandler = errorHandler;
        this.threadFactory = new SystemAuthorityThreadFactory("DelayedChangeDetectionThread");
        this.deploymentPermitter = deploymentPermitter;
        this.planExecutionManagerCallWatcher = planExecutionManagerCallWatcher;
    }

    public int numberOfExecutions(@NotNull PlanKey planKey) {
        return this.executionStatusProvider.numberOfExecutions(planKey);
    }

    @NotNull
    public Collection<? extends ExecutionStatus> getExecutionStatus(@NotNull PlanKey planKey) {
        return this.executionStatusProvider.getExecutionStatus(planKey);
    }

    @Nullable
    public ExecutionStatus getExecutionStatus(@NotNull PlanResultKey planResultKey) {
        return this.executionStatusProvider.getExecutionStatus(planResultKey);
    }

    public BuildExecution getJobExecution(@NotNull PlanResultKey planResultKey) {
        return this.executionStatusProvider.getJobExecution(planResultKey);
    }

    private String getTriggerReasonPluginKey(@NotNull Map<String, String> params, @Nullable PlanExecutionConfig planExecutionConfig) {
        if (planExecutionConfig != null && (planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.RESTART || planExecutionConfig.getPlanExecutionType() == PlanExecutionConfig.PlanExecutionType.RERUN)) {
            return "com.atlassian.bamboo.plugin.system.triggerReason:RerunBuildTriggerReason";
        }
        return params.containsKey("customRevision") ? "com.atlassian.bamboo.plugin.system.triggerReason:CustomRevisionBuildTriggerReason" : "com.atlassian.bamboo.plugin.system.triggerReason:ManualBuildTriggerReason";
    }

    @NotNull
    public ExecutionRequestResult startManualExecution(@NotNull ImmutableChain chain, @NotNull User user, @NotNull Map<String, String> params, @NotNull Map<String, String> variables) {
        String triggerReasonPluginKey = this.getTriggerReasonPluginKey(params, null);
        return this.startManualExecution(chain, null, user, triggerReasonPluginKey, null, params, variables);
    }

    @NotNull
    public ExecutionRequestResult startManualExecution(@NotNull ImmutableChain chain, @Nullable PlanExecutionConfig planExecutionConfig, @NotNull User user, @NotNull Map<String, String> params, @NotNull Map<String, String> variables) {
        String triggerReasonPluginKey = this.getTriggerReasonPluginKey(params, planExecutionConfig);
        return this.startManualExecution(chain, planExecutionConfig, user, triggerReasonPluginKey, null, params, variables);
    }

    @NotNull
    public ExecutionRequestResult startManualExecution(@NotNull ImmutableChain chain, @Nullable PlanExecutionConfig planExecutionConfig, @NotNull User user, @NotNull String triggerReasonPluginKey, @Nullable String planTriggerPluginKey, @NotNull Map<String, String> params, @NotNull Map<String, String> variables) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        TriggerReason triggerReason = null;
        if (StringUtils.isNotBlank((CharSequence)triggerReasonPluginKey)) {
            HashMap<String, String> effectiveParams = new HashMap<String, String>(params);
            if (planExecutionConfig != null) {
                StageIdentifier startingStage = planExecutionConfig.getStartStage();
                String startingStageName = startingStage != null ? startingStage.getName() : "post chain actions";
                effectiveParams.put("ManualBuildTriggerReason.userName", user.getName());
                effectiveParams.put("ManualBuildTriggerReason.stageName", startingStageName);
            }
            if ((triggerReason = this.triggerManager.getTriggerReason(triggerReasonPluginKey, effectiveParams)) instanceof UnknownTriggerReason) {
                errorCollection.addErrorMessage("Could not find specified trigger '" + triggerReasonPluginKey + "'");
            }
        }
        PlanTrigger planTrigger = null;
        if (StringUtils.isNotBlank((CharSequence)planTriggerPluginKey)) {
            try {
                planTrigger = this.triggerManager.getPlanTrigger(planTriggerPluginKey);
            }
            catch (RuntimeException e) {
                log.error((Object)"Unable to find plan trigger", (Throwable)e);
                errorCollection.addErrorMessage("Cannot find specified planTrigger '" + planTriggerPluginKey + "'");
            }
        }
        if (errorCollection.hasAnyErrors()) {
            return new ExecutionRequestResultImpl((ErrorCollection)errorCollection, null);
        }
        BuildDetectionAction action = this.buildDetectionActionFactory.createManualBuildDetectionAction(chain, user, triggerReason, planTrigger, planExecutionConfig, params, variables);
        BambooCallables.NotThrowing startManualExecution = () -> this.start(chain, action, AcquisitionPolicy.WAIT);
        ExecutionRequestResult executionRequestResult = (ExecutionRequestResult)CacheAwareness.withValuesOlderThanTimestampReloaded(startManualExecution, System.currentTimeMillis(), new CacheAwareness.CacheInfo[]{CacheAwareness.CHANGE_DETECTION});
        ErrorCollection resultErrors = executionRequestResult.getErrors();
        if (resultErrors.hasAnyErrors()) {
            BuildLogger buildLogger = chain.getBuildLogger();
            for (String error : resultErrors.getErrorMessages()) {
                buildLogger.addErrorLogEntry(error);
            }
            errorCollection.addErrorCollection(resultErrors);
        }
        return executionRequestResult;
    }

    public boolean isBusy(@NotNull PlanKey planKey) {
        return this.planExecutionLockService.isLocked((TriggerableInternalKey)new TriggerableInternalKeyImpl(planKey));
    }

    public boolean isBusy() {
        return this.chainExecutionManager.numberOfChainsExecuting() > 0;
    }

    @NotNull
    public ExecutionRequestResult start(@NotNull ImmutableChain chain, @Nullable PlanExecutionConfig planExecutionConfig, @NotNull String triggerReasonPluginKey, @NotNull String planTriggerPluginKey, @NotNull Map<String, String> params, @NotNull Map<String, String> variables, @NotNull AcquisitionPolicy acquisitionPolicy) {
        PlanTrigger planTrigger;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        TriggerReason triggerReason = this.triggerManager.getTriggerReason(triggerReasonPluginKey, params);
        if (triggerReason instanceof UnknownTriggerReason) {
            errorCollection.addErrorMessage("Could not find specified trigger '" + triggerReasonPluginKey + "'");
        }
        if ((planTrigger = this.triggerManager.getPlanTrigger(planTriggerPluginKey)) == null) {
            errorCollection.addErrorMessage("Cannot find specified planTrigger '" + planTriggerPluginKey + "'");
        }
        if (errorCollection.hasAnyErrors()) {
            return new ExecutionRequestResultImpl((ErrorCollection)errorCollection, null);
        }
        BuildDetectionAction buildDetectionAction = this.buildDetectionActionFactory.createBuildDetectionActionForPluginBuildTrigger(chain, planExecutionConfig, triggerReason, planTrigger, params, variables);
        return this.start(chain, buildDetectionAction, acquisitionPolicy);
    }

    @Nullable
    private PlanResultKey getResultKeyIfContinuedBuildDetectionAction(UnconditionalBuildDetectionAction changeDetectionAction) {
        ContinuedBuildDetectionAction continuedBuildDetectionAction = (ContinuedBuildDetectionAction)Narrow.downTo((Object)changeDetectionAction, ContinuedBuildDetectionAction.class);
        if (continuedBuildDetectionAction != null) {
            return continuedBuildDetectionAction.getPlanExecutionConfig().getResultToRerun();
        }
        return null;
    }

    private ExecutionRequestResult startManualBuild(final @NotNull ImmutableChain chain, final @NotNull DelayedChangeDetectionAction delayedChangeDetectionAction, @NotNull AcquisitionPolicy acquisitionPolicy) {
        com.atlassian.bamboo.utils.Pair<Iterable<CacheAwareness.CacheInfo>, Long> disabledCaches = CacheAwareness.getDisabledCachesTimestamp();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        TriggerableInternalKeyImpl chainKey = new TriggerableInternalKeyImpl((Triggerable)chain);
        return this.doWithInlineProcessLock(chainKey, acquisitionPolicy, new Callable<ExecutionRequestResult>((ErrorCollection)errors, (TriggerableInternalKey)chainKey, acquisitionPolicy, disabledCaches){
            final /* synthetic */ ErrorCollection val$errors;
            final /* synthetic */ TriggerableInternalKey val$chainKey;
            final /* synthetic */ AcquisitionPolicy val$acquisitionPolicy;
            final /* synthetic */ com.atlassian.bamboo.utils.Pair val$disabledCaches;
            {
                this.val$errors = errorCollection;
                this.val$chainKey = triggerableInternalKey;
                this.val$acquisitionPolicy = acquisitionPolicy;
                this.val$disabledCaches = pair;
            }

            @Override
            @NotNull
            public ExecutionRequestResult call() {
                log.trace((Object)String.format("Started handling manual build of chain %s", chain.getKey()));
                if (!PlanExecutionManagerImpl.this.planExecutionPermitter.isPermittedToExecute(chain, PlanExecutionManagerImpl.this.getResultKeyIfContinuedBuildDetectionAction((UnconditionalBuildDetectionAction)delayedChangeDetectionAction), this.val$errors)) {
                    return new BuildRequestResultImpl(this.val$errors);
                }
                ChainStateCreationRequestResult chainStateRequestResult = PlanExecutionManagerImpl.this.chainExecutionManager.createChainStateNoDetection(chain, (UnconditionalBuildDetectionAction)delayedChangeDetectionAction);
                final ChainState chainState = chainStateRequestResult.getChainState();
                if (chainState != null && !chainStateRequestResult.getErrors().hasAnyErrors()) {
                    Runnable delayedStartRunnable = new Runnable(){

                        @Override
                        public void run() {
                            PlanExecutionManagerImpl.this.doWithProcessLock(val$chainKey, val$acquisitionPolicy, this.delayedStart());
                        }

                        private Callable<ExecutionRequestResult> delayedStart() {
                            return new Callable<ExecutionRequestResult>(){

                                @Override
                                @Nullable
                                public ExecutionRequestResult call() {
                                    log.trace((Object)String.format("Starting manual build of chain %s", chain.getKey()));
                                    AtomicReference result = new AtomicReference();
                                    try {
                                        CacheAwareness.withValuesOlderThanTimestampReloaded(() -> result.set(PlanExecutionManagerImpl.this.chainExecutionManager.delayedStart(chain, (UnconditionalBuildDetectionAction)delayedChangeDetectionAction, chainState)), (long)((Long)val$disabledCaches.getSecond()), (Iterable)val$disabledCaches.getFirst());
                                    }
                                    finally {
                                        PlanExecutionManagerImpl.this.planExecutionManagerCallWatcher.endCall();
                                    }
                                    return (ExecutionRequestResult)result.get();
                                }
                            };
                        }
                    };
                    if (PlanExecutionManagerImpl.this.planExecutionManagerCallWatcher.startCall()) {
                        PlanExecutionManagerImpl.this.threadFactory.newThread(delayedStartRunnable).start();
                    } else {
                        return new BuildRequestResultImpl((ErrorCollection)new SimpleErrorCollection("Not starting manual build since server is going down"));
                    }
                }
                return chainStateRequestResult;
            }
        });
    }

    private ExecutionRequestResult startUnconditionalBuild(final @NotNull ImmutableChain chain, final @NotNull UnconditionalBuildDetectionAction unconditionalBuildDetectionAction, final @NotNull AcquisitionPolicy acquisitionPolicy) {
        final TriggerableInternalKeyImpl chainKey = new TriggerableInternalKeyImpl((Triggerable)chain);
        return this.doWithProcessLock(chainKey, acquisitionPolicy, new Callable<ExecutionRequestResult>(){

            @Override
            @NotNull
            public ExecutionRequestResult call() {
                log.trace((Object)String.format("Started handling unconditional build of chain %s", chain.getKey()));
                ExecutionRequestResult executionRequestResult = PlanExecutionManagerImpl.this.doWithInlineProcessLock(chainKey, acquisitionPolicy, new Callable<ExecutionRequestResult>(){
                    final ErrorCollection errors = new SimpleErrorCollection();

                    @Override
                    public ExecutionRequestResult call() throws Exception {
                        if (PlanExecutionManagerImpl.this.planExecutionPermitter.isPermittedToExecute(chain, PlanExecutionManagerImpl.this.getResultKeyIfContinuedBuildDetectionAction(unconditionalBuildDetectionAction), this.errors)) {
                            return PlanExecutionManagerImpl.this.chainExecutionManager.createChainStateNoDetection(chain, unconditionalBuildDetectionAction);
                        }
                        return new BuildRequestResultImpl(this.errors);
                    }
                });
                ChainStateCreationRequestResult chainStateRequestResult = (ChainStateCreationRequestResult)Narrow.downTo((Object)executionRequestResult, ChainStateCreationRequestResult.class);
                if (chainStateRequestResult != null && chainStateRequestResult.getChainState() != null && !chainStateRequestResult.getErrors().hasAnyErrors()) {
                    return PlanExecutionManagerImpl.this.chainExecutionManager.delayedStart(chain, unconditionalBuildDetectionAction, chainStateRequestResult.getChainState());
                }
                return executionRequestResult;
            }
        });
    }

    private ExecutionRequestResult startConditionalBuild(final @NotNull ImmutableChain chain, @NotNull ConditionalBuildDetectionAction conditionalBuildDetectionAction, final @NotNull AcquisitionPolicy acquisitionPolicy) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        final TriggerableInternalKeyImpl chainKey = new TriggerableInternalKeyImpl((Triggerable)chain);
        return this.doWithProcessLock(chainKey, acquisitionPolicy, new Callable<ExecutionRequestResult>((ErrorCollection)errors, conditionalBuildDetectionAction){
            final /* synthetic */ ErrorCollection val$errors;
            final /* synthetic */ ConditionalBuildDetectionAction val$conditionalBuildDetectionAction;
            {
                this.val$errors = errorCollection;
                this.val$conditionalBuildDetectionAction = conditionalBuildDetectionAction;
            }

            @Override
            @NotNull
            public ExecutionRequestResult call() {
                log.trace((Object)String.format("Started handling conditional build of chain %s", chain.getKey()));
                boolean isPermittedToExecute = PlanExecutionManagerImpl.this.booleanTestWithInlineProcessLock(chainKey, acquisitionPolicy, new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return PlanExecutionManagerImpl.this.planExecutionPermitter.isPermittedToExecute(chain, val$errors);
                    }
                });
                if (isPermittedToExecute) {
                    Pair bdr = this.val$conditionalBuildDetectionAction.testIfBuildShouldStart();
                    if (((Boolean)bdr.left()).booleanValue() && !((ErrorCollection)bdr.right()).hasAnyErrors()) {
                        return PlanExecutionManagerImpl.this.doWithInlineProcessLock(chainKey, acquisitionPolicy, new Callable<ExecutionRequestResult>(){

                            @Override
                            public ExecutionRequestResult call() throws Exception {
                                if (PlanExecutionManagerImpl.this.planExecutionPermitter.isPermittedToExecute(chain, val$errors)) {
                                    return PlanExecutionManagerImpl.this.chainExecutionManager.start(chain, val$conditionalBuildDetectionAction);
                                }
                                return new BuildRequestResultImpl(val$errors);
                            }
                        });
                    }
                    return new BuildRequestResultImpl((ErrorCollection)bdr.right());
                }
                return new BuildRequestResultImpl(this.val$errors);
            }
        });
    }

    public ExecutionRequestResult start(@NotNull ImmutableChain chain, @NotNull BuildDetectionAction buildDetectionAction, @NotNull AcquisitionPolicy acquisitionPolicy) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Plan: " + chain.getPlanKey() + " about to run " + buildDetectionAction));
        }
        DelayedChangeDetectionAction delayedChangeDetectionAction = (DelayedChangeDetectionAction)Narrow.downTo((Object)buildDetectionAction, DelayedChangeDetectionAction.class);
        UnconditionalBuildDetectionAction unconditionalBuildDetectionAction = (UnconditionalBuildDetectionAction)Narrow.downTo((Object)buildDetectionAction, UnconditionalBuildDetectionAction.class);
        ConditionalBuildDetectionAction conditionalBuildDetectionAction = (ConditionalBuildDetectionAction)Narrow.downTo((Object)buildDetectionAction, ConditionalBuildDetectionAction.class);
        if (delayedChangeDetectionAction != null) {
            return this.startManualBuild(chain, delayedChangeDetectionAction, acquisitionPolicy);
        }
        if (unconditionalBuildDetectionAction != null) {
            return this.startUnconditionalBuild(chain, unconditionalBuildDetectionAction, acquisitionPolicy);
        }
        if (conditionalBuildDetectionAction != null) {
            return this.startConditionalBuild(chain, conditionalBuildDetectionAction, acquisitionPolicy);
        }
        throw new IllegalArgumentException("Invalid BuildDetectionAction implementation " + buildDetectionAction.getClass().getName());
    }

    @NotNull
    public ExecutionRequestResult start(@NotNull Triggerable triggerable, @NotNull BuildDetectionAction buildDetectionAction, @NotNull AcquisitionPolicy acquisitionPolicy) {
        ImmutableChain chain = (ImmutableChain)Narrow.downTo((Object)triggerable, ImmutableChain.class);
        if (chain != null) {
            return this.start(chain, buildDetectionAction, acquisitionPolicy);
        }
        Environment environment = (Environment)Narrow.downTo((Object)triggerable, Environment.class);
        Preconditions.checkNotNull((Object)environment, (Object)"Invalid trigger request: null Environment");
        EnvironmentTriggeringAction action = (EnvironmentTriggeringAction)Narrow.downTo((Object)buildDetectionAction, EnvironmentTriggeringAction.class);
        Preconditions.checkNotNull((Object)action, (Object)("Not a deployment trigger: " + buildDetectionAction.getClass().getSimpleName()));
        return this.startDeployment(environment, action, acquisitionPolicy);
    }

    @NotNull
    private ExecutionRequestResult startDeployment(@NotNull Environment environment, @NotNull EnvironmentTriggeringAction action, @NotNull AcquisitionPolicy acquisitionPolicy) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Environment " + environment.getKey() + " about to run " + action));
        }
        return this.doWithProcessLock(new TriggerableInternalKeyImpl((Triggerable)environment), acquisitionPolicy, () -> {
            EnvironmentTriggeringResult deployCheckResult = this.deploymentPermitter.performDeployCheck((InternalEnvironment)environment);
            if (deployCheckResult.getErrors().hasAnyErrors()) {
                return deployCheckResult;
            }
            return this.deploymentExecutionService.execute(environment, action);
        });
    }

    public boolean isBuildingAllowed(@NotNull ImmutableChain chain) {
        return this.planExecutionPermitter.isPermittedToExecute(chain, (ErrorCollection)new SimpleErrorCollection());
    }

    @NotNull
    public List<CurrentlyBuilding> getCurrentlyBuildingForPlan(PlanKey planKey) {
        ArrayList<CurrentlyBuilding> buildingList = new ArrayList();
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(planKey, ImmutableChain.class);
        if (chain != null) {
            List jobs = chain.getAllJobs();
            for (ImmutableJob job : jobs) {
                buildingList.addAll(this.buildExecutionManager.getCurrentlyBuilding((Key)job.getPlanKey()));
            }
        } else {
            buildingList = this.buildExecutionManager.getCurrentlyBuilding((Key)planKey);
        }
        return buildingList;
    }

    @NotNull
    public List<CurrentlyBuilding> getCurrentlyBuildingForPlanResult(PlanResultKey planResultKey) {
        ArrayList<CurrentlyBuilding> buildingList = new ArrayList<CurrentlyBuilding>();
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(planResultKey.getPlanKey(), ImmutableChain.class);
        if (chain != null) {
            ChainExecution chainExecution = this.chainExecutionManager.getChainExecution(planResultKey);
            if (chainExecution != null) {
                List stagesExecution = chainExecution.getStages();
                for (StageExecution stageExecution : stagesExecution) {
                    List builds = stageExecution.getBuilds();
                    for (BuildExecution build : builds) {
                        CurrentlyBuilding currentlyBuilding = this.buildExecutionManager.getCurrentlyBuildingByPlanResultKey((ResultKey)build.getPlanResultKey());
                        if (currentlyBuilding == null) continue;
                        buildingList.add(currentlyBuilding);
                    }
                }
            }
        } else {
            CurrentlyBuilding building = this.buildExecutionManager.getCurrentlyBuildingByPlanResultKey((ResultKey)planResultKey);
            if (building != null) {
                buildingList.add(building);
            }
        }
        return buildingList;
    }

    public void stopPlan(@NotNull PlanResultKey planResultKey, boolean abandonResult, String userName) {
        PlanKey planKey = planResultKey.getPlanKey();
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(planKey, ImmutableChain.class);
        if (chain != null) {
            this.chainExecutionManager.stop(planResultKey);
        } else {
            this.stopBuildManager.cancelBuild(planResultKey, abandonResult);
        }
    }

    public void stopPlan(@NotNull PlanKey planKey, boolean abandonResult, String userName) throws InterruptedException {
        ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(planKey);
        ImmutableChain chain = (ImmutableChain)Narrow.to((Object)plan, ImmutableChain.class);
        if (chain != null) {
            this.chainExecutionManager.stop(planKey);
        } else {
            this.stopBuildManager.cancelAllBuilds(planKey, abandonResult);
        }
    }

    public void stopRequest(@NotNull PlanKey planKey) {
        this.planExecutionLockService.interruptLockOwner((TriggerableInternalKey)new TriggerableInternalKeyImpl(planKey));
    }

    @NotNull
    private ExecutionRequestResult doWithInlineProcessLock(TriggerableInternalKey internalKey, AcquisitionPolicy acquisitionPolicy, Callable<ExecutionRequestResult> callback) {
        ExecutionRequestResult executionRequestResult;
        try {
            executionRequestResult = (ExecutionRequestResult)this.planExecutionLockService.inlineProcessLocks(internalKey, acquisitionPolicy, callback);
        }
        catch (IncorrectPlanTypeException e) {
            throw e;
        }
        catch (Exception e) {
            SimpleErrorCollection errors = new SimpleErrorCollection("Could not execute '" + internalKey + "': " + e.toString());
            PlanKey planKey = internalKey.getPlanKey();
            if (!InvalidRepositoryException.handleInvalidRepositoryIfAppropriate(planKey, e, (ErrorCollection)errors, this.eventPublisher, this.errorHandler)) {
                log.warn((Object)"Unknown error during doWithInlineProcessLock", (Throwable)e);
            }
            return new BuildRequestResultImpl(null, (ErrorCollection)errors);
        }
        return executionRequestResult == null ? new BuildRequestResultImpl(null, (ErrorCollection)new SimpleErrorCollection("Cannot start '" + internalKey + "' as another inline-process is already starting this.")) : executionRequestResult;
    }

    private boolean booleanTestWithInlineProcessLock(TriggerableInternalKey internalKey, AcquisitionPolicy acquisitionPolicy, Callable<Boolean> callback) {
        try {
            return Boolean.TRUE.equals(this.planExecutionLockService.inlineProcessLocks(internalKey, acquisitionPolicy, callback));
        }
        catch (IncorrectPlanTypeException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn((Object)"Unknown error during doWithInlineProcessLock", (Throwable)e);
            return false;
        }
    }

    @NotNull
    private ExecutionRequestResult doWithProcessLock(TriggerableInternalKey internalKey, AcquisitionPolicy acquisitionPolicy, Callable<ExecutionRequestResult> callback) {
        ExecutionRequestResult executionRequestResult;
        try {
            executionRequestResult = (ExecutionRequestResult)this.planExecutionLockService.lock(internalKey, acquisitionPolicy, callback);
        }
        catch (IncorrectPlanTypeException e) {
            throw e;
        }
        catch (Exception e) {
            SimpleErrorCollection errors = new SimpleErrorCollection("Could not execute '" + internalKey + "': " + e.toString());
            if (!InvalidRepositoryException.handleInvalidRepositoryIfAppropriate(internalKey.getPlanKey(), e, (ErrorCollection)errors, this.eventPublisher, this.errorHandler)) {
                log.warn((Object)"Unknown error during doWithProcessLock", (Throwable)e);
            }
            return new BuildRequestResultImpl(null, (ErrorCollection)errors);
        }
        return executionRequestResult == null ? new BuildRequestResultImpl(null, (ErrorCollection)new SimpleErrorCollection("Cannot start '" + internalKey + "' as another process is already starting this.")) : executionRequestResult;
    }

    public Future<Boolean> shutdown() {
        return this.planExecutionManagerCallWatcher.shutdown();
    }
}

