/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanFavouriteService;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.utils.BambooValidate;
import com.atlassian.user.User;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanFavouriteServiceImpl
implements PlanFavouriteService {
    private static final Logger log = Logger.getLogger(PlanFavouriteServiceImpl.class);
    private static final String NOT_IN_TRANSACTION_MESSAGE = "PlanFavouriteService must not be called within an existing transaction.";
    private final Function<String, ManagedLock> lockFactory = ManagedLocks.weakManagedLockFactory();
    final LabelManager labelManager;

    public PlanFavouriteServiceImpl(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public boolean isFavourite(@NotNull ImmutablePlan plan, @Nullable User user) {
        return this.labelManager.isFavourite(plan, user);
    }

    public int addFavourite(final @NotNull Plan plan, final @Nullable User user, final boolean honourManuallyUnmarked) {
        if (user == null) {
            return 0;
        }
        BambooValidate.notInsideTransaction(NOT_IN_TRANSACTION_MESSAGE);
        try {
            return (Integer)this.lockFactory.apply(user.getName()).withLock((Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (!(PlanFavouriteServiceImpl.this.labelManager.isFavourite((ImmutablePlan)plan, user) || honourManuallyUnmarked && PlanFavouriteServiceImpl.this.labelManager.isManuallyUnmarkedFavourite(plan, user))) {
                        return PlanFavouriteServiceImpl.this.labelManager.addFavourite(plan, user);
                    }
                    return 0;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add favourite for plan '" + plan.getKey() + "'", e);
        }
    }

    public int removeFavourite(@NotNull Plan plan, @Nullable User user) {
        if (user == null) {
            return 0;
        }
        BambooValidate.notInsideTransaction(NOT_IN_TRANSACTION_MESSAGE);
        try {
            return (Integer)this.lockFactory.apply(user.getName()).withLock(() -> this.labelManager.removeFavourite(plan, user));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not remove favourite for plan '" + plan.getKey() + "'", e);
        }
    }

    public int toggleFavourite(final @NotNull Plan plan, final @Nullable User user) {
        if (user == null) {
            return 0;
        }
        BambooValidate.notInsideTransaction(NOT_IN_TRANSACTION_MESSAGE);
        try {
            return (Integer)this.lockFactory.apply(user.getName()).withLock((Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (PlanFavouriteServiceImpl.this.labelManager.isFavourite((ImmutablePlan)plan, user)) {
                        return PlanFavouriteServiceImpl.this.labelManager.removeFavourite(plan, user);
                    }
                    return PlanFavouriteServiceImpl.this.labelManager.addFavourite(plan, user);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Could not toggle favourite for plan '" + plan.getKey() + "'", e);
        }
    }
}

