/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.util.BambooMaps;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.OptionalNarrow;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlanHelper {
    private PlanHelper() {
    }

    @NotNull
    public static LinkedHashMap<Long, PlanRepositoryDefinition> getPlanRepositoryDefinitionMap(@NotNull ImmutablePlan plan) {
        return BambooMaps.mutableLinkedUniqueIndex(PlanHelper.getPlanRepositoryDefinitions(plan), BambooIdProvider::getId);
    }

    public static List<PlanRepositoryDefinition> getPlanRepositoryDefinitions(@NotNull ImmutablePlan plan) {
        ImmutableJob job = (ImmutableJob)Narrow.to((Object)plan, ImmutableJob.class);
        ImmutableChain chain = (ImmutableChain)Narrow.to((Object)plan, ImmutableChain.class);
        if (job != null) {
            return job.getParent().getPlanRepositoryDefinitions();
        }
        if (chain != null) {
            return chain.getPlanRepositoryDefinitions();
        }
        throw new IllegalArgumentException("Don't know how to get repository definitions for " + plan.getClass());
    }

    public static List<PlanRepositoryDefinition> getPlanRepositoryDefinitionsByType(@NotNull ImmutablePlan plan, @NotNull String pluginKey) {
        return PlanHelper.getPlanRepositoryDefinitions(plan).stream().filter(r -> pluginKey.equals(r.getPluginKey())).collect(Collectors.toList());
    }

    public static PlanRepositoryDefinition getPlanRepositoryDefinitionById(@NotNull ImmutablePlan plan, long id) {
        return PlanHelper.getPlanRepositoryDefinitions(plan).stream().filter(arg_0 -> BambooPredicates.hasBambooObjectEqualId(id).apply(arg_0)).findFirst().orElse(null);
    }

    @Nullable
    public static PlanRepositoryDefinition getDefaultPlanRepositoryDefinition(@NotNull ImmutablePlan plan) {
        return (PlanRepositoryDefinition)Iterables.getFirst(PlanHelper.getPlanRepositoryDefinitions(plan), null);
    }

    public static boolean isDefault(@NotNull PlanRepositoryDefinition repositoryDefinition) {
        return repositoryDefinition.getPosition() == 0;
    }

    public static String getCurrentStatus(@NotNull ImmutablePlan plan) {
        if (plan.isActive()) {
            return "current";
        }
        ImmutableResultsSummary latestSummary = plan.getLatestResultsSummary();
        if (latestSummary != null) {
            if (latestSummary.isSuccessful()) {
                return "success";
            }
            if (latestSummary.isFailed()) {
                return "fail";
            }
            return "notRun";
        }
        return "none";
    }

    @NotNull
    public static ImmutablePlan getMasterPlan(@NotNull ImmutablePlan plan) {
        if (plan.hasMaster()) {
            return (ImmutablePlan)Preconditions.checkNotNull((Object)plan.getMaster());
        }
        return plan;
    }

    @NotNull
    public static ImmutableChain getMasterPlan(@NotNull ImmutableChain plan) {
        if (plan.hasMaster()) {
            return (ImmutableChain)Preconditions.checkNotNull((Object)plan.getMaster());
        }
        return plan;
    }

    @NotNull
    public static Chain getMasterPlan(@NotNull Chain plan) {
        if (plan.hasMaster()) {
            return (Chain)Preconditions.checkNotNull((Object)plan.getMaster());
        }
        return plan;
    }

    @NotNull
    public static PlanKey getMasterPlanKey(@NotNull ImmutablePlan plan) {
        if (plan.hasMaster()) {
            return ((ImmutablePlan)Preconditions.checkNotNull((Object)plan.getMaster())).getPlanKey();
        }
        return plan.getPlanKey();
    }

    public static ImmutableJob getBranchedImmutableJob(ImmutableChain chainBranch, ImmutableJob masterJob) {
        if (masterJob.getParent().equals(chainBranch)) {
            return masterJob;
        }
        for (ImmutableJob branchedJob : chainBranch.getAllJobs()) {
            ImmutablePlan branchedJobMaster = (ImmutablePlan)Preconditions.checkNotNull((Object)branchedJob.getMaster(), (Object)("Branched Job " + branchedJob.getPlanKey() + " does not have master"));
            if (branchedJobMaster.getId() != masterJob.getId()) continue;
            return branchedJob;
        }
        throw new IllegalArgumentException("Job " + masterJob.getPlanKey() + " was not found in the branched job");
    }

    @NotNull
    public static ImmutableChainStage getBranchedStage(ImmutableChain chainBranch, ImmutableChainStage masterStage) {
        if (masterStage.getChain().equals(chainBranch)) {
            return masterStage;
        }
        for (ImmutableChainStage branchedStage : chainBranch.getStages()) {
            ImmutableChainStage master = (ImmutableChainStage)Preconditions.checkNotNull((Object)branchedStage.getMaster(), (Object)("Branched Stage " + branchedStage.getName() + " in chain " + masterStage.getChain().getPlanKey() + " does not have Master"));
            if (master.getId() != masterStage.getId()) continue;
            return branchedStage;
        }
        throw new IllegalArgumentException("Stage [" + masterStage.getName() + "] in plan " + masterStage.getChain().getPlanKey() + " not found in a plan branch " + chainBranch.getPlanKey());
    }

    @Nullable
    public static <T> T getConfigObject(@NotNull ImmutablePlan plan, @NotNull String key, @NotNull Class<T> clazz) {
        return PlanHelper.getConfigObject(plan.getBuildDefinition(), key, clazz);
    }

    @Nullable
    public static <T> T getConfigObject(@NotNull BuildDefinition planDefinition, @NotNull String key, @NotNull Class<T> clazz) {
        return (T)Narrow.to(planDefinition.getConfigObjects().get(key), clazz);
    }

    public static long getPermissionPlanId(ImmutablePlan plan) {
        ImmutablePlan masterPlan = plan.getMaster();
        if (masterPlan != null) {
            return PlanHelper.getPermissionPlanId(masterPlan);
        }
        if (plan instanceof ImmutableJob) {
            return ((ImmutableJob)plan).getParent().getId();
        }
        if (plan instanceof ImmutableChain) {
            return plan.getId();
        }
        throw new IllegalArgumentException("Don't know how to handle permissions for " + plan);
    }

    @NotNull
    public static Set<PlanKey> getMasterAndBranchesKeys(@NotNull CachedPlanManager cachedPlanManager, @NotNull PlanKey masterOrBranchKey) {
        ImmutableChain masterPlan = cachedPlanManager.getMasterPlan(masterOrBranchKey);
        if (masterPlan == null) {
            return Collections.emptySet();
        }
        HashSet<PlanKey> branchesAndMaster = new HashSet<PlanKey>(cachedPlanManager.getBranchKeysOfChain(masterPlan.getPlanKey()));
        branchesAndMaster.add(masterPlan.getPlanKey());
        return branchesAndMaster;
    }

    public static Stream<ImmutableJob> getBranchesForJob(@NotNull CachedPlanManager cachedPlanManager, @NotNull ImmutableJob masterJob) {
        Stream branchesOfChain = cachedPlanManager.getBranchesOfChain(masterJob.getParent().getPlanKey());
        return branchesOfChain.map(ImmutableChain::getAllJobs).flatMap(Collection::stream).filter(job -> job.getMasterId() == masterJob.getId()).flatMap(OptionalNarrow.down(ImmutableJob.class));
    }

    public static boolean haveTheSameMaster(@NotNull CachedPlanManager cachedPlanManager, @NotNull PlanKey masterOrBranchKeyA, @NotNull PlanKey masterOrBranchKeyB) {
        ImmutableChain masterPlanA = cachedPlanManager.getMasterPlan(masterOrBranchKeyA);
        ImmutableChain masterPlanB = cachedPlanManager.getMasterPlan(masterOrBranchKeyB);
        return Objects.equals(masterPlanA, masterPlanB);
    }

    public static boolean haveTheSameMaster(@NotNull CachedPlanManager cachedPlanManager, @NotNull ImmutableChain masterOrBranchA, @NotNull ImmutableChain masterOrBranchB) {
        ImmutableChain masterPlanA = PlanHelper.getMasterPlan(masterOrBranchA);
        ImmutableChain masterPlanB = PlanHelper.getMasterPlan(masterOrBranchB);
        return masterPlanA.equals(masterPlanB);
    }

    public static boolean hasMultipleBranches(@NotNull CachedPlanManager cachedPlanManager, @NotNull PlanKey planKey) {
        ImmutablePlan plan = cachedPlanManager.getPlanByKey(planKey);
        Preconditions.checkArgument((plan != null ? 1 : 0) != 0, (Object)"%s doesn't identify plan");
        assert (plan != null);
        return plan.hasMaster() || cachedPlanManager.getBranchesOfChain(plan.getPlanKey()).findAny().isPresent();
    }
}

