/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectIdentifierImpl;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class PlanIdentifierImpl
implements PlanIdentifier {
    private final Long id;
    private final PlanKey planKey;
    private final String buildKey;
    private final PlanType planType;
    private final String name;
    private final String buildName;
    private final String description;
    private final boolean suspendedFromBuilding;
    private final ProjectIdentifier project;
    private final Long masterId;

    public PlanIdentifierImpl(Long id, String discriminator, PlanKey planKey, String description, String buildName, String buildKey, boolean suspendedFromBuilding, long projectId, String projectKey, String projectName, String projectDescription, Long masterId) {
        this.id = id;
        this.description = description;
        this.buildName = buildName;
        this.suspendedFromBuilding = suspendedFromBuilding;
        this.project = new ProjectIdentifierImpl(projectId, projectKey, projectName, projectDescription);
        this.planKey = planKey;
        this.buildKey = buildKey;
        this.planType = (PlanType)Preconditions.checkNotNull((Object)PlanType.valueOf((String)discriminator));
        this.name = this.project.getName() + " - " + this.getBuildName();
        this.masterId = masterId;
    }

    public PlanIdentifierImpl(PlanIdentifier plan) {
        this.id = plan.getDatabaseId().orElse(null);
        this.description = plan.getDescription();
        this.buildName = plan.getBuildName();
        this.suspendedFromBuilding = plan.isSuspendedFromBuilding();
        this.project = new ProjectIdentifierImpl(plan.getProject().getId(), plan.getProject().getKey(), plan.getProject().getName(), plan.getProject().getDescription());
        this.planKey = plan.getPlanKey();
        this.buildKey = plan.getBuildKey();
        this.planType = plan.getPlanType();
        this.name = this.project.getName() + " - " + this.getBuildName();
        this.masterId = plan.getMasterIdIfExists().orElse(null);
    }

    public long getId() {
        if (this.id == null) {
            throw new IllegalStateException("Plan " + this.planKey + " is not a DB object");
        }
        return this.id;
    }

    @NotNull
    public Optional<Long> getDatabaseId() {
        return Optional.ofNullable(this.id);
    }

    @NotNull
    public PlanType getPlanType() {
        return this.planType;
    }

    @NotNull
    public PlanKey getPlanKey() {
        return this.planKey;
    }

    @NotNull
    public String getBuildKey() {
        return this.buildKey;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getBuildName() {
        return this.buildName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSuspendedFromBuilding() {
        return this.suspendedFromBuilding;
    }

    public long getMasterId() {
        return this.masterId != null ? this.masterId : -1L;
    }

    @NotNull
    public Optional<Long> getMasterIdIfExists() {
        return Optional.ofNullable(this.masterId);
    }

    @NotNull
    public ProjectIdentifier getProject() {
        return this.project;
    }
}

