/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStorageTag;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.exception.DataAccessException;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.persistence.BambooSessionInViewFilter;
import com.atlassian.bamboo.plan.IncorrectPlanTypeException;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.schedule.PlanScheduler;
import com.atlassian.bamboo.schedule.PlanSchedulerCallback;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanManagerImpl
implements PlanManager {
    private static final Logger log = Logger.getLogger(PlanManagerImpl.class);
    private static final String CHAIN_STORAGE_TAG_PREFIX = "plan-";
    private final PlanDao planDao;
    private final BambooLicenseManager bambooLicenseManager;
    private final EventPublisher eventPublisher;
    private final ProjectManager projectManager;
    private final PlanScheduler planScheduler;

    public PlanManagerImpl(@NotNull PlanDao planDao, @NotNull BambooLicenseManager bambooLicenseManager, @NotNull EventPublisher eventPublisher, @NotNull ProjectManager projectManager, @NotNull PlanScheduler planScheduler) {
        this.planDao = planDao;
        this.bambooLicenseManager = bambooLicenseManager;
        this.eventPublisher = eventPublisher;
        this.projectManager = projectManager;
        this.planScheduler = planScheduler;
    }

    @Nullable
    public Plan getPlanById(long id) throws IncorrectPlanTypeException {
        return this.getPlanById(id, Plan.class);
    }

    private <T extends Plan> T narrowPlan(Plan plan, Object id, Class<T> planType) {
        if (plan != null) {
            if ((plan = (Plan)Narrow.to((Object)plan, planType)) == null) {
                throw new IncorrectPlanTypeException("Plan cannot be found by id '" + id + "' with type '" + planType + "'");
            }
            if (plan instanceof Chain) {
                this.initializeStagesAndJobs((Chain)plan);
            }
        }
        return (T)plan;
    }

    @Nullable
    public <T extends Plan> T getPlanById(long id, Class<T> planType) throws IncorrectPlanTypeException {
        Plan plan = (Plan)this.planDao.findById(id, Plan.class);
        return this.narrowPlan(plan, id, planType);
    }

    @Nullable
    public <T extends Plan> T getPlanByOid(BambooEntityOid oid, Class<T> planType) throws IncorrectPlanTypeException {
        Plan plan = (Plan)this.planDao.findByOid(oid, Plan.class);
        return this.narrowPlan(plan, oid, planType);
    }

    @Nullable
    public Plan getPlanByKey(@NotNull String planKey) throws IncorrectPlanTypeException {
        return this.getPlanByKey(planKey, Plan.class);
    }

    @Nullable
    public <T extends Plan> T getPlanByKey(@NotNull String planKey, Class<T> planType) throws IncorrectPlanTypeException {
        Plan plan = this.planDao.getPlanByKey(planKey, Plan.class);
        if (plan != null) {
            if ((plan = (Plan)Narrow.to((Object)plan, planType)) == null) {
                throw new IncorrectPlanTypeException("Plan cannot be found by key '" + planKey + "' with type '" + planType + "'");
            }
            if (plan instanceof Chain) {
                this.initializeStagesAndJobs((Chain)plan);
            }
        }
        return (T)plan;
    }

    public PlanIdentifier getPlanIdentifierForPermissionCheckingByKey(@NotNull String planKey) {
        return this.planDao.getPlanIdentifierForPermissionCheckingByKey(planKey);
    }

    public Class<? extends Plan> getPlanClass(@NotNull PlanKey planKey) {
        return this.planDao.getPlanClass(planKey);
    }

    public <T extends Plan> T getPlanByKeyIfOfType(@NotNull PlanKey planKey, @NotNull Class<T> planType) {
        Plan plan = this.planDao.getPlanByKey(planKey, Plan.class);
        if (plan != null) {
            if (plan instanceof Chain) {
                this.initializeStagesAndJobs((Chain)plan);
            }
            return (T)((Plan)Narrow.to((Object)plan, planType));
        }
        return null;
    }

    public Plan getPlanByKey(@NotNull PlanKey planKey) throws IncorrectPlanTypeException {
        return this.getPlanByKey(planKey.getKey());
    }

    public boolean assertPlanPermission(@NotNull PlanIdentifier plan) {
        return true;
    }

    public <T extends Plan> T getPlanByKey(@NotNull PlanKey planKey, Class<T> planType) throws IncorrectPlanTypeException {
        return this.getPlanByKey(planKey.getKey(), planType);
    }

    public boolean isChainNameConflicting(@NotNull String projectKey, long planIdToIgnore, @NotNull String planName) {
        return this.planDao.isChainNameConflicting(projectKey, planIdToIgnore, planName);
    }

    public boolean isPlanKeyConflicting(@NotNull PlanKey planKey) {
        return this.planDao.isPlanKeyConflicting(planKey);
    }

    public boolean isPlanKeyConflicting(@NotNull PlanKey planKey, long planIdToIgnore) {
        return this.planDao.isPlanKeyConflicting(planKey, planIdToIgnore);
    }

    @Nullable
    public <T extends Plan> T getPlanByPartialKeyAndName(@NotNull PlanKey partialPlanKey, @NotNull String planName, Class<T> planType) throws IncorrectPlanTypeException {
        Plan plan = this.planDao.getPlanByPartialKeyAndName(partialPlanKey, planName, Plan.class);
        if (plan != null && (plan = (Plan)Narrow.to((Object)plan, planType)) == null) {
            throw new IncorrectPlanTypeException("Plan cannot be found by name '" + planName + "' and key '" + partialPlanKey + "' with type '" + planType.getClass() + "'");
        }
        return (T)plan;
    }

    @NotNull
    public List<TopLevelPlan> getAllPlans() {
        return this.getAllPlans(TopLevelPlan.class);
    }

    @NotNull
    public List<TopLevelPlan> getAllPlansUnrestricted() {
        return this.planDao.findAllPlans(TopLevelPlan.class);
    }

    @NotNull
    public <T extends Plan> List<T> getAllPlans(Class<T> planType) {
        return this.planDao.findAllPlans(planType);
    }

    @NotNull
    public <T extends Plan> List<PlanKey> getAllPlanKeys(Class<T> planType) {
        return this.planDao.getPlanKeys(planType);
    }

    @NotNull
    public <T extends Plan> List<T> getAllPlans(Class<T> planType, int firstResult, int maxResults) {
        return this.planDao.findAllPlans(planType, firstResult, maxResults);
    }

    @NotNull
    public List<Chain> getAllChainsAndJobsUnrestricted() {
        List allPlans = this.planDao.findAllPlans(Chain.class);
        allPlans.forEach(this::initializeStagesAndJobs);
        return allPlans;
    }

    @NotNull
    public List<TopLevelPlan> getPlansByProject(Project project) {
        return this.planDao.findPlansByProject(project, TopLevelPlan.class);
    }

    @NotNull
    public <T extends Plan> List<T> getPlansByProject(Project project, Class<T> planType) {
        return this.planDao.findPlansByProject(project, planType);
    }

    @NotNull
    public <T extends Plan> List<T> getAllPlansByProject(Project project, Class<T> planType) {
        return this.planDao.findAllPlansByProject(project, planType);
    }

    @NotNull
    public <T extends Plan> List<PlanIdentifier> getPlanIdentifiersForProject(@NotNull ProjectIdentifier project, @NotNull Class<T> planType, boolean includeMarkedForDeletion) {
        return this.planDao.getPlanIdentifiersForProject(project, planType, includeMarkedForDeletion);
    }

    @NotNull
    public <T extends Plan> Map<Project, Collection<T>> getProjectPlanMap(Class<T> planType, boolean includeEmptyProjects) {
        ArrayListMultimap projectPlanMap = ArrayListMultimap.create();
        for (Plan plan : this.planDao.findAllPlans(planType)) {
            projectPlanMap.put((Object)plan.getProject(), (Object)plan);
        }
        HashMap result = new HashMap(projectPlanMap.asMap());
        if (includeEmptyProjects) {
            this.projectManager.getProjects().forEach(project -> {
                Collection cfr_ignored_0 = result.putIfAbsent((Project)project, Collections.emptyList());
            });
        }
        return result;
    }

    public int getPlanCount() {
        return this.getPlanCount(Buildable.class);
    }

    public <T extends Plan> int getPlanCount(Class<T> planType) {
        return this.planDao.getPlanCount(planType);
    }

    public int getPlanCount(@NotNull ProjectIdentifier projectIdentifier) {
        return this.planDao.getPlanCount(projectIdentifier);
    }

    public void savePlan(@NotNull Plan plan) {
        this.planDao.save((BambooObject)plan);
    }

    public void savePlanWithSchedulesStopped(@NotNull Plan plan) {
        this.planScheduler.executeWithoutPlanSchedules(new PlanSchedulerCallback(plan){

            protected void run(Plan plan) {
                PlanManagerImpl.this.savePlan(plan);
            }
        });
    }

    public void createPlan(@NotNull Plan plan) {
        if (plan.getId() != -1L) {
            throw new IllegalStateException("A call to createPlan() with plan id != -1 would trigger an update instead of create.");
        }
        this.savePlan(plan);
        if (plan instanceof Chain) {
            ((Chain)plan).setStorageTag(new ChainStorageTag(CHAIN_STORAGE_TAG_PREFIX + plan.getId()));
            this.savePlan(plan);
        }
    }

    public void setPlanSuspendedState(PlanKey planKey, boolean isSuspended) {
        Plan plan = this.getPlanByKey(planKey, Plan.class);
        if (plan != null) {
            boolean stateChanged;
            boolean bl = stateChanged = plan.isSuspendedFromBuilding() != isSuspended;
            if (!stateChanged) {
                return;
            }
            if (isSuspended) {
                this.planScheduler.removeTasksScheduledForPlan((ImmutablePlan)plan);
            }
            plan.setSuspendedFromBuilding(isSuspended);
            this.planDao.save((BambooObject)plan);
            if (!isSuspended) {
                this.planScheduler.scheduleTasksForPlan((ImmutablePlan)plan);
            }
        }
    }

    public boolean isPlanCreationAllowed() {
        int currentPlans;
        int planLimit = this.bambooLicenseManager.getAllowedNumberOfPlans();
        return -1 == planLimit || (currentPlans = this.getPlanCount(Buildable.class)) < planLimit;
    }

    public void triggerConfigUpdatedEventsForPlansInProject(@NotNull Project project) {
        List siblingBuilds = this.planDao.findPlansByProject(project, Plan.class);
        for (Plan affectedBuild : siblingBuilds) {
            this.eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, affectedBuild.getPlanKey()));
        }
    }

    public void deletePlan(@NotNull Plan plan) {
        this.planDao.delete((BambooObject)plan);
    }

    @NotNull
    public <T extends Plan> Collection<T> getAllPlansMarkedForDeletion(Class<T> planType) {
        return this.planDao.getAllPlansMarkedForDeletion(planType);
    }

    public void markPlansForDeletion(PlanKey planKey) {
        this.planDao.markPlanForDeletion(planKey);
    }

    public void syncDeletionStatusOfJobs() {
        this.planDao.syncDeletionStatusOfJobs();
    }

    public void syncDeletionStatusOfChainBranches() {
        this.planDao.syncDeletionStatusOfChainBranches();
    }

    public void removeStages(@NotNull PlanKey key, @NotNull Collection<Long> stageIds) {
        log.info((Object)("Removing " + stageIds.size() + " stage(s) for plan " + key));
        Chain chain = (Chain)this.planDao.getPlanByKey(key.getKey(), Chain.class);
        if (chain == null) {
            throw new IllegalStateException("No plan found for key " + key + ". Stages not deleted: " + ToStringBuilder.reflectionToString(stageIds));
        }
        stageIds.forEach(arg_0 -> ((Chain)chain).removeStage(arg_0));
        this.planDao.save((BambooObject)chain);
    }

    private void initializeStagesAndJobs(@NotNull Chain chain) {
        if (!BambooSessionInViewFilter.isInSessionInView()) {
            try {
                Hibernate.initialize((Object)chain.getStages());
            }
            catch (HibernateException e) {
                throw new DataAccessException("Unable to initialise stages for " + chain.getKey(), (Throwable)e);
            }
        }
    }

    @NotNull
    public Set<ImmutableChain> filterFavouritedPlans(@NotNull Collection<? extends ImmutableChain> plans, @NotNull User user) {
        return new HashSet<ImmutableChain>(this.planDao.filterFavouritedPlans(plans, user));
    }

    public Set<ImmutableChain> getFavouritePlans(@NotNull User user) {
        List<Chain> allPlans = this.getAllPlans(Chain.class);
        return this.filterFavouritedPlans(allPlans, user);
    }

    @NotNull
    public Set<Long> getFavouritePlansIds(@NotNull User user) {
        return this.planDao.getFavouritePlansIds(user);
    }
}

