/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.configuration.ConfigurationException;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanParticle;
import com.atlassian.bamboo.plan.PlanParticleManager;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PlanParticleManagerImpl
implements PlanParticleManager {
    private static final Logger log = Logger.getLogger(PlanParticleManagerImpl.class);
    private SetMultimap<PlanKey, PlanParticle> consumedParticlesByPlanKey = HashMultimap.create();
    private SetMultimap<PlanKey, PlanParticle> producedParticlesByPlanKey = HashMultimap.create();
    private SetMultimap<PlanParticle, PlanKey> consumerByParticle = HashMultimap.create();
    private SetMultimap<PlanParticle, PlanKey> producerByParticle = HashMultimap.create();
    private final PlanManager planManager;

    public PlanParticleManagerImpl(PlanManager planManager) {
        this.planManager = planManager;
    }

    @NotNull
    public Set<PlanKey> getConsumersPlanKeys(Iterable<? extends PlanParticle> planParticles) {
        HashSet<PlanKey> planKeys = new HashSet<PlanKey>();
        for (PlanParticle planParticle : planParticles) {
            planKeys.addAll(this.consumerByParticle.get((Object)planParticle));
        }
        return planKeys;
    }

    @NotNull
    public Set<PlanKey> getConsumersPlanKeys(@NotNull PlanKey planKey) {
        return this.getConsumersPlanKeys(this.producedParticlesByPlanKey.get((Object)planKey));
    }

    @NotNull
    public Set<PlanKey> getProducersPlanKeys(Iterable<? extends PlanParticle> planParticles) {
        HashSet<PlanKey> planKeys = new HashSet<PlanKey>();
        for (PlanParticle planParticle : planParticles) {
            planKeys.addAll(this.producerByParticle.get((Object)planParticle));
        }
        return planKeys;
    }

    @NotNull
    public Set<PlanKey> getProducersPlanKeys(@NotNull PlanKey planKey) {
        return this.getProducersPlanKeys(this.consumedParticlesByPlanKey.get((Object)planKey));
    }

    public void adjustPlanParticles(@NotNull PlanKey planKey, @NotNull Collection<? extends PlanParticle> consumedParticles, @NotNull Collection<? extends PlanParticle> producedParticles) throws ConfigurationException {
        Plan plan = this.planManager.getPlanByKey(planKey);
        if (plan != null) {
            if (CollectionUtils.containsAny(this.getProducersPlanKeys(consumedParticles), this.getConsumersPlanKeys(producedParticles))) {
                throw new ConfigurationException("Did not set up dependencies based on maven pom.xml. Cyclic dependency was detected.");
            }
            Set previouslyConsumedParticles = this.consumedParticlesByPlanKey.get((Object)planKey);
            Set previouslyProducedParticles = this.producedParticlesByPlanKey.get((Object)planKey);
            HashSet<? extends PlanParticle> consumedDeltaPlus = new HashSet<PlanParticle>(consumedParticles);
            consumedDeltaPlus.removeAll(previouslyConsumedParticles);
            for (PlanParticle planParticle : consumedDeltaPlus) {
                this.consumerByParticle.put((Object)planParticle, (Object)planKey);
            }
            HashSet consumedDeltaMinus = new HashSet(previouslyConsumedParticles);
            consumedDeltaMinus.removeAll(consumedParticles);
            for (Object planParticle : consumedDeltaMinus) {
                this.consumerByParticle.remove(planParticle, (Object)planKey);
            }
            HashSet<? extends PlanParticle> hashSet = new HashSet<PlanParticle>(producedParticles);
            hashSet.removeAll(previouslyProducedParticles);
            for (PlanParticle planParticle : hashSet) {
                this.producerByParticle.put((Object)planParticle, (Object)planKey);
            }
            HashSet producedDeltaMinus = new HashSet(previouslyProducedParticles);
            producedDeltaMinus.removeAll(producedParticles);
            for (PlanParticle planParticle : producedDeltaMinus) {
                this.producerByParticle.remove((Object)planParticle, (Object)planKey);
            }
            this.consumedParticlesByPlanKey.replaceValues((Object)planKey, consumedParticles);
            this.producedParticlesByPlanKey.replaceValues((Object)planKey, producedParticles);
        }
    }

    public void removePlanParticles(@NotNull PlanKey planKey) {
        this.consumedParticlesByPlanKey.removeAll((Object)planKey);
        this.producedParticlesByPlanKey.removeAll((Object)planKey);
        HashSet producerParticles = new HashSet(this.producerByParticle.keys());
        for (PlanParticle planParticle : producerParticles) {
            this.producerByParticle.remove((Object)planParticle, (Object)planKey);
        }
        HashSet consumerParticles = new HashSet(this.consumerByParticle.keys());
        for (PlanParticle planParticle : consumerParticles) {
            this.consumerByParticle.remove((Object)planParticle, (Object)planKey);
        }
    }
}

