/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.BranchCommitInformation;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanPredicates {
    private static final Logger log = Logger.getLogger(PlanPredicates.class);

    public static boolean isCloverEnabled(ImmutablePlan plan) {
        ImmutableChain chain = (ImmutableChain)Narrow.to((Object)Preconditions.checkNotNull((Object)plan), ImmutableChain.class);
        if (chain != null) {
            return chain.getAllJobs().stream().anyMatch(PlanPredicates::isCloverEnabled);
        }
        Map customConfiguration = plan.getBuildDefinition().getCustomConfiguration();
        return customConfiguration != null && Boolean.parseBoolean((String)customConfiguration.get("custom.clover.exists"));
    }

    public static Predicate<ImmutablePlan> isFavourite(@NotNull LabelManager labelManager, @NotNull User user) {
        return plan -> labelManager.isFavourite(plan, user);
    }

    public static Predicate<ImmutablePlan> isMyBranch(User user) {
        return plan -> {
            Author branchAuthor = PlanPredicates.getBranchAuthor(plan);
            return branchAuthor != null && Objects.equals(branchAuthor.getLinkedUserName(), user.getName());
        };
    }

    private static Author getBranchAuthor(@Nullable ImmutablePlan branch) {
        ImmutableChainBranch b;
        BranchCommitInformation information;
        Author author = null;
        if (branch instanceof ImmutableChainBranch && (information = (b = (ImmutableChainBranch)branch).getCommitInformation()) != null && (author = information.getCreatingAuthor()) == null) {
            author = information.getLatestCommitAuthor();
        }
        return author;
    }

    public static boolean planIsMaster(ImmutablePlan plan) {
        return !plan.hasMaster();
    }

    public static Predicate<ImmutablePlan> withEqualProjectKey(Project project) {
        return plan -> Objects.equals(plan.getProject().getKey(), project.getKey());
    }

    public static Predicate<PlanIdentifier> hasEqualPlanKey(@NotNull PlanKey planKey) {
        return plan -> Objects.equals(plan.getPlanKey(), planKey);
    }

    public static Predicate<PlanIdentifier> hasEqualBuildName(@NotNull String name) {
        return plan -> Objects.equals(plan.getBuildName(), name);
    }

    public static <T extends ImmutablePlan> Predicate<T> isBranchOf(@NotNull PlanIdentifier master) {
        return plan -> {
            ImmutablePlan branchMaster = plan.getMaster();
            return branchMaster != null && master.getDatabaseId().isPresent() && master.getId() == branchMaster.getId();
        };
    }

    public static <T extends ImmutableChain> boolean hasJobs(@NotNull T chain) {
        return !chain.getAllJobs().isEmpty();
    }
}

