/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ReasonForBuild;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CurrentlyBuildingContainer;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.DeltaState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.ChainState;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.chains.branches.MergeResultSummaryImpl;
import com.atlassian.bamboo.container.PersisterFactory;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.event.ResultsSummaryUpdatedEvent;
import com.atlassian.bamboo.index.BuildResultsIndexer;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.PlanStatePersister;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.results.warning.BuildWarningSummary;
import com.atlassian.bamboo.resultsummary.AbstractResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummary;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryDao;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryImpl;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.trigger.DependencyTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.trigger.InitialBuildTriggerReason;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopyCommit;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopyState;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class PlanStatePersisterImpl
implements PlanStatePersister {
    private static final Logger log = Logger.getLogger(PlanStatePersisterImpl.class);
    private final PlanManager planManager;
    private final BuildResultsIndexer buildResultsIndexer;
    private final BuildResultsSummaryManager buildResultsSummaryManager;
    private final CurrentlyBuildingContainer currentlyBuildingContainer;
    private final ResultsSummaryManager resultsSummaryManager;
    private final ErrorUpdateHandler errorUpdateHandler;
    private final BuildLoggerManager buildLoggerManager;
    private final TestsManager testsManager;
    private final EventPublisher eventPublisher;
    @Autowired
    @Lazy
    private CachedPlanManager cachedPlanManager;
    private final BuildResultWarningSummaryDao buildResultWarningSummaryDao;
    private final PlanVcsRevisionHistoryService planVcsRevisionHistoryService;

    public PlanStatePersisterImpl(PlanManager planManager, BuildResultsIndexer buildResultsIndexer, BuildResultsSummaryManager buildResultsSummaryManager, CurrentlyBuildingContainer currentlyBuildingContainer, ResultsSummaryManager resultsSummaryManager, ErrorUpdateHandler errorUpdateHandler, BuildLoggerManager buildLoggerManager, TestsManager testsManager, EventPublisher eventPublisher, BuildResultWarningSummaryDao buildResultWarningSummaryDao, PlanVcsRevisionHistoryService planVcsRevisionHistoryService) {
        this.planManager = planManager;
        this.buildResultsIndexer = buildResultsIndexer;
        this.buildResultsSummaryManager = buildResultsSummaryManager;
        this.currentlyBuildingContainer = currentlyBuildingContainer;
        this.resultsSummaryManager = resultsSummaryManager;
        this.errorUpdateHandler = errorUpdateHandler;
        this.buildLoggerManager = buildLoggerManager;
        this.testsManager = testsManager;
        this.eventPublisher = eventPublisher;
        this.buildResultWarningSummaryDao = buildResultWarningSummaryDao;
        this.planVcsRevisionHistoryService = planVcsRevisionHistoryService;
    }

    @Override
    @NotNull
    public BuildContext saveFinishedBuildResult(@NotNull BuildContext buildContext) throws Exception {
        PlanKey chainKey = buildContext.getParentBuildContext().getTypedPlanKey();
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKey(chainKey, ImmutableChain.class);
        if (chain == null) {
            log.info((Object)("Trying to save a result but plan doesn't exist: " + chainKey));
            throw new IllegalStateException("Chain not found: " + chainKey);
        }
        PlanKey planKey = buildContext.getPlanResultKey().getPlanKey();
        ImmutableBuildable build = (ImmutableBuildable)this.cachedPlanManager.getPlanByKey(planKey, ImmutableBuildable.class);
        BuildResults buildResults = this.populateBuildExecutionInfo(buildContext);
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)buildContext.getPlanResultKey());
        try {
            log.info((Object)buildLogger.addBuildLogEntry("Generating build results summary..."));
            CurrentlyBuilding currentlyBuilding = this.currentlyBuildingContainer.getCurrentlyBuildingByResultKey((ResultKey)buildContext.getPlanResultKey());
            BuildResultsSummary summary = this.buildResultsSummaryManager.updateBuildSummaryFromBuildResults(buildContext, currentlyBuilding, buildResults);
            this.testsManager.copyTestResultsToBuildResultsSummary(summary, buildResults, buildContext);
            log.debug((Object)buildLogger.addBuildLogEntry("Saving build results to disk..."));
            this.persistBuildResults(planKey, buildResults);
            log.debug((Object)buildLogger.addBuildLogEntry("Logging substituted variables..."));
            this.resultsSummaryManager.logSubstitutedVariables(buildContext, (ResultsSummary)summary);
            this.resultsSummaryManager.postBuildVariableSnapshotUpdate((ResultsSummary)summary, buildContext.getVariableContext());
            this.resultsSummaryManager.saveResultSummary((ResultsSummary)summary);
            this.checkAndUpdateDeltaStatesOfFollowingBuild(summary.getPlanResultKey());
            this.updateBuildWarnings(summary, buildContext.getBuildResult().getBuildWarningSummaries());
            this.processUpdatedRevisionsToBeIgnoredByChangeDetection(buildContext.getBuildResult().getVcsWorkingCopyState(), summary.getChainResultsSummary().getPlanKey(), summary.getBuildNumber());
            buildLogger.addBuildLogEntry("Indexing build results...");
            log.debug((Object)("Indexing " + summary.getPlanResultKey()));
            this.indexBuildResults(chain, build, summary, buildLogger);
            log.debug((Object)("Finished build: " + buildContext.getBuildResultKey()));
        }
        catch (Throwable e) {
            String message = "Could not save the build results " + buildResults + ". Data could be in an inconsistent state.";
            this.errorUpdateHandler.recordError((ResultKey)buildContext.getPlanResultKey(), "Could not save the build results. Data could be in an inconsistent state.", e);
            log.fatal((Object)message, e);
            log.error((Object)"Attempting to clean up build results data");
            this.deleteBuildResults(planKey, buildContext.getBuildNumber(), buildResults);
            throw new Exception(message, e);
        }
        finally {
            log.debug((Object)buildLogger.addBuildLogEntry("Finished building " + buildResults.getBuildResultsKey() + "."));
        }
        return buildContext;
    }

    @Override
    public void saveNotBuiltBuildResult(PlanResultKey planResultKey, boolean updateFollowingBuilds) {
        ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey);
        if (resultsSummary == null) {
            throw new IllegalStateException("Result summary for build " + planResultKey + " expected to be not null in saveNotBuiltBuildResult");
        }
        this.resultsSummaryManager.updateLifeCycleState(resultsSummary, LifeCycleState.NOT_BUILT, BuildState.UNKNOWN);
        this.resultsSummaryManager.calculateAndSetDeltaState(resultsSummary);
        if (updateFollowingBuilds) {
            this.checkAndUpdateDeltaStatesOfFollowingBuild(planResultKey);
        }
    }

    @Override
    public void persistChainState(@NotNull ChainState chainState) {
        ChainResultsSummary chainResult = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(chainState.getPlanResultKey(), ChainResultsSummary.class);
        if (chainResult == null) {
            return;
        }
        MergeResultSummary oldMergeResult = chainResult.getMergeResult();
        if (oldMergeResult != null && chainState.getMergeResult() != null) {
            MergeResultSummaryImpl.copy(chainState.getMergeResult(), oldMergeResult);
        } else {
            chainResult.setMergeResult(chainState.getMergeResult());
        }
        if (chainState.isCompleted()) {
            this.updateJobPendingStatesToNotBuilt(chainResult);
            BuildState buildState = chainState.isSuccessful() ? BuildState.SUCCESS : (chainState.isFailed() ? BuildState.FAILED : BuildState.UNKNOWN);
            chainResult.updateLifeCycleState(buildState == BuildState.UNKNOWN ? LifeCycleState.NOT_BUILT : LifeCycleState.FINISHED, buildState);
            this.resultsSummaryManager.calculateAndSetDeltaState((ResultsSummary)chainResult);
            this.resultsSummaryManager.updatePlanCompletedDate(chainResult, new Date());
            this.updateChainTestSummary(chainResult);
            this.checkAndUpdateDeltaStatesOfFollowingBuild(chainState.getPlanResultKey());
            this.updateFixedInResultForThisAndPreviousBuilds(chainResult);
            this.updateChainWarningSummaries(chainResult);
        }
        chainResult.setContinuable(chainState.isContinuable());
        this.resultsSummaryManager.saveResultSummary((ResultsSummary)chainResult);
        if (oldMergeResult != null && chainResult.getMergeResult() == null) {
            this.resultsSummaryManager.removeMergeResultSummary(oldMergeResult);
        }
    }

    private static ReasonForBuild getReasonForBuild(BuildContext buildContext) {
        TriggerReason reason = buildContext.getTriggerReason();
        if (reason instanceof ManualBuildTriggerReason) {
            return ReasonForBuild.MANUAL_BUILD;
        }
        if (reason instanceof DependencyTriggerReason) {
            return ReasonForBuild.DEPENDENCY_BUILD;
        }
        if (reason instanceof InitialBuildTriggerReason) {
            return ReasonForBuild.INITIAL_CLEAN_BUILD;
        }
        return ReasonForBuild.CODE_HAS_CHANGED;
    }

    private void updateJobPendingStatesToNotBuilt(ChainResultsSummary chainResult) {
        for (ChainStageResult chainStageResult : chainResult.getStageResults()) {
            long chainStageResultId = chainStageResult.getId();
            for (BuildResultsSummary resultsSummary : chainStageResult.getBuildResults()) {
                if (!LifeCycleState.isWaiting((LifeCycleState)resultsSummary.getLifeCycleState())) continue;
                try {
                    this.updateChainStageResultId(resultsSummary, chainStageResultId);
                    this.saveNotBuiltBuildResult(resultsSummary.getPlanResultKey(), true);
                }
                catch (Exception e) {
                    log.error((Object)"Error during transition of job to NOT_BUILT state", (Throwable)e);
                }
            }
        }
    }

    private void updateChainStageResultId(BuildResultsSummary resultsSummary, Long chainStageResultId) {
        AbstractResultsSummary abs = (AbstractResultsSummary)Narrow.reinterpret((Object)resultsSummary, AbstractResultsSummary.class);
        if (abs != null && abs.getStageResultId() == null) {
            abs.setStageResultId(chainStageResultId);
        }
    }

    private void checkAndUpdateDeltaStatesOfFollowingBuild(PlanResultKey planResultKey) {
        log.info((Object)("Updating delta states of build following " + planResultKey));
        ResultsSummary followingResult = this.resultsSummaryManager.findFirstResultAfter(planResultKey, ResultsSummary.class);
        if (followingResult == null) {
            return;
        }
        log.info((Object)("Out of order build execution detected for build " + planResultKey));
        this.resultsSummaryManager.calculateAndSetDeltaState(followingResult);
        if (followingResult instanceof BuildResultsSummary) {
            BuildResults buildResults = this.loadBuildResults(planResultKey.getPlanKey(), followingResult.getBuildNumber());
            if (buildResults != null) {
                this.testsManager.repopulateTestResultsInBuildResultsSummary((BuildResultsSummary)followingResult, buildResults.getSuccessfulTestResults());
            }
        } else {
            this.updateChainTestSummary((ChainResultsSummary)followingResult);
        }
        this.resultsSummaryManager.saveResultSummary(followingResult);
        this.eventPublisher.publish((Object)new ResultsSummaryUpdatedEvent(this, followingResult.getPlanResultKey(), Collections.emptySet()));
    }

    @VisibleForTesting
    public void updateFixedInResultForThisAndPreviousBuilds(ChainResultsSummary chainResult) {
        ResultsSummary followingResult;
        if (DeltaState.FIXED == chainResult.getDeltaState() || DeltaState.PASSING == chainResult.getDeltaState()) {
            ResultsSummary lastSuccessfulResultsSummary = this.resultsSummaryManager.findLastSuccessfulBuildResultBefore(chainResult.getPlanResultKey());
            if (lastSuccessfulResultsSummary != null && lastSuccessfulResultsSummary.getBuildNumber() == chainResult.getBuildNumber() - 1) {
                return;
            }
            ResultsSummaryCriteria criteria = new ResultsSummaryCriteria();
            if (lastSuccessfulResultsSummary != null) {
                criteria.setFromBuildNumber(lastSuccessfulResultsSummary.getBuildNumber() + 1);
            }
            criteria.setToBuildNumber(chainResult.getBuildNumber() - 1);
            criteria.setBuildKey(chainResult.getPlanKey().getKey());
            criteria.setResultSummaryClass(ChainResultsSummary.class);
            criteria.setLifeCycleStates((Set)LifeCycleState.FINAL_STATES);
            List previousResults = this.resultsSummaryManager.getResultSummaries(criteria);
            for (ChainResultsSummary result : previousResults) {
                Integer previousFixedIn = result.getFixedInResult();
                if (previousFixedIn != null && previousFixedIn <= chainResult.getBuildNumber()) continue;
                result.setFixedInResult(Integer.valueOf(chainResult.getBuildNumber()));
                this.resultsSummaryManager.saveResultSummary((ResultsSummary)result);
                this.eventPublisher.publish((Object)new ResultsSummaryUpdatedEvent(this, result.getPlanResultKey(), Collections.emptySet()));
            }
        } else if (BuildState.SUCCESS != chainResult.getBuildState() && (followingResult = this.resultsSummaryManager.findFirstSuccessfulBuildResultAfter(chainResult.getPlanResultKey())) != null) {
            chainResult.setFixedInResult(Integer.valueOf(followingResult.getBuildNumber()));
            this.resultsSummaryManager.saveResultSummary((ResultsSummary)chainResult);
        }
    }

    private BuildResults createBuildResults(@NotNull BuildContext buildContext) {
        CurrentBuildResult currentBuildResult = buildContext.getBuildResult();
        return currentBuildResult.cloneAsBuildResults(buildContext, PlanStatePersisterImpl.getReasonForBuild(buildContext));
    }

    private BuildResults populateBuildExecutionInfo(BuildContext buildContext) {
        BuildResults buildResults = this.createBuildResults(buildContext);
        CurrentlyBuilding building = this.currentlyBuildingContainer.getCurrentlyBuildingByResultKey((ResultKey)buildContext.getPlanResultKey());
        if (building != null) {
            buildResults.setStartTime(building.getStartTime());
            buildResults.setDurationInMilliseconds(building.getElapsedTime());
        } else {
            log.warn((Object)("Build result " + buildResults.getBuildResultsKey() + " is saved but no corresponding build execution information found."));
        }
        return buildResults;
    }

    private void persistBuildResults(PlanKey planKey, BuildResults buildResults) {
        Persister persister = PersisterFactory.getInstance();
        persister.addBuildResults(planKey, buildResults);
    }

    @Nullable
    private BuildResults loadBuildResults(PlanKey planKey, int buildNumber) {
        Persister persister = PersisterFactory.getInstance();
        return persister.getBuildResults((Key)planKey, buildNumber);
    }

    private void deleteBuildResults(PlanKey planKey, int buildNumber, BuildResults buildResults) {
        try {
            Persister persister = PersisterFactory.getInstance();
            persister.deleteBuildResults(planKey, (long)buildNumber);
        }
        catch (Exception exception) {
            log.error((Object)("Bamboo failed to clean up results for " + buildResults));
        }
    }

    private void indexBuildResults(ImmutableChain chain, ImmutableBuildable build, BuildResultsSummary summary, BuildLogger buildLogger) {
        try {
            this.buildResultsIndexer.indexResultSummary((ResultsSummary)summary, chain, (ImmutablePlan)build);
        }
        catch (Throwable e) {
            this.errorUpdateHandler.recordError((ResultKey)summary.getPlanResultKey(), "Error occurred while saving build results. Reindex failed.", e);
            log.error((Object)("Failed to index build results " + summary.getPlanResultKey()), e);
        }
    }

    private void updateChainTestSummary(ChainResultsSummary chainResultsSummary) {
        TestResultsSummaryImpl chainTestResultsSummary = new TestResultsSummaryImpl();
        chainResultsSummary.setTestResultsSummary((TestResultsSummary)chainTestResultsSummary);
        for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
            for (BuildResultsSummary resultsSummary : chainStageResult.getBuildResults()) {
                chainTestResultsSummary.addCountsFrom(resultsSummary.getTestResultsSummary());
            }
        }
    }

    @VisibleForTesting
    void updateBuildWarnings(@NotNull BuildResultsSummary buildResultsSummary, @NotNull Collection<BuildWarningSummary> warnings) {
        Map knownChainResultWarnings = (Map)this.buildResultWarningSummaryDao.findByResult(buildResultsSummary.getId()).stream().collect(BambooCollectors.toHashMap(BuildResultWarningSummary::getRepositoryId));
        for (BuildWarningSummary warning : warnings) {
            BuildResultWarningSummaryImpl byResultAndRepository = (BuildResultWarningSummaryImpl)((Object)knownChainResultWarnings.get(warning.getRepositoryId()));
            if (byResultAndRepository != null) {
                knownChainResultWarnings.remove(warning.getRepositoryId());
                byResultAndRepository.setHighPriorityCount(warning.getHighPriorityCount());
                byResultAndRepository.setNormalPriorityCount(warning.getNormalPriorityCount());
                byResultAndRepository.setLowPriorityCount(warning.getLowPriorityCount());
                this.buildResultWarningSummaryDao.save((BambooObject)byResultAndRepository);
                continue;
            }
            BuildResultWarningSummaryImpl summary = new BuildResultWarningSummaryImpl((ImmutableResultsSummary)buildResultsSummary, warning.getRepositoryId(), warning.getHighPriorityCount(), warning.getNormalPriorityCount(), warning.getLowPriorityCount());
            this.buildResultWarningSummaryDao.save((BambooObject)summary);
        }
        this.buildResultWarningSummaryDao.deleteAll(knownChainResultWarnings.values());
    }

    @VisibleForTesting
    void updateChainWarningSummaries(@NotNull ChainResultsSummary chainResultsSummary) {
        HashMap actualChainSummaries = new HashMap();
        chainResultsSummary.getStageResults().stream().map(ChainStageResult::getBuildResults).flatMap(Collection::stream).map(buildResult -> this.buildResultWarningSummaryDao.findByResult(buildResult.getId())).flatMap(Collection::stream).forEach(summary -> {
            BuildWarningSummary byRepository = actualChainSummaries.computeIfAbsent(summary.getRepositoryId(), repositoryId -> new BuildWarningSummary(repositoryId.longValue(), 0L, 0L, 0L));
            byRepository.append(summary);
        });
        ArrayList knownChainResultWarnings = new ArrayList(this.buildResultWarningSummaryDao.findByResult(chainResultsSummary.getId()));
        Iterator iterator = knownChainResultWarnings.iterator();
        while (iterator.hasNext()) {
            BuildResultWarningSummary chainResultWarning = (BuildResultWarningSummary)iterator.next();
            BuildWarningSummary chainWarningSummaryByRepository = (BuildWarningSummary)actualChainSummaries.remove(chainResultWarning.getRepositoryId());
            if (chainWarningSummaryByRepository == null) {
                this.buildResultWarningSummaryDao.delete((BambooObject)chainResultWarning);
                continue;
            }
            chainResultWarning.setHighPriorityCount(chainWarningSummaryByRepository.getHighPriorityCount());
            chainResultWarning.setNormalPriorityCount(chainWarningSummaryByRepository.getNormalPriorityCount());
            chainResultWarning.setLowPriorityCount(chainWarningSummaryByRepository.getLowPriorityCount());
            this.buildResultWarningSummaryDao.save((BambooObject)chainResultWarning);
            iterator.remove();
        }
        this.buildResultWarningSummaryDao.deleteAll(knownChainResultWarnings);
        actualChainSummaries.values().forEach(summary -> this.buildResultWarningSummaryDao.save((BambooObject)new BuildResultWarningSummaryImpl((ImmutableResultsSummary)chainResultsSummary, summary.getRepositoryId(), summary.getHighPriorityCount(), summary.getNormalPriorityCount(), summary.getLowPriorityCount())));
    }

    private void processUpdatedRevisionsToBeIgnoredByChangeDetection(@NotNull VcsWorkingCopyState vcsWorkingCopyState, @NotNull PlanKey planKey, int buildNumber) {
        for (VcsWorkingCopyCommit commit : vcsWorkingCopyState.getCommits()) {
            this.planVcsRevisionHistoryService.markChangeDetectionCompleted(planKey, buildNumber, new PlanVcsRevisionData(commit.getRevisionId(), null, null), commit.getRepositoryId());
        }
    }
}

