/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.chains.ChainState;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.PlanStatePersister;
import com.atlassian.bamboo.plan.PlanStatePersisterService;
import com.atlassian.bamboo.v2.build.BuildContext;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.function.Function;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;

public class PlanStatePersisterServiceImpl
implements PlanStatePersisterService {
    @Lazy
    @Inject
    private PlanStatePersister planStatePersister;
    private final Function<String, ManagedLock> lockManager = ManagedLocks.weakManagedLockFactory();

    @Override
    @NotNull
    public BuildContext saveFinishedBuildResult(@NotNull BuildContext buildContext) throws Exception {
        return (BuildContext)this.lockManager.apply(buildContext.getTypedPlanKey().getKey().intern()).withLock(() -> this.planStatePersister.saveFinishedBuildResult(buildContext));
    }

    @Override
    public void saveNotBuiltBuildResult(@NotNull PlanResultKey planResultKey, boolean updateFollowingBuilds) {
        this.lockManager.apply(planResultKey.getPlanKey().getKey().intern()).withLock(() -> this.planStatePersister.saveNotBuiltBuildResult(planResultKey, updateFollowingBuilds));
    }

    @Override
    public void persistChainState(@NotNull ChainState chainState) {
        this.lockManager.apply(chainState.getPlanResultKey().getPlanKey().getKey().intern()).withLock(() -> this.planStatePersister.persistChainState(chainState));
    }
}

