/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.trigger.TriggerableInternalKey;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.base.Objects;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class TriggerableInternalKeyImpl
implements TriggerableInternalKey {
    private static final Logger log = Logger.getLogger(TriggerableInternalKeyImpl.class);
    private final Type type;
    @Nullable
    private final PlanKey planKey;
    @Nullable
    private final Long environmentId;
    @Nullable
    private final Long stageId;
    @NotNull
    private final String synteticKey;

    public TriggerableInternalKeyImpl(@NotNull Triggerable triggerable) {
        ImmutableChain immutableChain = (ImmutableChain)Narrow.downTo((Object)triggerable, ImmutableChain.class);
        this.planKey = immutableChain != null ? immutableChain.getPlanKey() : null;
        this.environmentId = immutableChain == null ? Long.valueOf(triggerable.getId()) : null;
        this.stageId = null;
        this.type = immutableChain != null ? Type.CHAIN : Type.ENVIRONMENT;
        this.synteticKey = this.computeKey();
    }

    public TriggerableInternalKeyImpl(@NotNull PlanKey planKey) {
        this.type = Type.CHAIN;
        this.planKey = planKey;
        this.stageId = null;
        this.environmentId = null;
        this.synteticKey = this.computeKey();
    }

    public TriggerableInternalKeyImpl(@NotNull PlanKey planKey, long stageId) {
        this.type = Type.STAGE;
        this.planKey = planKey;
        this.environmentId = null;
        this.stageId = stageId;
        this.synteticKey = this.computeKey();
    }

    private TriggerableInternalKeyImpl(long environmentId) {
        this.type = Type.ENVIRONMENT;
        this.planKey = null;
        this.stageId = null;
        this.environmentId = environmentId;
        this.synteticKey = this.computeKey();
    }

    public static TriggerableInternalKey forEnvironmentId(long environmentId) {
        return new TriggerableInternalKeyImpl(environmentId);
    }

    public static TriggerableInternalKey forPlanKey(@NotNull PlanKey planKey) {
        return new TriggerableInternalKeyImpl(planKey);
    }

    public static TriggerableInternalKey forStageId(@NotNull PlanKey planKey, long stageId) {
        return new TriggerableInternalKeyImpl(planKey, stageId);
    }

    private String computeKey() {
        switch (this.type) {
            case CHAIN: {
                return this.type.name() + ":" + this.planKey;
            }
            case ENVIRONMENT: {
                return this.type.name() + ":" + this.environmentId;
            }
            case STAGE: {
                return this.type.name() + ":" + this.planKey + ":" + this.stageId;
            }
        }
        throw new UnsupportedOperationException("neither chain nor environment not stage... It can't be");
    }

    @NotNull
    public String getKey() {
        return this.synteticKey;
    }

    @Nullable
    public PlanKey getPlanKey() {
        return this.planKey;
    }

    public String toString() {
        return this.getKey();
    }

    @Nullable
    public Triggerable getTriggerable() {
        switch (this.type) {
            case CHAIN: {
                return ((ImmutablePlanCacheService)ComponentAccessor.IMMUTABLE_PLAN_CACHE_SERVICE.get()).getImmutablePlanByKey(this.planKey);
            }
            case ENVIRONMENT: {
                return ((EnvironmentService)ComponentAccessor.ENVIRONMENT_SERVICE.get()).getEnvironment(this.environmentId.longValue());
            }
        }
        throw new IllegalStateException("neither chain nor environment... It can't be");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TriggerableInternalKeyImpl)) {
            return false;
        }
        TriggerableInternalKeyImpl that = (TriggerableInternalKeyImpl)o;
        return Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.environmentId, (Object)that.environmentId) && Objects.equal((Object)this.planKey, (Object)that.planKey) && Objects.equal((Object)this.stageId, (Object)that.stageId);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.planKey != null ? this.planKey.hashCode() : 0);
        result = 31 * result + (this.environmentId != null ? this.environmentId.hashCode() : 0);
        result = 31 * result + (this.stageId != null ? this.stageId.hashCode() : 0);
        return result;
    }

    private static enum Type {
        CHAIN,
        ENVIRONMENT,
        STAGE;

    }
}

