/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsStateImpl;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="VCS_SPECS_SOURCE")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class VcsBambooSpecsSourceImpl
implements VcsBambooSpecsSource {
    @Id
    @Column(name="VCS_SPECS_SOURCE_ID")
    @GeneratedValue(generator="ImportAwareGenerator")
    private Long id;
    @JoinColumn(name="VCS_SPECS_STATE_ID", nullable=false)
    @Fetch(value=FetchMode.JOIN)
    @ManyToOne(optional=false, cascade={CascadeType.ALL})
    @OnDelete(action=OnDeleteAction.CASCADE)
    private VcsLocationBambooSpecsStateImpl vcsLocationBambooSpecsState;
    @Column(name="VCS_SOURCE_LOCATION")
    private String sourceLocation;

    public VcsBambooSpecsSourceImpl() {
    }

    public VcsBambooSpecsSourceImpl(@NotNull VcsLocationBambooSpecsStateImpl vcsLocationBambooSpecsStateImpl, String sourceLocation) {
        Preconditions.checkNotNull((Object)vcsLocationBambooSpecsStateImpl);
        this.vcsLocationBambooSpecsState = vcsLocationBambooSpecsStateImpl;
        this.sourceLocation = sourceLocation;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @NotNull
    public VcsLocationBambooSpecsState getVcsLocationBambooSpecsState() {
        return this.vcsLocationBambooSpecsState;
    }

    public void setVcsLocationBambooSpecsState(VcsLocationBambooSpecsStateImpl vcsLocationBambooSpecsState) {
        this.vcsLocationBambooSpecsState = vcsLocationBambooSpecsState;
    }

    @NotNull
    public Optional<String> getSourceLocation() {
        return Optional.ofNullable(this.sourceLocation);
    }

    public void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public boolean isYamlConfiguration() {
        return StringUtils.isNotBlank((CharSequence)this.sourceLocation);
    }

    public static VcsBambooSpecsSourceImpl javaSpecsSource(@NotNull VcsLocationBambooSpecsStateImpl vcsLocationBambooSpecsState) {
        return new VcsBambooSpecsSourceImpl(vcsLocationBambooSpecsState, null);
    }

    public static VcsBambooSpecsSourceImpl yamlSpecsSource(@NotNull VcsLocationBambooSpecsStateImpl vcsLocationBambooSpecsState, String sourceFilename) {
        return new VcsBambooSpecsSourceImpl(vcsLocationBambooSpecsState, sourceFilename);
    }
}

