/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="VCS_SPECS_STATE", indexes={@Index(columnList="VCS_LOCATION_ID", name="VSS_VCS_LOCATION_ID_IDX")})
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class VcsLocationBambooSpecsStateImpl
implements VcsLocationBambooSpecsState {
    @Id
    @Column(name="VCS_SPECS_STATE_ID")
    @GeneratedValue(generator="ImportAwareGenerator")
    private Long id;
    @Column(name="VCS_LOCATION_ID")
    private long vcsLocationId;
    @Column(name="BRANCH", nullable=false)
    private String branch;
    @Column(name="REVISION", nullable=false, length=80)
    private String revision;
    @Column(name="SPECS_EXECUTION_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date specsExecutionDate;
    @Column(name="LOG_FILENAME")
    private String logFilename;
    @Column(name="IMPORT_STATE")
    @Enumerated(value=EnumType.STRING)
    private VcsLocationBambooSpecsState.SpecsImportState specsImportState;

    public VcsLocationBambooSpecsStateImpl() {
    }

    public VcsLocationBambooSpecsStateImpl(long vcsLocationId, String branch, String revision) {
        this.vcsLocationId = vcsLocationId;
        this.branch = branch;
        this.revision = revision;
        this.specsExecutionDate = new Date();
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String specsRevInRepo) {
        this.revision = specsRevInRepo;
    }

    public long getVcsLocationId() {
        return this.vcsLocationId;
    }

    public void setVcsLocationId(long vcsLocationId) {
        this.vcsLocationId = vcsLocationId;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public Date getSpecsExecutionDate() {
        return this.specsExecutionDate;
    }

    public String getLogFilename() {
        return this.logFilename;
    }

    public VcsLocationBambooSpecsState.SpecsImportState getSpecImportState() {
        return this.specsImportState;
    }

    public void setSpecsExecutionDate(Date specsExecutionDate) {
        this.specsExecutionDate = specsExecutionDate;
    }

    public void setLogFilename(String logFilename) {
        this.logFilename = logFilename;
    }

    public void setSpecsImportState(VcsLocationBambooSpecsState.SpecsImportState specsImportState) {
        this.specsImportState = specsImportState;
    }

    public void updateDataAfterSpecImport(String logFilename, VcsLocationBambooSpecsState.SpecsImportState specsImportState) {
        this.specsExecutionDate = new Date();
        this.logFilename = logFilename;
        this.specsImportState = specsImportState;
    }
}

