/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResult;
import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.plan.artifact.ArtifactContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResult;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.security.SecureToken;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ArtifactContextImpl
implements ArtifactContext {
    private static final Logger log = Logger.getLogger(ArtifactContextImpl.class);
    private SecureToken secureToken;
    private final FinalArrayList<ArtifactDefinitionContext> definitionContexts;
    private final FinalArrayList<ArtifactSubscriptionContext> subscriptionContexts;
    private final FinalHashMap<String, String> artifactHandlerConfiguration;
    private final Long artifactSizeQuota;
    private final FinalArrayList<ArtifactPublishingResult> publishingResults;
    private ArrayListMultimap<String, Artifact> availableArtifacts = ArrayListMultimap.create();

    public ArtifactContextImpl(SecureToken secureToken, @NotNull Collection<ArtifactDefinitionContext> definitionContexts, @NotNull Collection<ArtifactSubscriptionContext> subscriptionContexts, Optional<Long> artifactSizeQuota, @NotNull Map<String, String> artifactHandlerConfiguration) {
        this.secureToken = secureToken;
        this.definitionContexts = new FinalArrayList(definitionContexts);
        this.subscriptionContexts = new FinalArrayList(subscriptionContexts);
        this.artifactHandlerConfiguration = new FinalHashMap(artifactHandlerConfiguration);
        this.artifactSizeQuota = artifactSizeQuota.orElse(null);
        this.publishingResults = new FinalArrayList();
    }

    @NotNull
    public Collection<ArtifactDefinitionContext> getDefinitionContexts() {
        return this.definitionContexts;
    }

    @NotNull
    public Map<ArtifactDefinitionContext, Set<String>> getSuccessfulPublishers() {
        HashMap<ArtifactDefinitionContext, Set<String>> successfulPublishers = new HashMap<ArtifactDefinitionContext, Set<String>>();
        for (ArtifactPublishingResult result : this.publishingResults) {
            HashSet<String> successfulPublishersOfArtifact = new HashSet<String>();
            for (ArtifactHandlerPublishingResult publishingResult : result.getSuccessfulPublishingResults()) {
                successfulPublishersOfArtifact.add(publishingResult.getArtifactHandlerKey());
            }
            successfulPublishers.put(result.getArtifactDefinitionContext(), successfulPublishersOfArtifact);
        }
        return successfulPublishers;
    }

    @NotNull
    public Collection<ArtifactPublishingResult> getPublishingResults() {
        return this.publishingResults;
    }

    @NotNull
    public Collection<ArtifactSubscriptionContext> getSubscriptionContexts() {
        return this.subscriptionContexts;
    }

    @NotNull
    public Map<String, String> getArtifactHandlerConfiguration() {
        return this.artifactHandlerConfiguration;
    }

    @NotNull
    public Option<Long> getArtifactSizeQuota() {
        return Option.option((Object)this.artifactSizeQuota);
    }

    public void addPublishingResult(ArtifactPublishingResult publishingResult) {
        this.publishingResults.add((Object)publishingResult);
    }

    @NotNull
    public Multimap<String, Artifact> getSharedArtifactsFromPreviousStages() {
        return this.availableArtifacts;
    }

    public void setSharedArtifactsFromPreviousStages(@NotNull Multimap<String, Artifact> artifactsFromPreviousStages) {
        this.availableArtifacts = ArrayListMultimap.create(artifactsFromPreviousStages);
    }

    @NotNull
    public SecureToken getSecureToken() {
        return this.secureToken;
    }
}

