/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinition;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.variable.CustomVariableContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactDefinitionContextImpl
implements ArtifactDefinitionContext {
    private static final Logger log = Logger.getLogger(ArtifactDefinitionContextImpl.class);
    private long id = -1L;
    private BambooEntityOid oid;
    private String name;
    private String copyPattern;
    private String location;
    private boolean sharedArtifact;
    private boolean required;
    private boolean hasSubscribers;
    @Nullable
    private final SecureToken secureToken;

    public ArtifactDefinitionContextImpl(String name, boolean sharedArtifact, @Nullable SecureToken secureToken) {
        this.name = name;
        this.sharedArtifact = sharedArtifact;
        this.secureToken = secureToken;
    }

    public ArtifactDefinitionContextImpl(@NotNull ImmutableArtifactDefinition definition, @Nullable SecureToken secureToken) {
        this.id = definition.getId();
        this.oid = definition.getOid();
        this.name = definition.getName();
        this.copyPattern = definition.getCopyPattern();
        this.location = definition.getLocation();
        this.sharedArtifact = definition.isSharedArtifact();
        this.required = definition.isRequired();
        this.hasSubscribers = !definition.getSubscriptions().isEmpty();
        this.secureToken = secureToken;
    }

    public BambooEntityOid getOid() {
        return this.oid;
    }

    @Nullable
    public SecureToken getSecureToken() {
        return this.secureToken;
    }

    public void substituteVariables(CustomVariableContext customVariableContext) {
        this.name = customVariableContext.substituteString(this.name);
        this.copyPattern = customVariableContext.substituteString(this.copyPattern);
        this.location = customVariableContext.substituteString(this.location);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(@Nullable String location) {
        this.location = location;
    }

    @NotNull
    public String getCopyPattern() {
        return this.copyPattern;
    }

    public void setCopyPattern(@NotNull String copyPattern) {
        this.copyPattern = copyPattern;
    }

    public boolean isSharedArtifact() {
        return this.sharedArtifact;
    }

    public void setSharedArtifact(boolean sharedArtifact) {
        this.sharedArtifact = sharedArtifact;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean requiredArtifact) {
        this.required = requiredArtifact;
    }

    public boolean hasSubscribers() {
        return this.hasSubscribers;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String toString() {
        String artifactName = (this.required ? "Required " : "Non required ") + (this.sharedArtifact ? "shared artifact" : "job artifact") + ": [" + this.name + "], pattern: [" + this.copyPattern + "]";
        return StringUtils.isEmpty((CharSequence)this.location) ? artifactName : artifactName + " anchored at: [" + this.location + "]";
    }
}

