/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.build.DefaultJob;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.deployments.projects.DeploymentProjectItem;
import com.atlassian.bamboo.deployments.projects.persistence.items.MutableBambooArtifactDeploymentProjectItem;
import com.atlassian.bamboo.hibernate.HibernateBambooEntityWithOid;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionImpl;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NamedQueries(value={@NamedQuery(name="findArtifactDefinitionByNameInChain", query="SELECT a      FROM com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl a,           com.atlassian.bamboo.build.DefaultJob j,           com.atlassian.bamboo.chains.ChainStageImpl s     WHERE a.sharedArtifact = :sharedArtifact       AND a.name = :name       AND a.producerJob = j       AND j.stage = s       AND s.chain.id = :chainId"), @NamedQuery(name="findArtifactDefinitionByChain", query="SELECT a      FROM com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl a,           com.atlassian.bamboo.build.DefaultJob j,           com.atlassian.bamboo.chains.ChainStageImpl s     WHERE a.sharedArtifact = :sharedArtifact       AND a.producerJob = j       AND j.stage = s       AND s.chain.id = :chainId")})
@Entity
@Table(name="ARTIFACT_DEFINITION")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@AttributeOverride(name="id", column=@Column(name="ARTIFACT_DEFINITION_ID"))
public class ArtifactDefinitionImpl
extends HibernateBambooEntityWithOid
implements ArtifactDefinition {
    private static final Logger log = Logger.getLogger(ArtifactDefinitionImpl.class);
    @Column(name="LABEL", nullable=false)
    private String name;
    @Column(name="SRC_DIRECTORY")
    private String location;
    @Column(name="COPY_PATTERN", nullable=false)
    private String copyPattern;
    @Column(name="CHAIN_ARTIFACT", nullable=false)
    private boolean sharedArtifact;
    @Column(name="REQUIRED_ARTIFACT", nullable=false)
    @ColumnDefault(value="false")
    private boolean required;
    @JoinColumn(name="PRODUCER_JOB_ID", nullable=false)
    @Fetch(value=FetchMode.SELECT)
    @ManyToOne(targetEntity=DefaultJob.class)
    private Job producerJob;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="artifactDefinition", targetEntity=ArtifactSubscriptionImpl.class)
    @Fetch(value=FetchMode.SELECT)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private List<ArtifactSubscription> subscriptions = new ArrayList<ArtifactSubscription>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="artifactDefinition", targetEntity=MutableBambooArtifactDeploymentProjectItem.class)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private List<DeploymentProjectItem> deploymentProjectItems = new ArrayList<DeploymentProjectItem>();

    public ArtifactDefinitionImpl() {
    }

    public ArtifactDefinitionImpl(String name, String location, String copyPattern) {
        this.name = name;
        this.location = location;
        this.copyPattern = copyPattern;
    }

    public ArtifactDefinitionImpl(Job producerJob, String name, String location, String copyPattern) {
        this.producerJob = producerJob;
        this.name = name;
        this.location = location;
        this.copyPattern = copyPattern;
    }

    public ArtifactDefinitionImpl(ArtifactDefinition sourceArtifact, Job newProducerJob, boolean sharedArtifact, boolean required) {
        this.copyPattern = sourceArtifact.getCopyPattern();
        this.name = sourceArtifact.getName();
        this.location = sourceArtifact.getLocation();
        this.sharedArtifact = sharedArtifact;
        this.required = required;
        this.producerJob = newProducerJob;
    }

    @NotNull
    public String getCopyPattern() {
        return this.copyPattern;
    }

    public void setCopyPattern(@NotNull String copyPattern) {
        this.copyPattern = copyPattern;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(@Nullable String location) {
        this.location = location;
    }

    public boolean isSharedArtifact() {
        return this.sharedArtifact;
    }

    public void setSharedArtifact(boolean sharedArtifact) {
        this.sharedArtifact = sharedArtifact;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean requiredArtifact) {
        this.required = requiredArtifact;
    }

    @NotNull
    public Job getProducerJob() {
        return this.producerJob;
    }

    public void setProducerJob(@NotNull Job producerJob) {
        this.producerJob = producerJob;
    }

    @NotNull
    public List<ArtifactSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(@NotNull List<ArtifactSubscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    private List<DeploymentProjectItem> getDeploymentProjectItems() {
        return this.deploymentProjectItems;
    }

    private void setDeploymentProjectItems(List<DeploymentProjectItem> deploymentProjectItems) {
        this.deploymentProjectItems = deploymentProjectItems;
    }
}

