/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.event.artifact.PlanArtifactDefinitionAddedEvent;
import com.atlassian.bamboo.event.artifact.PlanArtifactDefinitionUpdatedEvent;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanComparators;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionBase;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionDao;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactDefinitionManagerImpl
implements ArtifactDefinitionManager {
    private final ArtifactDefinitionDao artifactDefinitionDao;
    private final EventPublisher eventPublisher;

    public ArtifactDefinitionManagerImpl(ArtifactDefinitionDao artifactDefinitionDao, EventPublisher eventPublisher) {
        this.artifactDefinitionDao = artifactDefinitionDao;
        this.eventPublisher = eventPublisher;
    }

    @Nullable
    public ArtifactDefinition findArtifactDefinition(long id) {
        return this.artifactDefinitionDao.findById(id);
    }

    @Nullable
    public ArtifactDefinition findArtifactDefinition(@NotNull ImmutablePlan plan, @NotNull String label) {
        return this.artifactDefinitionDao.findByName(plan, label);
    }

    @Nullable
    public ArtifactDefinition findArtifactDefinitionByChain(@NotNull ImmutablePlan plan, @NotNull String label) {
        ImmutableChain chain = (ImmutableChain)Narrow.to((Object)plan, ImmutableChain.class);
        if (chain == null) {
            return null;
        }
        return this.artifactDefinitionDao.findByNameInChain(chain, label);
    }

    @NotNull
    public List<ArtifactDefinition> findArtifactDefinitionsByPlan(@NotNull ImmutablePlan plan) {
        return this.artifactDefinitionDao.findByProducer(plan);
    }

    @NotNull
    public List<ArtifactDefinition> findSharedArtifactsByChain(@NotNull ImmutableChain chain) {
        return this.artifactDefinitionDao.findSharedArtifactsByChain(PlanHelper.getMasterPlan(chain));
    }

    public void removeArtifactDefinition(@NotNull ArtifactDefinition artifactDefinition) {
        this.artifactDefinitionDao.delete((BambooObject)artifactDefinition);
    }

    public void removeArtifactDefinitionsByPlan(@NotNull Plan plan) {
        this.artifactDefinitionDao.removeByProducer((ImmutablePlan)plan);
    }

    public void removeArtifactDefinitionsByPlan(@NotNull ImmutablePlan plan) {
        this.artifactDefinitionDao.removeByProducer(plan);
    }

    public void saveArtifactDefinition(@NotNull ArtifactDefinition artifactDefinition) {
        PlanKey chainKey = artifactDefinition.getProducerJob().getParent().getPlanKey();
        boolean newArtifact = artifactDefinition.getId() <= 0L;
        this.artifactDefinitionDao.save((BambooObject)artifactDefinition);
        this.eventPublisher.publish((Object)(newArtifact ? new PlanArtifactDefinitionAddedEvent(this, chainKey, artifactDefinition) : new PlanArtifactDefinitionUpdatedEvent(this, chainKey, artifactDefinition)));
    }

    public void saveArtifactDefinitions(@NotNull Collection<ArtifactDefinition> artifactDefinitions) {
        this.artifactDefinitionDao.saveAll(artifactDefinitions);
        for (ArtifactDefinition artifactDefinition : artifactDefinitions) {
            PlanKey chainKey = artifactDefinition.getProducerJob().getParent().getPlanKey();
            this.eventPublisher.publish((Object)new PlanArtifactDefinitionAddedEvent(this, chainKey, artifactDefinition));
        }
    }

    @NotNull
    public Map<ArtifactDefinition, ArtifactDefinition> cloneArtifactDefinitions(@NotNull Job sourcePlan, @NotNull Job targetPlan) {
        return this.cloneArtifactDefinitions(sourcePlan, targetPlan, true);
    }

    @NotNull
    public Map<ArtifactDefinition, ArtifactDefinition> cloneArtifactDefinitions(@NotNull Job sourcePlan, @NotNull Job targetPlan, boolean preserveSharedFlag) {
        LinkedHashMap<ArtifactDefinition, ArtifactDefinition> clonedArtifacts = new LinkedHashMap<ArtifactDefinition, ArtifactDefinition>();
        for (ArtifactDefinition artifactDefinition : this.findArtifactDefinitionsByPlan((ImmutablePlan)sourcePlan)) {
            clonedArtifacts.put(artifactDefinition, new ArtifactDefinitionImpl(artifactDefinition, targetPlan, preserveSharedFlag && artifactDefinition.isSharedArtifact(), artifactDefinition.isRequired()));
        }
        return clonedArtifacts;
    }

    public boolean isArtifactDefinitionNameUniqueInChain(@NotNull ArtifactDefinition artifactDefinition) {
        Job producerJob;
        if (artifactDefinition.isSharedArtifact() && (producerJob = (Job)Narrow.to((Object)artifactDefinition.getProducerJob(), Job.class)) != null) {
            ArtifactDefinition duplicate = this.artifactDefinitionDao.findByNameInChain((ImmutableChain)producerJob.getParent(), artifactDefinition.getName());
            return duplicate == null || duplicate.getId() == artifactDefinition.getId();
        }
        return true;
    }

    public boolean isArtifactDefinitionNameUniqueInJob(@NotNull ArtifactDefinition artifactDefinition) {
        ArtifactDefinition duplicate = this.artifactDefinitionDao.findByName((ImmutablePlan)artifactDefinition.getProducerJob(), artifactDefinition.getName());
        return duplicate == null || duplicate.getId() == artifactDefinition.getId();
    }

    @NotNull
    public Multimap<? extends ImmutableJob, ArtifactDefinition> getArtifactDefinitionsByJob(@NotNull ImmutableChain chain, Predicate<ArtifactDefinitionBase> predicate) {
        Ordering ordering = Ordering.from(PlanComparators.jobStageIndexComparator()).compound(Comparators.getNameProviderCaseInsensitiveOrdering());
        List jobs = ordering.sortedCopy((Iterable)chain.getAllJobs());
        TreeMultimap artifacts = TreeMultimap.create((Comparator)Ordering.explicit((List)jobs), Comparators.getNameProviderCaseInsensitiveOrdering());
        for (ImmutableJob job : jobs) {
            artifacts.putAll((Object)job, Iterables.filter(this.findArtifactDefinitionsByPlan((ImmutablePlan)job), predicate));
        }
        return artifacts;
    }
}

