/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResult;
import com.atlassian.bamboo.collections.message.FinalHashSet;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResult;
import com.atlassian.bamboo.util.BambooCollectionUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ArtifactPublishingResultImpl
implements ArtifactPublishingResult {
    private final boolean isSuccessful;
    private final FinalHashSet<ArtifactHandlerPublishingResult> successfulPublishers;
    private final FinalHashSet<ArtifactHandlerPublishingResult> failedPublishers;
    private final ArtifactDefinitionContext artifact;
    private final String failureReason;

    private ArtifactPublishingResultImpl(boolean isSuccessful, ArtifactDefinitionContext artifact, Set<ArtifactHandlerPublishingResult> successfulPublishers, Set<ArtifactHandlerPublishingResult> failedPublishers, String failureReason) {
        this.isSuccessful = isSuccessful;
        this.successfulPublishers = new FinalHashSet(successfulPublishers);
        this.failedPublishers = new FinalHashSet(failedPublishers);
        this.artifact = artifact;
        this.failureReason = failureReason;
    }

    @NotNull
    public Set<ArtifactHandlerPublishingResult> getSuccessfulPublishingResults() {
        return this.successfulPublishers;
    }

    public boolean shouldContinueBuild() {
        return this.isSuccessful || !this.artifact.hasSubscribers() && !this.artifact.isRequired();
    }

    public ArtifactDefinitionContext getArtifactDefinitionContext() {
        return this.artifact;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public Set<ArtifactHandlerPublishingResult> getFailedPublishingResults() {
        return this.failedPublishers;
    }

    public static ArtifactPublishingResultImpl failure(ArtifactDefinitionContext artifact, String failureReason, Set<ArtifactHandlerPublishingResult> successfulPublishers, Set<ArtifactHandlerPublishingResult> failedPublishers) {
        return new ArtifactPublishingResultImpl(false, artifact, BambooCollectionUtils.nullToEmptyImmutable(successfulPublishers), BambooCollectionUtils.nullToEmptyImmutable(failedPublishers), failureReason);
    }

    public static ArtifactPublishingResult success(ArtifactDefinitionContext artifact, Set<ArtifactHandlerPublishingResult> successfulPublishers) {
        return new ArtifactPublishingResultImpl(true, artifact, successfulPublishers, Collections.emptySet(), null);
    }
}

