/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.variable.CustomVariableContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactSubscriptionContextImpl
implements ArtifactSubscriptionContext {
    private static final Logger log = Logger.getLogger(ArtifactSubscriptionContextImpl.class);
    private final ArtifactDefinitionContext artifactDefinitionContext;
    private String destinationPath;
    private String variableName;
    private final SecureToken token;
    private boolean singleFile;
    private String effectiveDestinationPath;

    public ArtifactSubscriptionContextImpl(@NotNull ArtifactDefinitionContext artifactDefinitionContext, @Nullable String destinationPath, @NotNull SecureToken token, @NotNull String variableName) {
        this.artifactDefinitionContext = artifactDefinitionContext;
        this.destinationPath = destinationPath;
        this.token = token;
        this.variableName = variableName;
    }

    public void substituteVariables(@NotNull CustomVariableContext customVariableContext) {
        this.artifactDefinitionContext.substituteVariables(customVariableContext);
        this.destinationPath = customVariableContext.substituteString(this.destinationPath);
        this.variableName = customVariableContext.substituteString(this.variableName);
    }

    public ArtifactDefinitionContext getArtifactDefinitionContext() {
        return this.artifactDefinitionContext;
    }

    @NotNull
    public String getDestinationPath() {
        return StringUtils.defaultString((String)this.destinationPath, (String)"");
    }

    @NotNull
    public SecureToken getToken() {
        return this.token;
    }

    @NotNull
    public String getVariableName() {
        return this.variableName;
    }

    public boolean isSingleFile() {
        return this.singleFile;
    }

    public void setSingleFile(boolean singleFile) {
        this.singleFile = singleFile;
    }

    @NotNull
    public String getEffectiveDestinationPath() {
        return this.effectiveDestinationPath;
    }

    public void setEffectiveDestinationPath(@NotNull String effectiveDestinationPath) {
        this.effectiveDestinationPath = effectiveDestinationPath;
    }

    public String toString() {
        return "Subscription for " + this.artifactDefinitionContext.toString() + ", destination: [" + this.destinationPath + "]";
    }
}

