/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.build.DefaultJob;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.hibernate.HibernateBambooEntityObject;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="ARTIFACT_SUBSCRIPTION")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@AttributeOverride(name="id", column=@Column(name="ARTIFACT_SUBSCRIPTION_ID"))
public class ArtifactSubscriptionImpl
extends HibernateBambooEntityObject
implements ArtifactSubscription {
    @JoinColumn(name="ARTIFACT_DEFINITION_ID", nullable=false, updatable=false)
    @ManyToOne(targetEntity=ArtifactDefinitionImpl.class, optional=false)
    private ArtifactDefinition artifactDefinition;
    @JoinColumn(name="CONSUMER_JOB_ID", nullable=false)
    @ManyToOne(targetEntity=DefaultJob.class)
    @Fetch(value=FetchMode.SELECT)
    private Job consumerJob;
    @Column(name="DST_DIRECTORY")
    private String destinationDirectory;

    public ArtifactSubscriptionImpl() {
    }

    public ArtifactSubscriptionImpl(ArtifactDefinition artifactDefinition, Job consumerJob, String destinationDirectory) {
        this.artifactDefinition = artifactDefinition;
        this.consumerJob = consumerJob;
        this.destinationDirectory = destinationDirectory;
    }

    @NotNull
    public ArtifactDefinition getArtifactDefinition() {
        return this.artifactDefinition;
    }

    @NotNull
    public Job getConsumerJob() {
        return this.consumerJob;
    }

    public String getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public String getName() {
        return this.artifactDefinition.getName();
    }

    public void setArtifactDefinition(@NotNull ArtifactDefinition artifactDefinition) {
        this.artifactDefinition = artifactDefinition;
    }

    public void setConsumerJob(@NotNull Job consumerJob) {
        this.consumerJob = consumerJob;
    }

    public void setDestinationDirectory(String destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
    }
}

