/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDao;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContextImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionDao;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionSubstitutionAware;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionsFunctions;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscription;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscriptionDao;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscriptionImpl;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionBase;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ArtifactSubscriptionManagerImpl
implements ArtifactSubscriptionManager {
    private static final Logger log = Logger.getLogger(ArtifactSubscriptionManagerImpl.class);
    private final ArtifactDefinitionManager artifactDefinitionManager;
    private final ArtifactSubscriptionDao artifactSubscriptionDao;
    private final ConsumedSubscriptionDao consumedSubscriptionDao;
    private final ArtifactLinkDao artifactLinkDao;
    private final ResultsSummaryManager resultsSummaryManager;

    public ArtifactSubscriptionManagerImpl(ArtifactDefinitionManager artifactDefinitionManager, ArtifactSubscriptionDao artifactSubscriptionDao, ConsumedSubscriptionDao consumedSubscriptionDao, ArtifactLinkDao artifactLinkDao, ResultsSummaryManager resultsSummaryManager) {
        this.artifactDefinitionManager = artifactDefinitionManager;
        this.artifactSubscriptionDao = artifactSubscriptionDao;
        this.consumedSubscriptionDao = consumedSubscriptionDao;
        this.artifactLinkDao = artifactLinkDao;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public ArtifactSubscription findSubscription(long id) {
        return (ArtifactSubscription)this.artifactSubscriptionDao.findById(id, ArtifactSubscriptionImpl.class);
    }

    @NotNull
    public List<ArtifactSubscription> findSubscriptionsOfPlan(@NotNull PlanIdentifier plan) {
        return this.artifactSubscriptionDao.findArtifactSubscriptionOfPlan(plan);
    }

    public List<ArtifactSubscriptionSubstitutionAware> transformSubscriptions(@NotNull List<ArtifactSubscription> subscriptions) {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy(subscriptions), ArtifactSubscriptionsFunctions.createSubscriptionSubstitutionAware()));
    }

    @NotNull
    public List<ArtifactDefinition> findSubscriptionsPossibleForPlan(@NotNull ImmutableJob job) {
        ImmutableChainStage chainStage;
        ArrayList<ArtifactDefinition> artifactDefinitions = new ArrayList<ArtifactDefinition>();
        ImmutableChain chain = job.getParent();
        Iterator iterator = chain.getStages().iterator();
        while (iterator.hasNext() && !(chainStage = (ImmutableChainStage)iterator.next()).equals(job.getStage())) {
            for (ImmutableJob sourceJob : chainStage.getJobs()) {
                Iterables.addAll(artifactDefinitions, (Iterable)Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy(Iterables.filter((Iterable)this.artifactDefinitionManager.findArtifactDefinitionsByPlan((ImmutablePlan)sourceJob), ImmutableArtifactDefinitionBase::isSharedArtifact)));
            }
        }
        return artifactDefinitions;
    }

    @NotNull
    public List<ArtifactSubscription> findCurrentSubscriptionsForPlan(@NotNull ImmutableJob producerJob) {
        ArrayList<ArtifactSubscription> allArtifactSubscriptions = new ArrayList<ArtifactSubscription>();
        List definitions = this.artifactDefinitionManager.findArtifactDefinitionsByPlan((ImmutablePlan)producerJob);
        for (ArtifactDefinition definition : definitions) {
            allArtifactSubscriptions.addAll(definition.getSubscriptions());
        }
        return allArtifactSubscriptions;
    }

    @NotNull
    public List<ArtifactSubscription> validateSubscribersForMovedJob(@NotNull ImmutableJob producer, @NotNull ImmutableChainStage destinationStage) {
        ArrayList<ArtifactSubscription> invalidSubscriptions = new ArrayList<ArtifactSubscription>();
        List definitions = this.artifactDefinitionManager.findArtifactDefinitionsByPlan((ImmutablePlan)producer);
        for (ArtifactDefinition definition : definitions) {
            for (ArtifactSubscription subscription : definition.getSubscriptions()) {
                if (this.isProducerBeforeConsumer(producer.getParent(), destinationStage.getName(), subscription.getConsumerJob().getStage().getName())) continue;
                invalidSubscriptions.add(subscription);
            }
        }
        return invalidSubscriptions;
    }

    @NotNull
    public List<ArtifactSubscription> validateSubscriptions(@NotNull ImmutableJob consumer, @NotNull ImmutableChain chain, @NotNull String stageName) {
        ArrayList<ArtifactSubscription> invalidSubscriptions = new ArrayList<ArtifactSubscription>();
        List<ArtifactSubscription> subscriptions = this.findSubscriptionsOfPlan((PlanIdentifier)consumer);
        if (!consumer.getParent().equals(chain)) {
            return subscriptions;
        }
        for (ArtifactSubscription subscription : subscriptions) {
            Job producer = subscription.getArtifactDefinition().getProducerJob();
            String producerStageName = producer.getStage().getName();
            if (this.isProducerBeforeConsumer(chain, producerStageName, stageName)) continue;
            invalidSubscriptions.add(subscription);
        }
        return invalidSubscriptions;
    }

    @NotNull
    public List<ArtifactSubscription> validateSubscriptionsForMovedJob(@NotNull ImmutableJob job, @NotNull ImmutableChainStage targetStage) {
        ImmutableChain chain = job.getParent();
        List allStages = chain.getAllStages();
        boolean movingUp = allStages.indexOf(job.getStage()) > allStages.indexOf(targetStage);
        return movingUp ? this.validateSubscriptions(job, chain, targetStage.getName()) : this.validateSubscribersForMovedJob(job, targetStage);
    }

    @NotNull
    public List<ArtifactSubscription> validateSubscriptionsForMovedStage(@NotNull ImmutableChainStage stageToMove, int newIndex) {
        boolean movingUp = stageToMove.getChain().getAllStages().indexOf(stageToMove) > newIndex;
        ArrayList<ImmutableChainStage> reorderedStages = new ArrayList<ImmutableChainStage>(stageToMove.getChain().getStages());
        reorderedStages.remove(stageToMove);
        reorderedStages.add(Math.min(reorderedStages.size(), newIndex), stageToMove);
        ArrayList<ArtifactSubscription> artifactDefinitions = new ArrayList<ArtifactSubscription>();
        for (ImmutableJob job : stageToMove.getJobs()) {
            if (movingUp) {
                artifactDefinitions.addAll(this.findSubscriptionsOfPlan((PlanIdentifier)job));
                continue;
            }
            for (ArtifactDefinition artifactDefinition : this.artifactDefinitionManager.findArtifactDefinitionsByPlan((ImmutablePlan)job)) {
                artifactDefinitions.addAll(artifactDefinition.getSubscriptions());
            }
        }
        ArrayList<ArtifactSubscription> affectedArtifacts = new ArrayList<ArtifactSubscription>();
        for (ArtifactSubscription subscription : artifactDefinitions) {
            if (!this.isAffectedArtifactSubscription(reorderedStages, subscription)) continue;
            affectedArtifacts.add(subscription);
        }
        return affectedArtifacts;
    }

    private boolean isAffectedArtifactSubscription(List<ImmutableChainStage> stages, ArtifactSubscription subscription) {
        boolean isAffectedArtifactSubscriptions = false;
        ChainStage producerStage = subscription.getArtifactDefinition().getProducerJob().getStage();
        ChainStage consumerStage = subscription.getConsumerJob().getStage();
        boolean consumerFound = false;
        for (ImmutableChainStage stage : stages) {
            if (stage.getId() == consumerStage.getId()) {
                consumerFound = true;
            }
            if (stage.getId() != producerStage.getId() || !consumerFound) continue;
            isAffectedArtifactSubscriptions = true;
            break;
        }
        return isAffectedArtifactSubscriptions;
    }

    public boolean isSubscriptionsValid(@NotNull Job consumer, @NotNull Chain chain, @NotNull String stageName) {
        return this.validateSubscriptions((ImmutableJob)consumer, (ImmutableChain)chain, stageName).isEmpty();
    }

    @NotNull
    public List<ArtifactSubscriptionContext> prepareSubscriptionContexts(@NotNull ImmutableJob job, @NotNull BuildContext parentBuildContext, SecureToken secureToken) {
        return job.getArtifactSubscriptions().stream().sorted(Comparators.getNameProviderCaseInsensitiveOrdering()).map(ArtifactSubscriptionsFunctions.createSubscriptionContextFromArtifactSubscription(secureToken)).collect(Collectors.toList());
    }

    @NotNull
    public List<ArtifactDefinitionContext> prepareArtifactDefinitionContexts(@NotNull ImmutableJob job, @NotNull BuildContext buildContext, SecureToken secureToken) {
        return job.getArtifactDefinitions().stream().map(input -> new ArtifactDefinitionContextImpl((ImmutableArtifactDefinition)input, secureToken)).collect(Collectors.toList());
    }

    public void removeArtifactSubscription(@NotNull ArtifactSubscription artifactSubscription) {
        artifactSubscription.getArtifactDefinition().getSubscriptions().remove(artifactSubscription);
        this.artifactSubscriptionDao.delete((BambooObject)artifactSubscription);
    }

    public void removeArtifactSubscriptions(@NotNull Collection<ArtifactSubscription> artifactSubscriptions) {
        for (ArtifactSubscription artifactSubscription : artifactSubscriptions) {
            artifactSubscription.getArtifactDefinition().getSubscriptions().remove(artifactSubscription);
        }
        this.artifactSubscriptionDao.deleteAll(artifactSubscriptions);
    }

    public void removeArtifactSubscriptionsOfPlan(@NotNull Plan plan) {
        this.removeArtifactSubscriptions(this.findSubscriptionsOfPlan((PlanIdentifier)plan));
    }

    public void removeArtifactSubscriptionsOfPlan(@NotNull ImmutablePlan plan) {
        this.removeArtifactSubscriptions(this.findSubscriptionsOfPlan((PlanIdentifier)plan));
    }

    public void saveArtifactSubscription(@NotNull ArtifactSubscription artifactSubscription) {
        this.artifactSubscriptionDao.save((BambooObject)artifactSubscription);
    }

    public void saveArtifactSubscriptions(@NotNull Collection<ArtifactSubscription> artifactSubscriptions) {
        this.artifactSubscriptionDao.saveAll(artifactSubscriptions);
    }

    public void saveConsumedSubscription(@NotNull ArtifactSubscriptionContext artifactSubscription, @NotNull PlanResultKey planResultKey, @NotNull String artifactLinkType) {
        ChainResultsSummary chainSummary;
        BuildResultsSummary consumerSummary = (BuildResultsSummary)this.resultsSummaryManager.getResultsSummary(planResultKey, BuildResultsSummary.class);
        ChainResultsSummary chainResultsSummary = chainSummary = consumerSummary != null ? consumerSummary.getChainResultsSummary() : null;
        if (chainSummary != null) {
            Collection artifactLinks = this.artifactLinkDao.findArtifactLinks(artifactSubscription.getArtifactDefinitionContext().getName(), (ResultsSummary)chainSummary);
            for (ArtifactLink artifactLink : artifactLinks) {
                if (!artifactLink.getLinkType().equals(artifactLinkType)) continue;
                ConsumedSubscriptionImpl consumedSubscription = new ConsumedSubscriptionImpl(artifactLink, (ResultsSummary)consumerSummary, artifactSubscription.getDestinationPath());
                this.consumedSubscriptionDao.save((BambooObject)consumedSubscription);
                break;
            }
        }
    }

    @NotNull
    public Multimap<ResultsSummary, ConsumedSubscription> getConsumedSubscriptions(@NotNull ResultsSummary resultsSummary) {
        ChainResultsSummary chainResultsSummary;
        PlanKey chainKey;
        PlanResultKey chainResultKey;
        ResultsSummary parentResultSummary;
        if (resultsSummary instanceof BuildResultsSummary && (parentResultSummary = this.resultsSummaryManager.getResultsSummary(chainResultKey = PlanKeys.getPlanResultKey((PlanKey)(chainKey = PlanKeys.getChainKeyFromJobKey((PlanKey)resultsSummary.getPlanKey())), (int)resultsSummary.getBuildNumber()))) != null && (chainResultsSummary = (ChainResultsSummary)Narrow.to((Object)parentResultSummary, ChainResultsSummary.class)) != null) {
            List results = chainResultsSummary.getOrderedJobResultSummaries();
            TreeMultimap subscriptions = TreeMultimap.create((Comparator)Ordering.explicit((List)results).nullsLast(), Comparators.getNameProviderCaseInsensitiveOrdering());
            for (ConsumedSubscription subscription : this.consumedSubscriptionDao.findConsumedSubscriptionsByResultSummary(resultsSummary)) {
                subscriptions.put((Object)subscription.getArtifactLink().getProducerJobResult(), (Object)subscription);
            }
            return subscriptions;
        }
        return TreeMultimap.create((Comparator)Ordering.explicit(new ArrayList()), Comparators.getNameProviderCaseInsensitiveOrdering());
    }

    private boolean isProducerBeforeConsumer(@NotNull ImmutableChain chain, @NotNull String producerStageName, @NotNull String consumerStageName) {
        for (ImmutableChainStage chainStage : chain.getStages()) {
            if (chainStage.getName().equals(consumerStageName)) {
                return false;
            }
            if (!chainStage.getName().equals(producerStageName)) continue;
            return true;
        }
        return false;
    }
}

