/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContextImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContextImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionSubstitutionAware;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionSubstitutionAwareImpl;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactSubscriptionImpl;
import com.atlassian.bamboo.security.SecureToken;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactSubscriptionsFunctions {
    private ArtifactSubscriptionsFunctions() {
    }

    public static Job getProducerJob(ArtifactSubscription artifactSubscription) {
        return artifactSubscription.getArtifactDefinition().getProducerJob();
    }

    public static Job getConsumerJob(ArtifactSubscription artifactSubscription) {
        return artifactSubscription.getConsumerJob();
    }

    public static java.util.function.Function<ImmutableArtifactSubscription, ArtifactSubscriptionContext> createSubscriptionContextFromArtifactSubscription(final @NotNull SecureToken secureToken) {
        return new java.util.function.Function<ImmutableArtifactSubscription, ArtifactSubscriptionContext>(){
            final Map<String, Integer> usedNames = new HashMap<String, Integer>();

            @Override
            public ArtifactSubscriptionContext apply(@Nullable ImmutableArtifactSubscription input) {
                String variableName;
                String name = (input = (ImmutableArtifactSubscription)Preconditions.checkNotNull((Object)input)).getName();
                if (this.usedNames.containsKey(name)) {
                    int count = this.usedNames.get(name);
                    variableName = "bamboo.artifacts.path." + name + "_" + count;
                    this.usedNames.put(name, ++count);
                } else {
                    variableName = "bamboo.artifacts.path." + name;
                    this.usedNames.put(name, 1);
                }
                return new ArtifactSubscriptionContextImpl(new ArtifactDefinitionContextImpl(input.getArtifactDefinition(), secureToken), input.getDestinationDirectory(), secureToken, variableName);
            }
        };
    }

    public static Function<ArtifactSubscription, ArtifactSubscriptionSubstitutionAware> createSubscriptionSubstitutionAware() {
        return new Function<ArtifactSubscription, ArtifactSubscriptionSubstitutionAware>(){
            final Map<String, Integer> usedNames = new HashMap<String, Integer>();

            public ArtifactSubscriptionSubstitutionAware apply(@Nullable ArtifactSubscription input) {
                ArtifactSubscriptionSubstitutionAwareImpl result = new ArtifactSubscriptionSubstitutionAwareImpl((ArtifactSubscription)Preconditions.checkNotNull((Object)input));
                String name = result.getName();
                if (this.usedNames.containsKey(name)) {
                    int count = this.usedNames.get(name);
                    result.setVariableName("bamboo.artifacts.path." + name + "_" + count);
                    this.usedNames.put(name, ++count);
                } else {
                    result.setVariableName("bamboo.artifacts.path." + name);
                    this.usedNames.put(name, 1);
                }
                return result;
            }
        };
    }

    public static ImmutableArtifactSubscription createImmutableArtifactSubscription(ImmutableArtifactSubscription artifactSubscription) {
        return ImmutableArtifactSubscriptionImpl.builder().from(artifactSubscription).build();
    }
}

