/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactManager;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactSubscriptionListLazyReference;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ImmutableArtifactDefinitionImpl
implements ImmutableArtifactDefinition {
    private static final Logger log = Logger.getLogger(ImmutableArtifactDefinitionImpl.class);
    private final long id;
    private final BambooEntityOid oid;
    private final String name;
    private final String location;
    private final String copyPattern;
    private final boolean sharedArtifact;
    private final boolean required;
    private final PlanKey producerJobKey;
    private final ImmutableArtifactSubscriptionListLazyReference artifactSubscriptionListLazyReference;
    private final CachedPlanManager cachedPlanManager;

    private ImmutableArtifactDefinitionImpl(@NotNull CachedPlanManager cachedPlanManager, @NotNull ImmutableArtifactManager immutableArtifactManager, long id, BambooEntityOid oid, String name, String location, String copyPattern, boolean sharedArtifact, boolean required, PlanKey producerJobKey) {
        this.cachedPlanManager = cachedPlanManager;
        this.id = id;
        this.oid = oid;
        this.name = name;
        this.location = location;
        this.copyPattern = copyPattern;
        this.sharedArtifact = sharedArtifact;
        this.required = required;
        this.producerJobKey = producerJobKey;
        this.artifactSubscriptionListLazyReference = new ImmutableArtifactSubscriptionListLazyReference(immutableArtifactManager, this);
    }

    public long getId() {
        return this.id;
    }

    public BambooEntityOid getOid() {
        return this.oid;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    @NotNull
    public String getCopyPattern() {
        return this.copyPattern;
    }

    public boolean isSharedArtifact() {
        return this.sharedArtifact;
    }

    public boolean isRequired() {
        return this.required;
    }

    @NotNull
    public ImmutableJob getProducerJob() {
        return (ImmutableJob)Preconditions.checkNotNull((Object)this.cachedPlanManager.getPlanByKey(this.producerJobKey, ImmutableJob.class), (String)"Unable to retrieve job %s from cache", (Object[])new Object[]{this.producerJobKey});
    }

    @NotNull
    public ImmutableList<ImmutableArtifactSubscription> getSubscriptions() {
        return (ImmutableList)this.artifactSubscriptionListLazyReference.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long id;
        private BambooEntityOid oid;
        private String name;
        private String location;
        private String copyPattern;
        private boolean sharedArtifact;
        private boolean required;
        private PlanKey producerJobKey;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder oid(BambooEntityOid oid) {
            this.oid = oid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder copyPattern(String copyPattern) {
            this.copyPattern = copyPattern;
            return this;
        }

        public Builder sharedArtifact(boolean sharedArtifact) {
            this.sharedArtifact = sharedArtifact;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public Builder producerJob(PlanIdentifier job) {
            this.producerJobKey = job.getPlanKey();
            return this;
        }

        public Builder from(@NotNull ArtifactDefinition definition) {
            return this.id(definition.getId()).oid(definition.getOid()).name(definition.getName()).location(definition.getLocation()).copyPattern(definition.getCopyPattern()).sharedArtifact(definition.isSharedArtifact()).required(definition.isRequired()).producerJob((PlanIdentifier)definition.getProducerJob());
        }

        public ImmutableArtifactDefinitionImpl build() {
            return new ImmutableArtifactDefinitionImpl((CachedPlanManager)ComponentAccessor.CACHED_PLAN_MANAGER.get(), (ImmutableArtifactManager)ComponentAccessor.IMMUTABLE_ARTIFACT_MANAGER.get(), this.id, this.oid, this.name, this.location, this.copyPattern, this.sharedArtifact, this.required, this.producerJobKey);
        }
    }
}

