/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactManager;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ImmutableArtifactDefinitionListLazyReference
extends LazyReference<ImmutableList<ImmutableArtifactDefinition>> {
    private static final Logger log = Logger.getLogger(ImmutableArtifactDefinitionListLazyReference.class);
    private final ImmutableJob job;
    private final ImmutableArtifactManager immutableArtifactManager;

    public ImmutableArtifactDefinitionListLazyReference(@NotNull ImmutableArtifactManager immutableArtifactManager, @NotNull ImmutableJob job) {
        this.immutableArtifactManager = immutableArtifactManager;
        this.job = job;
    }

    protected ImmutableList<ImmutableArtifactDefinition> create() throws Exception {
        if (this.job.hasMaster()) {
            List artifactDefinitions = ((ImmutableJob)Preconditions.checkNotNull((Object)this.job.getMaster())).getArtifactDefinitions();
            return ImmutableList.copyOf((Collection)artifactDefinitions);
        }
        return this.immutableArtifactManager.findImmutableArtifactDefinitionsByProducer((ImmutablePlan)this.job);
    }
}

