/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionFunctions;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionsFunctions;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactManager;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactSubscription;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.collectors.CollectorsUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.jetbrains.annotations.NotNull;

public class ImmutableArtifactManagerImpl
implements ImmutableArtifactManager {
    private final ArtifactDefinitionManager artifactDefinitionManager;
    private final ArtifactSubscriptionManager artifactSubscriptionManager;

    public ImmutableArtifactManagerImpl(ArtifactDefinitionManager artifactDefinitionManager, ArtifactSubscriptionManager artifactSubscriptionManager) {
        this.artifactDefinitionManager = artifactDefinitionManager;
        this.artifactSubscriptionManager = artifactSubscriptionManager;
    }

    @NotNull
    public ImmutableList<ImmutableArtifactDefinition> findImmutableArtifactDefinitionsByProducer(@NotNull ImmutablePlan plan) {
        return (ImmutableList)this.artifactDefinitionManager.findArtifactDefinitionsByPlan(plan).stream().map(ArtifactDefinitionFunctions::createImmutableArtifactDefinition).collect(CollectorsUtil.toImmutableList());
    }

    public ImmutableArtifactDefinition createImmutableArtifactDefinition(@NotNull ImmutableArtifactSubscription artifactSubscription) {
        return ArtifactDefinitionFunctions.createImmutableArtifactDefinition(((ArtifactSubscription)Preconditions.checkNotNull((Object)this.artifactSubscriptionManager.findSubscription(artifactSubscription.getId()))).getArtifactDefinition());
    }

    @NotNull
    public ImmutableList<ImmutableArtifactSubscription> findImmutableArtifactSubscriptionsByDefinition(@NotNull ImmutableArtifactDefinition artifactDefinition) {
        return (ImmutableList)((ArtifactDefinition)Preconditions.checkNotNull((Object)this.artifactDefinitionManager.findArtifactDefinition(artifactDefinition.getId()))).getSubscriptions().stream().map(ArtifactSubscriptionsFunctions::createImmutableArtifactSubscription).collect(CollectorsUtil.toImmutableList());
    }

    @NotNull
    public ImmutableList<ImmutableArtifactSubscription> findImmutableArtifactSubscriptionsByPlan(@NotNull ImmutablePlan plan) {
        return (ImmutableList)this.artifactSubscriptionManager.findSubscriptionsOfPlan((PlanIdentifier)plan).stream().map(ArtifactSubscriptionsFunctions::createImmutableArtifactSubscription).collect(CollectorsUtil.toImmutableList());
    }
}

