/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionLazyReference;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactManager;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactSubscription;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.google.common.base.Preconditions;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ImmutableArtifactSubscriptionImpl
implements ImmutableArtifactSubscription {
    private static final Logger log = Logger.getLogger(ImmutableArtifactSubscriptionImpl.class);
    private final long id;
    private final String name;
    private final PlanKey consumerJobKey;
    private final String destinationDirectory;
    private final ImmutableArtifactDefinitionLazyReference artifactDefinitionLazyReference;
    private final CachedPlanManager cachedPlanManager;

    private ImmutableArtifactSubscriptionImpl(@NotNull CachedPlanManager cachedPlanManager, @NotNull ImmutableArtifactManager immutableArtifactManager, long id, String name, PlanKey consumerJobKey, String destinationDirectory) {
        this.cachedPlanManager = cachedPlanManager;
        this.id = id;
        this.name = name;
        this.consumerJobKey = consumerJobKey;
        this.destinationDirectory = destinationDirectory;
        this.artifactDefinitionLazyReference = new ImmutableArtifactDefinitionLazyReference(immutableArtifactManager, this);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @NotNull
    public ImmutableArtifactDefinition getArtifactDefinition() {
        return (ImmutableArtifactDefinition)this.artifactDefinitionLazyReference.get();
    }

    @NotNull
    public ImmutableJob getConsumerJob() {
        return (ImmutableJob)Preconditions.checkNotNull((Object)this.cachedPlanManager.getPlanByKey(this.consumerJobKey, ImmutableJob.class), (String)"Unable to retrieve job %s from cache", (Object[])new Object[]{this.consumerJobKey});
    }

    public String getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long id;
        private String name;
        private PlanKey consumerJobKey;
        private String destinationDirectory;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder consumerJob(PlanIdentifier job) {
            this.consumerJobKey = job.getPlanKey();
            return this;
        }

        public Builder destinationDirectory(String destinationDirectory) {
            this.destinationDirectory = destinationDirectory;
            return this;
        }

        public Builder from(@NotNull ImmutableArtifactSubscription subscription) {
            return this.id(subscription.getId()).name(subscription.getName()).consumerJob((PlanIdentifier)subscription.getConsumerJob()).destinationDirectory(subscription.getDestinationDirectory());
        }

        public ImmutableArtifactSubscriptionImpl build() {
            return new ImmutableArtifactSubscriptionImpl((CachedPlanManager)ComponentAccessor.CACHED_PLAN_MANAGER.get(), (ImmutableArtifactManager)ComponentAccessor.IMMUTABLE_ARTIFACT_MANAGER.get(), this.id, this.name, this.consumerJobKey, this.destinationDirectory);
        }
    }
}

