/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.artifact;

import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactManager;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactSubscription;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ImmutableArtifactSubscriptionListLazyReference
extends LazyReference<ImmutableList<ImmutableArtifactSubscription>> {
    private static final Logger log = Logger.getLogger(ImmutableArtifactSubscriptionListLazyReference.class);
    private final Supplier<ImmutableList<ImmutableArtifactSubscription>> artifactSubscriptionSupplier;

    public ImmutableArtifactSubscriptionListLazyReference(@NotNull ImmutableArtifactManager immutableArtifactManager, @NotNull ImmutableJob job) {
        this.artifactSubscriptionSupplier = this.fromJob(immutableArtifactManager, job);
    }

    public ImmutableArtifactSubscriptionListLazyReference(@NotNull ImmutableArtifactManager immutableArtifactManager, @NotNull ImmutableArtifactDefinition artifactDefinition) {
        this.artifactSubscriptionSupplier = this.fromArtifactDefinition(immutableArtifactManager, artifactDefinition);
    }

    protected ImmutableList<ImmutableArtifactSubscription> create() throws Exception {
        return this.artifactSubscriptionSupplier.get();
    }

    private Supplier<ImmutableList<ImmutableArtifactSubscription>> fromArtifactDefinition(final @NotNull ImmutableArtifactManager immutableArtifactManager, final @NotNull ImmutableArtifactDefinition artifactDefinition) {
        return new Supplier<ImmutableList<ImmutableArtifactSubscription>>(){

            @Override
            public ImmutableList<ImmutableArtifactSubscription> get() {
                return immutableArtifactManager.findImmutableArtifactSubscriptionsByDefinition(artifactDefinition);
            }
        };
    }

    private Supplier<ImmutableList<ImmutableArtifactSubscription>> fromJob(final @NotNull ImmutableArtifactManager immutableArtifactManager, final @NotNull ImmutableJob job) {
        return new Supplier<ImmutableList<ImmutableArtifactSubscription>>(){

            @Override
            public ImmutableList<ImmutableArtifactSubscription> get() {
                if (job.hasMaster()) {
                    return ImmutableList.copyOf((Collection)((ImmutableJob)Preconditions.checkNotNull((Object)job.getMaster())).getArtifactSubscriptions());
                }
                return immutableArtifactManager.findImmutableArtifactSubscriptionsByPlan((ImmutablePlan)job);
            }
        };
    }
}

