/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.plan.branch.BambooVcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="VCS_BRANCH")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class BambooVcsBranchImpl
extends BambooEntityObject
implements BambooVcsBranch {
    private Chain chain;
    private String name;
    private Date detectedDeletionDate;
    private long chainId;

    public BambooVcsBranchImpl() {
    }

    public BambooVcsBranchImpl(Chain chain, VcsBranch newBranch) {
        this.chain = chain;
        this.name = newBranch.getName();
    }

    public BambooVcsBranchImpl(long id, @NotNull String name) {
        this.setId(id);
        this.name = name;
    }

    public BambooVcsBranchImpl(long id, @NotNull String name, @Nullable Date detectedDeletionDate, long chainId) {
        this.setId(id);
        this.name = name;
        this.detectedDeletionDate = detectedDeletionDate;
        this.chainId = chainId;
    }

    @NotNull
    public Chain getChain() {
        return this.chain;
    }

    public void setChain(@NotNull Chain chain) {
        this.chain = chain;
    }

    public long getChainId() {
        return this.chainId;
    }

    public void setChainId(@NotNull long chainId) {
        this.chainId = chainId;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Nullable
    public Date getDetectedDeletionDate() {
        return this.detectedDeletionDate;
    }

    public void setDetectedDeletionDate(@Nullable Date detectedDeletionDate) {
        this.detectedDeletionDate = detectedDeletionDate;
    }

    public boolean isEqualToBranchWith(@NotNull String otherName) {
        return this.name.equals(otherName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BambooVcsBranchImpl that = (BambooVcsBranchImpl)((Object)o);
        if (!this.chain.equals(that.chain)) {
            return false;
        }
        if (this.detectedDeletionDate != null ? !this.detectedDeletionDate.equals(that.detectedDeletionDate) : that.detectedDeletionDate != null) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.chain.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.detectedDeletionDate != null ? this.detectedDeletionDate.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BambooVcsBranchImpl{chain=" + this.chain + ", name='" + this.name + '\'' + ", detectedDeletionDate='" + this.detectedDeletionDate + "'" + '}';
    }
}

