/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.plan.branch.BranchCommitInformation;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="BRANCH_COMMIT_INFO")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class BranchCommitInformationImpl
extends BambooEntityObject
implements BranchCommitInformation {
    private static final Logger log = Logger.getLogger(BranchCommitInformationImpl.class);
    private long chainBranchId;
    private Author creatingAuthor;
    private Author latestCommitAuthor;
    private Date creatingCommitDate;
    private Date latestCommitDate;
    private String latestCommitChangeSetId;
    private String creatingChangeSetId;

    public BranchCommitInformationImpl() {
    }

    public BranchCommitInformationImpl(long chainBranchId) {
        this.chainBranchId = chainBranchId;
    }

    public BranchCommitInformationImpl(@Nullable BranchCommitInformation other) {
        if (other != null) {
            this.setId(other.getId());
            this.copyOf(other);
        }
    }

    public Author getCreatingAuthor() {
        return this.creatingAuthor;
    }

    public Date getCreatingCommitDate() {
        return this.creatingCommitDate;
    }

    public String getCreatingChangeSetId() {
        return this.creatingChangeSetId;
    }

    public Author getLatestCommitAuthor() {
        return this.latestCommitAuthor;
    }

    public Date getLatestCommitDate() {
        return this.latestCommitDate;
    }

    public String getLatestCommitChangeSetId() {
        return this.latestCommitChangeSetId;
    }

    public void setCreatingAuthor(Author creatingAuthor) {
        this.creatingAuthor = creatingAuthor;
    }

    public void setLatestCommitAuthor(Author latestCommitAuthor) {
        this.latestCommitAuthor = latestCommitAuthor;
    }

    public void setCreatingCommitDate(Date creatingCommitDate) {
        this.creatingCommitDate = creatingCommitDate;
    }

    public void setLatestCommitDate(Date latestCommitDate) {
        this.latestCommitDate = latestCommitDate;
    }

    public void setLatestCommitChangeSetId(String latestCommitChangeSetId) {
        this.latestCommitChangeSetId = latestCommitChangeSetId;
    }

    public void setCreatingChangeSetId(String creatingChangeSetId) {
        this.creatingChangeSetId = creatingChangeSetId;
    }

    public long getChainBranchId() {
        return this.chainBranchId;
    }

    public void setChainBranchId(long chainBranchId) {
        this.chainBranchId = chainBranchId;
    }

    protected void copyOf(BranchCommitInformation other) {
        this.chainBranchId = other.getChainBranchId();
        this.creatingAuthor = other.getCreatingAuthor();
        this.creatingChangeSetId = other.getCreatingChangeSetId();
        this.creatingCommitDate = other.getCreatingCommitDate();
        this.latestCommitAuthor = other.getLatestCommitAuthor();
        this.latestCommitDate = other.getLatestCommitDate();
        this.latestCommitChangeSetId = other.getLatestCommitChangeSetId();
    }
}

