/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.author.AuthorCreatorService;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.jira.issuelink.JiraBranchLinkingService;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.branch.BranchCommitInformation;
import com.atlassian.bamboo.plan.branch.BranchCommitInformationDao;
import com.atlassian.bamboo.plan.branch.BranchCommitInformationImpl;
import com.atlassian.bamboo.plan.branch.BranchCommitInformationManager;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.VcsBranchDetector;
import com.google.common.base.Preconditions;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.Date;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BranchCommitInformationManagerImpl
implements BranchCommitInformationManager {
    private static final Logger log = Logger.getLogger(BranchCommitInformationManagerImpl.class);
    private final BranchCommitInformationDao branchCommitInformationDao;
    private final AuthorCreatorService authorCreatorService;
    private final ExtendedAuthorManager extendedAuthorManager;
    private final JiraBranchLinkingService jiraBranchLinkingService;
    private final VcsRepositoryManager vcsRepositoryManager;
    private final Function<Long, ManagedLock> branchCommitInformationLockManager = ManagedLocks.weakManagedLockFactory();

    public BranchCommitInformationManagerImpl(BranchCommitInformationDao branchCommitInformationDao, ExtendedAuthorManager extendedAuthorManager, AuthorCreatorService authorCreatorService, JiraBranchLinkingService jiraBranchLinkingService, VcsRepositoryManager vcsRepositoryManager) {
        this.branchCommitInformationDao = branchCommitInformationDao;
        this.extendedAuthorManager = extendedAuthorManager;
        this.authorCreatorService = authorCreatorService;
        this.jiraBranchLinkingService = jiraBranchLinkingService;
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    public void initialiseCommitInformation(ImmutableChainBranch branch) throws RepositoryException {
        Author author;
        PlanRepositoryDefinition planRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)branch);
        if (planRepositoryDefinition == null) {
            return;
        }
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(planRepositoryDefinition.getPluginKey());
        if (moduleDescriptor == null || !moduleDescriptor.supportsBranchDetection()) {
            return;
        }
        BranchCommitInformationImpl bci = new BranchCommitInformationImpl(branch.getId());
        VcsBranchDetector branchDetector = (VcsBranchDetector)Preconditions.checkNotNull((Object)moduleDescriptor.getBranchDetector());
        CommitContext oldCommit = branchDetector.getFirstCommitApproximation((VcsRepositoryData)planRepositoryDefinition);
        if (oldCommit != null) {
            bci = this.updateCreatingCommitInformation(bci, oldCommit);
            bci = this.updateLatestCommitInformation(bci, oldCommit);
            bci.setLatestCommitDate(new Date());
        }
        if ((author = bci.getCreatingAuthor()) != null && author.getLinkedUserName() != null) {
            this.jiraBranchLinkingService.linkBranchToIssueIfRequiredAsync(branch.getPlanKey(), author.getLinkedUserName());
        }
        this.save(bci);
    }

    public BranchCommitInformation updateCreatingCommitInformation(@NotNull BranchCommitInformation source, @NotNull CommitContext commitContext) {
        BranchCommitInformationImpl bci = new BranchCommitInformationImpl(source);
        AuthorContext author = commitContext.getAuthorContext();
        String authorName = author != null ? author.getName() : null;
        bci.setCreatingChangeSetId(commitContext.getChangeSetId());
        bci.setCreatingCommitDate(commitContext.getDate());
        if (authorName != null) {
            this.authorCreatorService.createAuthorIfMissing(author);
            bci.setCreatingAuthor((Author)this.extendedAuthorManager.getExtendedAuthorByName(authorName));
        }
        return bci;
    }

    public BranchCommitInformation updateLatestCommitInformation(@NotNull BranchCommitInformation source, @NotNull CommitContext commitContext) {
        BranchCommitInformationImpl bci = new BranchCommitInformationImpl(source);
        AuthorContext author = commitContext.getAuthorContext();
        String authorName = author != null ? author.getName() : null;
        bci.setLatestCommitChangeSetId(commitContext.getChangeSetId());
        bci.setLatestCommitDate(commitContext.getDate());
        if (authorName != null) {
            this.authorCreatorService.createAuthorIfMissing(author);
            bci.setLatestCommitAuthor((Author)this.extendedAuthorManager.getExtendedAuthorByName(authorName));
        }
        return bci;
    }

    public void save(@NotNull BranchCommitInformation branchCommitInformation) {
        this.branchCommitInformationLockManager.apply(branchCommitInformation.getChainBranchId()).withLock(() -> {
            BranchCommitInformationImpl bci = (BranchCommitInformationImpl)this.branchCommitInformationDao.findByChainBranchId(branchCommitInformation.getChainBranchId(), BranchCommitInformationImpl.class);
            if (bci != null) {
                bci.copyOf(branchCommitInformation);
                this.branchCommitInformationDao.save((BambooObject)bci);
            } else {
                this.branchCommitInformationDao.save((BambooObject)branchCommitInformation);
            }
        });
    }
}

