/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.plan.branch.BranchDetectionService;
import com.atlassian.bamboo.plan.branch.BranchDetectionServiceImpl;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class BranchDetectionJob
implements Job {
    private static final Logger log = Logger.getLogger(BranchDetectionJob.class);
    private BranchDetectionService branchDetectionService;
    private CachedPlanManager cachedPlanManager;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.debug((Object)"Schedule branch detection for all plans.");
        if (this.branchDetectionService instanceof BranchDetectionServiceImpl) {
            ((BranchDetectionServiceImpl)this.branchDetectionService).logQueueSize();
        }
        for (ImmutableChain chain : this.cachedPlanManager.getPlans(ImmutableTopLevelPlan.class)) {
            this.branchDetectionService.scheduleBranchDetectionForChain(chain);
        }
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setBranchDetectionService(BranchDetectionService branchDetectionService) {
        this.branchDetectionService = branchDetectionService;
    }
}

