/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.branch.BranchDetectionJob;
import com.atlassian.bamboo.quartz.PreventJobExecutionUntilCompletedTriggerListener;
import org.apache.log4j.Logger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.utils.Key;

public class BranchDetectionJobScheduler {
    private static final Logger log = Logger.getLogger(BranchDetectionJobScheduler.class);
    public static final String BRANCH_DETECTION = "BranchDetection";
    private static final JobKey JOB_KEY = new JobKey("BranchDetection", "BranchDetection");
    private final Scheduler scheduler;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public BranchDetectionJobScheduler(Scheduler scheduler, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.scheduler = scheduler;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public void scheduleBranchDetecting() throws SchedulerException {
        int branchDetectionCheckInterval = this.administrationConfigurationAccessor.getAdministrationConfiguration().getBranchDetectionCheckInterval();
        JobDetail jobDetail = JobBuilder.newJob(BranchDetectionJob.class).withIdentity(JOB_KEY).build();
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)branchDetectionCheckInterval)).withIdentity(BRANCH_DETECTION).build();
        this.scheduler.getListenerManager().addTriggerListener(PreventJobExecutionUntilCompletedTriggerListener.INSTANCE, (Matcher)KeyMatcher.keyEquals((Key)trigger.getKey()));
        log.info((Object)("Branch detection running every " + branchDetectionCheckInterval + "s."));
        this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
    }

    public void rescheduleBranchDetecting() throws SchedulerException {
        this.scheduler.deleteJob(JOB_KEY);
        this.scheduleBranchDetecting();
    }
}

