/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.build.creation.ChainBranchCreationService;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.build.pipeline.concurrent.SystemAuthorityThreadFactory;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.collections.SimpleActionParametersMap;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.core.ScopedExclusionServiceHelper;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.jira.issuelink.JiraBranchLinkingService;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.plan.ItemDetections;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.branch.BambooVcsBranch;
import com.atlassian.bamboo.plan.branch.BambooVcsBranchImpl;
import com.atlassian.bamboo.plan.branch.BranchDetectionService;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfiguration;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.branch.ChainBranchUtils;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.repository.RepositoryCachingFacade;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.BambooMaps;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.utils.NameProvider;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataImpl;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.RawRepositoryConfigurationXmlConverter;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.VcsBranchDetector;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.TextProvider;
import com.atlassian.struts.ValidationAware;
import com.atlassian.struts.ValidationAwareSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class BranchDetectionServiceImpl
implements BranchDetectionService {
    private static final String FAKE_BRANCH_NAME = "initialize.chain.branches@@!3.141519";
    public static final String BANDANA_ENFORCE_POLLING = "enforce.detection.by.polling";
    private static final Logger log = Logger.getLogger(BranchDetectionServiceImpl.class);
    private static final int THREAD_POOL_SIZE = 3;
    private static final boolean ALLOW_BRANCH_DETECTION = !SystemProperty.DISABLE_BRANCH_DETECTION.getValue(false);
    private static final boolean ALLOW_CLOSED_BRANCH_DETECTION = !SystemProperty.DISABLE_CLOSED_BRANCH_DETECTION.getValue(false);
    private final ItemDetections branchDetections = new ItemDetections();
    private final PlanManager planManager;
    private final ChainBranchCreationService chainBranchCreationService;
    private final VcsBranchManager vcsBranchManager;
    private final RepositoryCachingFacade repositoryCachingFacade;
    private final ErrorHandler errorHandler;
    private final ScopedExclusionService scopedExclusionService;
    private final EventPublisher eventPublisher;
    private final JiraBranchLinkingService jiraBranchLinkingService;
    private final CustomVariableContext customVariableContext;
    private final HibernateTemplate hibernateTemplate;
    private final CachedPlanManager cachedPlanManager;
    private final TextProvider textProvider;
    private final ChainBranchManager chainBranchManager;
    private final VcsRepositoryManager vcsRepositoryManager;
    private final RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final BandanaManager bandanaManager;

    public BranchDetectionServiceImpl(PlanManager planManager, ChainBranchCreationService chainBranchCreationService, VcsBranchManager vcsBranchManager, RepositoryCachingFacade repositoryCachingFacade, ErrorHandler errorHandler, ScopedExclusionService scopedExclusionService, EventPublisher eventPublisher, JiraBranchLinkingService jiraBranchLinkingService, CustomVariableContext customVariableContext, HibernateTemplate hibernateTemplate, CachedPlanManager cachedPlanManager, TextProvider textProvider, ChainBranchManager chainBranchManager, VcsRepositoryManager vcsRepositoryManager, RawRepositoryConfigurationXmlConverter rawRepositoryConfigurationXmlConverter, RepositoryDefinitionManager repositoryDefinitionManager, BandanaManager bandanaManager) {
        this.planManager = planManager;
        this.chainBranchCreationService = chainBranchCreationService;
        this.vcsBranchManager = vcsBranchManager;
        this.repositoryCachingFacade = repositoryCachingFacade;
        this.errorHandler = errorHandler;
        this.scopedExclusionService = scopedExclusionService;
        this.eventPublisher = eventPublisher;
        this.jiraBranchLinkingService = jiraBranchLinkingService;
        this.customVariableContext = customVariableContext;
        this.hibernateTemplate = hibernateTemplate;
        this.cachedPlanManager = cachedPlanManager;
        this.textProvider = textProvider;
        this.chainBranchManager = chainBranchManager;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.rawRepositoryConfigurationXmlConverter = rawRepositoryConfigurationXmlConverter;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.bandanaManager = bandanaManager;
        SystemAuthorityThreadFactory threadFactory = new SystemAuthorityThreadFactory("BranchDetectionBackgroundThread");
        for (int i = 0; i < 3; ++i) {
            threadFactory.newThread((Runnable)new BranchDetector(this.branchDetections)).start();
        }
    }

    public boolean scheduleBranchListInitialisation(@NotNull Chain chain) {
        this.raiseInitialiseBranchesFlagNoLock(chain);
        return this.branchDetections.queue(chain.getPlanKey(), true);
    }

    public boolean scheduleBranchDetectionForChain(@NotNull ImmutableChain chain) {
        return this.branchDetections.queue(chain.getPlanKey());
    }

    Supplier<PlanRepositoryDefinition> defaultRepositorySupplier(ImmutableChain chain) {
        return () -> PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detectBranchesForChain(@NotNull ImmutableChain chain) {
        PlanKey planKey = chain.getPlanKey();
        if (this.branchDetections.start(planKey)) {
            try {
                PlanRepositoryDefinition defaultRepositoryDefinition = (PlanRepositoryDefinition)this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)planKey, ScopedExclusionServiceHelper.adapt(this.defaultRepositorySupplier(chain)));
                this.createNewBranchesForChainNoLock(chain, defaultRepositoryDefinition, true, branchPlanKey -> {});
            }
            finally {
                this.branchDetections.end(planKey);
            }
        } else {
            log.info((Object)("Detection for " + chain.getPlanKey() + " is already in progress, waiting until it's finished..."));
            this.branchDetections.waitForEnd(planKey);
            log.info((Object)("Finished waiting for detection on " + chain.getPlanKey()));
        }
    }

    protected void createNewBranchesForChainNoLock(@NotNull ImmutableChain chain, @NotNull PlanRepositoryDefinition defaultRepositoryDefinition, boolean ignoreChainConfig, Consumer<PlanKey> consumer) {
        log.debug((Object)("Detecting branches for plan " + chain.getKey()));
        if (chain.hasMaster()) {
            log.warn((Object)this.addErrorLog(chain, this.textProvider.getText("branch.detection.error.notmaster", new String[]{chain.getKey()})));
            return;
        }
        BranchMonitoringConfiguration branchMonitoringConfiguration = chain.getBuildDefinition().getBranchMonitoringConfiguration();
        boolean planBranchCreationEnabled = PlanBranchWorkflow.BRANCH_WORKFLOW == branchMonitoringConfiguration.getPlanBranchWorkflow();
        boolean planBranchDeletionEnabled = branchMonitoringConfiguration.isRemovedBranchCleanUpEnabled();
        if (!(ignoreChainConfig || planBranchCreationEnabled || planBranchDeletionEnabled)) {
            log.debug((Object)String.format("Not detecting new branches for chain [%s] because it is not configured for auto plan branch creation or deletion.", chain.getKey()));
            return;
        }
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(defaultRepositoryDefinition.getPluginKey());
        if (moduleDescriptor == null || !moduleDescriptor.supportsBranchDetection()) {
            log.warn((Object)this.addErrorLog(chain, this.textProvider.getText("branch.detection.error.repositorynotsupported", new String[]{chain.getKey()})));
            return;
        }
        boolean pollingEnforcedByBandanaFlag = Boolean.TRUE.equals(this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.forPlan((ImmutablePlan)chain), BANDANA_ENFORCE_POLLING));
        if (pollingEnforcedByBandanaFlag) {
            log.debug((Object)"Polling enforced by bandana flag - will not check repository settings/state");
        }
        if (!(pollingEnforcedByBandanaFlag || SystemProperty.ENFORCE_POLLING_BRANCH_DETECTION_EVEN_WHEN_REPO_CAN_PUSH_IT.getTypedValue() || moduleDescriptor.getBranchDetector().usePollingForBranchDetection((VcsRepositoryData)defaultRepositoryDefinition))) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Skipping generic change detection - repository does it on it's own: %s, (called from plan: %s)", defaultRepositoryDefinition.getName(), chain.getPlanKey()));
            }
            return;
        }
        Optional<List<VcsBranch>> branchesOpenInVcs = this.getOpenBranches(chain, defaultRepositoryDefinition, moduleDescriptor.getBranchDetector(), null);
        if (!branchesOpenInVcs.isPresent() || CollectionUtils.isEmpty((Collection)branchesOpenInVcs.get())) {
            log.debug((Object)("No branches for plan " + chain.getKey() + " found in VCS"));
            return;
        }
        List<BambooVcsBranch> vcsBranchesKnownAtSomePoint = this.getVcsBranchesWithoutDetectedDeletion(chain);
        ArrayList<VcsBranch> branchesToCreate = new ArrayList<VcsBranch>();
        ArrayList<BambooVcsBranch> branchesGoneFromVcs = new ArrayList<BambooVcsBranch>();
        this.determineBranchesToCreateAndDelete((Collection<VcsBranch>)branchesOpenInVcs.get(), vcsBranchesKnownAtSomePoint, defaultRepositoryDefinition.getBranch().getVcsBranch(), branchesToCreate, branchesGoneFromVcs, defaultRepositoryDefinition);
        if (ignoreChainConfig || planBranchCreationEnabled) {
            this.createPlanBranchesIfAutoCreationIsEnabled(chain, defaultRepositoryDefinition, moduleDescriptor, branchesToCreate, consumer);
        } else {
            log.debug((Object)String.format("Won't create plan branches for plan %s because branch creation is disabled for the plan.", chain.getPlanKey()));
        }
        this.cleanUpPlanBranchesOfRemovedVcsBranches(chain, branchesGoneFromVcs, ignoreChainConfig || planBranchDeletionEnabled, pollingEnforcedByBandanaFlag);
        log.debug((Object)("Finished detecting branches for plan " + chain.getKey()));
    }

    private void cleanUpPlanBranchesOfRemovedVcsBranches(ImmutableChain chain, List<BambooVcsBranch> branchesGoneFromVcs, boolean cleanupEnabled, boolean pollingEnforcedByBandanaFlag) {
        if (!branchesGoneFromVcs.isEmpty()) {
            log.log((Priority)(branchesGoneFromVcs.size() > 10 ? Level.INFO : Level.DEBUG), (Object)(branchesGoneFromVcs.size() + " branches is gone from VCS for chain " + chain.getPlanKey()));
        }
        Set removedBranchNames = BambooIterables.stream(branchesGoneFromVcs).map(NameProvider::getName).collect(Collectors.toSet());
        HashSet<String> removedBranchesAccountedFor = new HashSet<String>();
        if (cleanupEnabled) {
            for (ImmutableChainBranch chainBranch : this.cachedPlanManager.getBranchesForChain((PlanIdentifier)chain)) {
                String branchName = ChainBranchUtils.getSubstitutedVcsBranchName(this.customVariableContext, (ImmutablePlan)chainBranch);
                if (branchName == null || !removedBranchNames.contains(branchName)) continue;
                this.chainBranchManager.handleVcsBranchDeletedOfPlanBranch((ImmutableChain)chainBranch);
                removedBranchesAccountedFor.add(branchName);
            }
        } else {
            log.debug((Object)String.format("Won't remove plan branches for plan %s because branch deletion is disabled for the plan.", chain.getPlanKey()));
        }
        Sets.SetView removedBranchesUnaccountedFor = Sets.difference(removedBranchNames, removedBranchesAccountedFor);
        if (!removedBranchesUnaccountedFor.isEmpty()) {
            List vcsBranchList = this.vcsBranchManager.findNotDeletedByChain(chain);
            for (String branchName : removedBranchesUnaccountedFor) {
                vcsBranchList.stream().filter(vcsBranch -> vcsBranch.isEqualToBranchWith(branchName) && vcsBranch.getDetectedDeletionDate() == null).forEach(vcsBranch -> this.markBranchDeleted((BambooVcsBranch)vcsBranch, chain));
            }
        }
        if (pollingEnforcedByBandanaFlag) {
            this.bandanaManager.removeValue((BandanaContext)PlanAwareBandanaContext.forPlan((ImmutablePlan)chain), BANDANA_ENFORCE_POLLING);
        }
    }

    private void markBranchDeleted(@NotNull BambooVcsBranch vcsBranch, @NotNull ImmutableChain chain) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Marking VCS branch %s of chain %s as removed", vcsBranch.getName(), chain.getPlanKey().getKey()));
        }
        vcsBranch.setDetectedDeletionDate(new Date());
        DefaultChain mutableChain = new DefaultChain();
        mutableChain.setId(vcsBranch.getChainId());
        vcsBranch.setChain((Chain)mutableChain);
        this.vcsBranchManager.save(vcsBranch);
    }

    private void createPlanBranchesIfAutoCreationIsEnabled(ImmutableChain chain, PlanRepositoryDefinition defaultRepositoryDefinition, VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor, Collection<VcsBranch> branchesToCreate, Consumer<PlanKey> consumer) {
        Collection branchesToCreateFiltered;
        BranchMonitoringConfiguration branchMonitoringConfiguration = chain.getBuildDefinition().getBranchMonitoringConfiguration();
        if (StringUtils.isNotBlank((CharSequence)branchMonitoringConfiguration.getMatchingPattern())) {
            Pattern matchingPattern = Pattern.compile(branchMonitoringConfiguration.getMatchingPattern());
            branchesToCreateFiltered = branchesToCreate.stream().filter(candidate -> {
                boolean matches = matchingPattern.matcher(candidate.getName()).matches();
                if (log.isDebugEnabled() && !matches) {
                    log.debug((Object)("VCS Branch '" + candidate + "' does not match the given pattern. It will not be created."));
                }
                return matches;
            }).collect(Collectors.toList());
        } else {
            branchesToCreateFiltered = branchesToCreate;
        }
        PlanCreationService.EnablePlan enablePlan = PlanCreationService.EnablePlan.ENABLED;
        this.createPlanBranches(chain, PlanBranchWorkflow.BRANCH_WORKFLOW, branchesToCreateFiltered, defaultRepositoryDefinition, vcsRepositoryModuleDescriptor, null, enablePlan, true, consumer);
    }

    private void findBranchesCreatedBeforePlanCreation(ImmutableChain chain) {
        log.debug((Object)("Detecting already existing branches for plan " + chain.getKey()));
        if (chain.hasMaster()) {
            log.warn((Object)this.addErrorLog(chain, this.textProvider.getText("branch.detection.error.notmaster", new String[]{chain.getKey()})));
            return;
        }
        PlanRepositoryDefinition defaultRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
        if (defaultRepositoryDefinition == null) {
            log.warn((Object)this.addErrorLog(chain, this.textProvider.getText("branch.detection.error.norepository", new String[]{chain.getKey()})));
            return;
        }
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(defaultRepositoryDefinition.getPluginKey());
        if (moduleDescriptor == null || !moduleDescriptor.supportsBranchDetection()) {
            log.warn((Object)this.addErrorLog(chain, this.textProvider.getText("branch.detection.error.repositorynotsupported", new String[]{chain.getKey()})));
            return;
        }
        Optional<List<VcsBranch>> openBranches = this.getOpenBranches(chain, defaultRepositoryDefinition, moduleDescriptor.getBranchDetector(), null);
        if (!openBranches.isPresent()) {
            log.debug((Object)("No branches for plan " + chain.getKey() + " found in VCS"));
            return;
        }
        HashSet branchesInVcs = new HashSet(openBranches.get());
        this.vcsBranchManager.deleteAll(chain);
        this.vcsBranchManager.createAll(chain, branchesInVcs);
        log.debug((Object)("Finished detecting already existing branches for plan " + chain.getKey()));
    }

    @NotNull
    public synchronized Collection<PlanKey> createPlanBranches(@NotNull ImmutableChain chain, @NotNull Collection<VcsBranch> branches, @Nullable ErrorCollection errorCollection) {
        PlanCreationService.EnablePlan enablePlan = chain.isSuspendedFromBuilding() ? PlanCreationService.EnablePlan.DISABLED : PlanCreationService.EnablePlan.ENABLED;
        return this.createPlanBranches(chain, branches, errorCollection, enablePlan);
    }

    @NotNull
    public synchronized Collection<PlanKey> createPlanBranches(@NotNull ImmutableChain chain, @NotNull Collection<VcsBranch> branches, @Nullable ErrorCollection errorCollection, PlanCreationService.EnablePlan enablePlan) {
        return this.createPlanBranches(chain, PlanBranchWorkflow.defaultValue(), branches, errorCollection, enablePlan);
    }

    @NotNull
    public synchronized Collection<PlanKey> createPlanBranches(@NotNull ImmutableChain chain, @NotNull PlanBranchWorkflow planBranchWorkflow, @NotNull Collection<VcsBranch> branches, @Nullable ErrorCollection errorCollection, @NotNull PlanCreationService.EnablePlan enablePlan, @NotNull Consumer<PlanKey> consumer) {
        PlanRepositoryDefinition defaultRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
        if (defaultRepositoryDefinition == null) {
            log.warn((Object)this.addErrorLog(chain, "Can't create branches for plan " + chain.getKey() + " - it has no default repository defined.", errorCollection));
            return Collections.emptyList();
        }
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(defaultRepositoryDefinition.getPluginKey());
        if (moduleDescriptor == null || moduleDescriptor.getVcsBranchConfigurator() == null) {
            log.warn((Object)this.addErrorLog(chain, "Can't create branches for plan " + chain.getKey() + " - it's default repository does not support automatic branch creation", errorCollection));
            return Collections.emptyList();
        }
        boolean enableExpiry = true;
        return this.createPlanBranches(chain, planBranchWorkflow, branches, defaultRepositoryDefinition, moduleDescriptor, errorCollection, enablePlan, enableExpiry, consumer);
    }

    private Collection<PlanKey> createPlanBranches(@NotNull ImmutableChain chain, @NotNull PlanBranchWorkflow planBranchWorkflow, @NotNull Collection<VcsBranch> branches, PlanRepositoryDefinition defaultRepositoryDefinition, VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor, @Nullable ErrorCollection errorCollection, PlanCreationService.EnablePlan enablePlan, boolean enableExpiry, @NotNull Consumer<PlanKey> consumer) {
        ArrayList<PlanKey> createdPlanBranchesKeys = new ArrayList<PlanKey>();
        if (!branches.isEmpty()) {
            log.log((Priority)(branches.size() > 10 ? Level.INFO : Level.DEBUG), (Object)("Trying to create " + branches.size() + " branches for chain " + chain.getPlanKey()));
        }
        List existingChainBranches = this.cachedPlanManager.getBranchesOfChain(chain.getPlanKey()).collect(Collectors.toList());
        for (VcsBranch newBranch : branches) {
            try {
                ImmutableChainBranch chainBranch;
                BambooVcsBranch bambooVcsBranch;
                String branchName = ChainBranchUtils.getValidChainBranchName(newBranch);
                if (planBranchWorkflow == PlanBranchWorkflow.BRANCH_WORKFLOW && (bambooVcsBranch = this.vcsBranchManager.findByChainAndName(chain.getId(), newBranch.getName())) != null && (chainBranch = this.findAndEnableBranch(existingChainBranches.stream(), chain, newBranch, bambooVcsBranch)) != null) {
                    createdPlanBranchesKeys.add(chainBranch.getPlanKey());
                    continue;
                }
                PlanKey createdBranchKey = this.createChainBranch(chain, planBranchWorkflow, branchName, defaultRepositoryDefinition, vcsRepositoryModuleDescriptor, newBranch, new BuildConfiguration(), errorCollection, enablePlan, enableExpiry, consumer);
                if (createdBranchKey == null) continue;
                createdPlanBranchesKeys.add(createdBranchKey);
            }
            catch (Exception e) {
                log.error((Object)this.addErrorLog(chain, "Unable to create plan branch for plan: " + chain.getPlanKey() + ", branch: " + newBranch + ". " + e.getMessage(), e, errorCollection), (Throwable)e);
            }
        }
        return createdPlanBranchesKeys;
    }

    private String addErrorLog(ImmutableChain chain, String message, Throwable throwable, @Nullable ErrorCollection errorCollection) {
        this.errorHandler.recordError((Key)chain.getPlanKey(), message, throwable);
        if (errorCollection != null) {
            errorCollection.addErrorMessage(message);
        }
        return message;
    }

    private String addErrorLog(ImmutableChain chain, String message, @Nullable ErrorCollection errorCollection) {
        this.errorHandler.recordError((Key)chain.getPlanKey(), message);
        if (errorCollection != null) {
            errorCollection.addErrorMessage(message);
        }
        return message;
    }

    private String addErrorLog(ImmutableChain chain, String message) {
        return this.addErrorLog(chain, message, null);
    }

    @Nullable
    public List<VcsBranch> getOpenBranches(@NotNull ImmutableChain chain, ErrorCollection errorCollection) {
        PlanRepositoryDefinition defaultRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
        if (defaultRepositoryDefinition == null) {
            log.warn((Object)this.addErrorLog(chain, this.textProvider.getText("branch.detection.error.norepository", new String[]{chain.getKey()}), errorCollection));
            return null;
        }
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(defaultRepositoryDefinition.getPluginKey());
        if (moduleDescriptor == null || !moduleDescriptor.supportsBranchDetection()) {
            log.warn((Object)this.addErrorLog(chain, this.textProvider.getText("branch.detection.error.repositorynotsupported", new String[]{chain.getKey()}), errorCollection));
            return null;
        }
        return (List)CacheAwareness.withValuesOlderThanTimestampReloaded(() -> this.getOpenBranches(chain, defaultRepositoryDefinition, moduleDescriptor.getBranchDetector(), errorCollection).orElse(null), System.currentTimeMillis(), CacheAwareness.BRANCH_DETECTION);
    }

    @NotNull
    private Optional<List<VcsBranch>> getOpenBranches(ImmutableChain chain, PlanRepositoryDefinition planRepositoryDefinition, VcsBranchDetector branchDetector, @Nullable ErrorCollection errorCollection) {
        try {
            VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan((ImmutablePlan)chain);
            List vcsBranches = (List)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> new ArrayList(this.repositoryCachingFacade.getOpenBranches(branchDetector, (VcsRepositoryData)planRepositoryDefinition)));
            Collections.reverse(vcsBranches);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Found following branches for plan %s", chain.getPlanKey()));
                for (VcsBranch branch : vcsBranches) {
                    log.trace((Object)branch.getName());
                }
            }
            return Optional.of(vcsBranches);
        }
        catch (Exception e) {
            log.error((Object)this.addErrorLog(chain, "Repository error while detecting branches for plan " + chain.getKey() + ". " + e.getMessage(), e, errorCollection), (Throwable)e);
            return Optional.empty();
        }
    }

    private void determineBranchesToCreateAndDelete(@NotNull Collection<VcsBranch> branchesInVcs, @NotNull Iterable<BambooVcsBranch> vcsBranchesKnownAtSomePoint, @Nullable VcsBranch masterBranch, @NotNull Collection<VcsBranch> branchesToCreate, @NotNull Collection<BambooVcsBranch> branchesGoneFromVcs, @NotNull PlanRepositoryDefinition defaultRepositoryDefinition) {
        boolean isNewSubversion = defaultRepositoryDefinition.getPluginKey().equals("com.atlassian.bamboo.plugin.system.repository:svnv2");
        Map branchesToDeleteMap = BambooMaps.mutableUniqueIndex(vcsBranchesKnownAtSomePoint, NameProvider::getName);
        branchesToCreate.addAll(branchesInVcs);
        block0: for (VcsBranch branchInVcs : branchesInVcs) {
            String branchDisplayName = branchInVcs.getDisplayName();
            for (BambooVcsBranch branchKnownAtSomePoint : vcsBranchesKnownAtSomePoint) {
                if (!this.isTheSameBranch(isNewSubversion, branchInVcs, branchDisplayName, branchKnownAtSomePoint, (VcsRepositoryData)defaultRepositoryDefinition)) continue;
                log.debug((Object)("VCS branch " + branchInVcs + " is known to Bamboo.  No action will be taken."));
                branchesToCreate.remove(branchInVcs);
                branchesToDeleteMap.remove(branchInVcs.getName());
                continue block0;
            }
        }
        if (masterBranch != null) {
            branchesToDeleteMap.remove(masterBranch.getName());
            branchesToCreate.remove(masterBranch);
        }
        branchesGoneFromVcs.addAll(branchesToDeleteMap.values());
    }

    private boolean isTheSameBranch(boolean isNewSubversion, VcsBranch branchInVcs, String branchDisplayName, BambooVcsBranch branchKnownAtSomePoint, VcsRepositoryData repositoryData) {
        if (branchInVcs.isEqualToBranchWith(branchKnownAtSomePoint.getName())) {
            return true;
        }
        if (isNewSubversion) {
            if (branchDisplayName.equals(branchKnownAtSomePoint.getName())) {
                return true;
            }
            String url = (String)repositoryData.getVcsLocation().getConfiguration().get("repository.svn.repositoryRoot") + '/' + branchInVcs.getName();
            if (url.equals(branchKnownAtSomePoint.getName())) {
                return true;
            }
        }
        return false;
    }

    private List<BambooVcsBranch> getVcsBranchesKnownAtSomePoint(ImmutableChain chain) {
        return this.vcsBranchManager.findByChain(chain);
    }

    private List<BambooVcsBranch> getVcsBranchesWithoutDetectedDeletion(ImmutableChain chain) {
        return this.vcsBranchManager.findNotDeletedByChain(chain);
    }

    @NotNull
    public synchronized PlanKey createOrEnableChainBranch(@NotNull ImmutableChain chain, @NotNull PlanBranchWorkflow planBranchWorkflow, @NotNull VcsBranch vcsBranch, @Nullable BuildConfiguration buildConfiguration, @NotNull PlanCreationService.EnablePlan enablePlan, boolean enableExpiry, Consumer<PlanKey> planBranchConsumer) throws PlanCreationDeniedException {
        Stream existingChainBranches;
        ImmutableChainBranch chainBranch;
        BambooVcsBranch bambooVcsBranch;
        if (buildConfiguration == null) {
            buildConfiguration = new BuildConfiguration();
        }
        Preconditions.checkArgument((vcsBranch != null ? 1 : 0) != 0, (Object)"Vcs branch must not be null");
        PlanRepositoryDefinition defaultRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
        if (defaultRepositoryDefinition == null) {
            throw new IllegalArgumentException("Can't override vcsBranch for plan " + chain.getKey() + " as it does not have default repository defined");
        }
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(defaultRepositoryDefinition.getPluginKey());
        if (planBranchWorkflow == PlanBranchWorkflow.BRANCH_WORKFLOW && (bambooVcsBranch = this.vcsBranchManager.findByChainAndName(chain.getId(), vcsBranch.getName())) != null && (chainBranch = this.findAndEnableBranch(existingChainBranches = this.cachedPlanManager.getBranchesOfChain(chain.getPlanKey()), chain, vcsBranch, bambooVcsBranch)) != null) {
            return chainBranch.getPlanKey();
        }
        return this.createChainBranch(chain, planBranchWorkflow, ChainBranchUtils.getValidChainBranchName(vcsBranch), defaultRepositoryDefinition, moduleDescriptor, vcsBranch, buildConfiguration, null, enablePlan, enableExpiry, planBranchConsumer);
    }

    @NotNull
    private ImmutableChainBranch enableBranch(@NotNull BambooVcsBranch bambooVcsBranch, ImmutableChainBranch chainBranch) {
        log.debug((Object)("Found existing branch " + chainBranch.getPlanKey() + " for vcs branch " + bambooVcsBranch.getName() + ". Enabling it."));
        if (chainBranch.isSuspendedFromBuilding()) {
            this.planManager.setPlanSuspendedState(chainBranch.getPlanKey(), false);
            bambooVcsBranch.setDetectedDeletionDate(null);
            this.vcsBranchManager.createAll(Collections.singletonList(bambooVcsBranch));
        }
        return chainBranch;
    }

    private ImmutableChainBranch findAndEnableBranch(Stream<ImmutableChainBranch> existingChainBranches, @NotNull ImmutableChain chain, @NotNull VcsBranch vcsBranch, @NotNull BambooVcsBranch bambooVcsBranch) {
        return existingChainBranches.filter(cb -> cb.getBuildDefinition().getBranchSpecificConfiguration().getPlanBranchWorkflow() != PlanBranchWorkflow.PULL_REQUEST_WORKFLOW).filter(cb -> vcsBranch.getName().equals(ChainBranchUtils.getSubstitutedVcsBranchName(this.customVariableContext, (ImmutablePlan)cb))).findFirst().map(cb -> this.enableBranch(bambooVcsBranch, (ImmutableChainBranch)cb)).orElse(null);
    }

    @NotNull
    public synchronized PlanKey createChainBranch(@NotNull ImmutableChain chain, @NotNull String branchName, @Nullable VcsBranch vcsBranch, @Nullable BuildConfiguration buildConfiguration, PlanCreationService.EnablePlan enablePlan, boolean enableExpiry) throws PlanCreationDeniedException {
        return this.createChainBranch(chain, PlanBranchWorkflow.defaultValue(), branchName, vcsBranch, buildConfiguration, enablePlan, enableExpiry);
    }

    @NotNull
    public synchronized PlanKey createChainBranch(@NotNull ImmutableChain chain, @NotNull PlanBranchWorkflow planBranchWorkflow, @NotNull String branchName, @Nullable VcsBranch vcsBranch, @Nullable BuildConfiguration buildConfiguration, @NotNull PlanCreationService.EnablePlan enablePlan, boolean enableExpiry, Consumer<PlanKey> planBranchConsumer) throws PlanCreationDeniedException {
        if (buildConfiguration == null) {
            buildConfiguration = new BuildConfiguration();
        }
        PlanRepositoryDefinition defaultRepositoryDefinition = null;
        VcsRepositoryModuleDescriptor moduleDescriptor = null;
        if (vcsBranch != null) {
            defaultRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
            if (defaultRepositoryDefinition == null) {
                throw new IllegalArgumentException("Can't override vcsBranch for plan " + chain.getKey() + " as it does not have default repository defined");
            }
            moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(defaultRepositoryDefinition.getPluginKey());
        }
        ValidationAwareSupport validationAware = new ValidationAwareSupport();
        this.validateCreateChainBranch(chain, planBranchWorkflow, branchName, defaultRepositoryDefinition, moduleDescriptor, vcsBranch, enableExpiry, (ValidationAware)validationAware);
        if (validationAware.hasErrors()) {
            StringBuilder errorMessage = new StringBuilder();
            for (Object e : validationAware.getActionErrors()) {
                errorMessage.append(e);
            }
            for (Object object : validationAware.getFieldErrors().entrySet()) {
                Map.Entry fieldError = (Map.Entry)object;
                errorMessage.append(fieldError.getKey()).append(": ").append(fieldError.getValue());
            }
            throw new IllegalArgumentException("Invalid parameters while trying to create new branch " + branchName + " for plan " + chain.getKey() + ". Error: " + errorMessage.toString());
        }
        return this.createChainBranch(chain, planBranchWorkflow, branchName, defaultRepositoryDefinition, moduleDescriptor, vcsBranch, buildConfiguration, null, enablePlan, enableExpiry, planBranchConsumer);
    }

    public void deleteBambooVcsBranch(@NotNull Iterable<ImmutableChain> chains, @NotNull String branchName) {
        Set chainMasters = BambooIterables.stream(chains).map(PlanHelper::getMasterPlan).collect(Collectors.toSet());
        HashSet<BambooVcsBranch> branchesToDelete = new HashSet<BambooVcsBranch>();
        block0: for (ImmutableChain chainMaster : chainMasters) {
            List allBranches = this.vcsBranchManager.findByChain(chainMaster);
            for (BambooVcsBranch branch : allBranches) {
                if (!branch.isEqualToBranchWith(branchName)) continue;
                log.info((Object)("Branch " + branch.getName() + " removed from VCS, forgetting it"));
                branchesToDelete.add(branch);
                continue block0;
            }
        }
        if (!branchesToDelete.isEmpty()) {
            this.vcsBranchManager.deleteAll(branchesToDelete);
        }
    }

    public void disableChainBranch(@NotNull Iterable<ImmutableChain> chains) {
        if (ALLOW_CLOSED_BRANCH_DETECTION) {
            for (ImmutableChain chain : chains) {
                VcsRepositoryModuleDescriptor moduleDescriptor;
                if (chain.isSuspendedFromBuilding() || chain.isMarkedForDeletion()) {
                    log.debug((Object)("Chain branch will not be disabled " + chain.getKey()));
                    return;
                }
                PlanRepositoryDefinition repositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
                if (!(repositoryDefinition == null || (moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryDefinition.getPluginKey())) != null && moduleDescriptor.supportsBranchDetection())) {
                    log.warn((Object)("Can't disable chain branch " + chain.getKey() + " because its default repository is not BranchDetectionCapableRepository."));
                    continue;
                }
                this.planManager.setPlanSuspendedState(chain.getPlanKey(), true);
                this.eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, chain.getPlanKey()));
            }
        }
    }

    private void validateCreateChainBranch(@NotNull ImmutableChain chain, @NotNull PlanBranchWorkflow planBranchWorkflow, @NotNull String branchName, @Nullable PlanRepositoryDefinition defaultRepositoryDefinition, @Nullable VcsRepositoryModuleDescriptor moduleDescriptor, @Nullable VcsBranch newBranch, boolean enableExpiry, @NotNull ValidationAware validationAware) {
        Map<String, Object> map = this.createBranchActionParametersMap(chain, planBranchWorkflow, branchName, defaultRepositoryDefinition, moduleDescriptor, newBranch, enableExpiry, null);
        this.chainBranchCreationService.validatePlan(validationAware, new BuildConfiguration(), (ActionParametersMap)new SimpleActionParametersMap(map));
    }

    private Map<String, Object> createBranchActionParametersMap(@NotNull ImmutableChain chain, @NotNull PlanBranchWorkflow planBranchWorkflow, @NotNull String branchName, @Nullable PlanRepositoryDefinition defaultRepositoryDefinition, @Nullable VcsRepositoryModuleDescriptor moduleDescriptor, @Nullable VcsBranch newBranch, boolean enableExpiry, @Nullable ErrorCollection errorCollection) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("branchName", branchName);
        map.put("branchDescription", chain.getDescription());
        map.put("planKeyToClone", chain.getPlanKey().toString());
        map.put("planBranchWorkflow", planBranchWorkflow.getKey());
        map.put("EXPIRY_OFF", !enableExpiry);
        if (newBranch != null && defaultRepositoryDefinition != null && moduleDescriptor != null && moduleDescriptor.getVcsBranchConfigurator() != null) {
            log.debug((Object)("Creating new Branch for plan " + chain.getKey() + " using vcsBranch " + newBranch.getName()));
            VcsBranchConfigurator vcsBranchConfigurator = moduleDescriptor.getVcsBranchConfigurator();
            PartialVcsRepositoryDataImpl branchRepository = PartialVcsRepositoryDataImpl.createChildWithNewBranch((VcsRepositoryData)defaultRepositoryDefinition, newBranch, vcsBranchConfigurator);
            RepositoryDataEntity parent = this.repositoryDefinitionManager.getRepositoryDataEntity(defaultRepositoryDefinition.getId());
            Preconditions.checkState((parent != null ? 1 : 0) != 0, (Object)"Parent repository mysteriously disappeared");
            RepositoryDataEntityImpl branchRepositoryDataEntity = new RepositoryDataEntityImpl(defaultRepositoryDefinition.getPluginKey(), defaultRepositoryDefinition.getName(), defaultRepositoryDefinition.getDescription(), this.rawRepositoryConfigurationXmlConverter.asXml(branchRepository), defaultRepositoryDefinition.isMarkedForDeletion(), false, parent);
            map.put("overridingRepositoryEntity", (Object)branchRepositoryDataEntity);
            map.put("overridingRepository", branchRepository);
        }
        return map;
    }

    @NotNull
    private PlanKey createChainBranch(@NotNull ImmutableChain chain, @NotNull PlanBranchWorkflow planBranchWorkflow, @NotNull String branchName, @Nullable PlanRepositoryDefinition defaultRepositoryDefinition, @Nullable VcsRepositoryModuleDescriptor moduleDescriptor, @Nullable VcsBranch newBranch, @NotNull BuildConfiguration buildConfiguration, @Nullable ErrorCollection errorCollection, PlanCreationService.EnablePlan enablePlan, boolean enableExpiry, @NotNull Consumer<PlanKey> branchPlanKeyConsumer) throws PlanCreationDeniedException {
        Map<String, Object> map = this.createBranchActionParametersMap(chain, planBranchWorkflow, branchName, defaultRepositoryDefinition, moduleDescriptor, newBranch, enableExpiry, errorCollection);
        PlanKey branchKey = PlanKeys.getPlanKey((String)this.chainBranchCreationService.createPlan(buildConfiguration, (ActionParametersMap)new SimpleActionParametersMap(map), enablePlan));
        log.info((Object)("Created branch with key " + branchKey + " for VCS branch " + newBranch));
        this.jiraBranchLinkingService.linkBranchToIssueIfRequiredAsync(branchKey, null);
        log.debug((Object)"calling branch key consumer");
        branchPlanKeyConsumer.accept(branchKey);
        log.debug((Object)"branch key consumer execution complete");
        this.chainBranchCreationService.triggerCreationCompleteEvents(branchKey);
        return branchKey;
    }

    private void raiseInitialiseBranchesFlagNoLock(Chain chain) {
        BambooVcsBranchImpl bambooVcsBranch = new BambooVcsBranchImpl();
        bambooVcsBranch.setChain(chain);
        bambooVcsBranch.setName(FAKE_BRANCH_NAME);
        this.vcsBranchManager.save((BambooVcsBranch)bambooVcsBranch);
    }

    private boolean checkInitialiseBranchesFlagNoLock(ImmutableChain chain) {
        for (BambooVcsBranch vcsBranch : this.getVcsBranchesKnownAtSomePoint(chain)) {
            if (!FAKE_BRANCH_NAME.equals(vcsBranch.getName())) continue;
            return true;
        }
        return false;
    }

    void logQueueSize() {
        int size = this.branchDetections.getQueuedDetections().getKeysSize();
        if (size > 0) {
            log.warn((Object)("Branch detection queue size:" + this.branchDetections.getQueuedDetections().getKeysSize()));
        }
    }

    private class BranchDetector
    implements Runnable {
        private final ItemDetections branchDetections;
        final BambooPluginUtils.Runnable detectionLoop = new BambooPluginUtils.Runnable("An unexpected error has occurred while detecting branches"){
            private volatile PlanKey planKey;

            @Override
            public void run() {
                this.planKey = BranchDetector.this.branchDetections.getDetectionRequest();
                try {
                    if (ALLOW_BRANCH_DETECTION) {
                        BranchDetectionServiceImpl.this.hibernateTemplate.execute(session -> {
                            ImmutableChain chain = (ImmutableChain)BranchDetectionServiceImpl.this.cachedPlanManager.getPlanByKey(this.planKey, ImmutableChain.class);
                            if (chain != null) {
                                Pair repositoryStatePair = (Pair)BranchDetectionServiceImpl.this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)this.planKey, ScopedExclusionServiceHelper.adapt(BranchDetector.this.defaultRepositoryAndInitialisationFlagSupplier(chain)));
                                boolean requiresInitialisation = (Boolean)repositoryStatePair.getSecond();
                                if (requiresInitialisation) {
                                    BranchDetectionServiceImpl.this.findBranchesCreatedBeforePlanCreation(chain);
                                } else if (repositoryStatePair.getFirst() != null) {
                                    BranchDetectionServiceImpl.this.createNewBranchesForChainNoLock(chain, (PlanRepositoryDefinition)repositoryStatePair.getFirst(), false, branchPlanKey -> {});
                                } else if (log.isDebugEnabled()) {
                                    log.debug((Object)BranchDetectionServiceImpl.this.textProvider.getText("branch.detection.error.norepository", new String[]{chain.getKey()}));
                                }
                            }
                            return null;
                        });
                    }
                }
                finally {
                    BranchDetector.this.branchDetections.end(this.planKey);
                }
            }

            @Override
            public String getErrorMessage() {
                return super.getErrorMessage() + ": " + this.planKey;
            }

            @Override
            public void onThrow(@NotNull Throwable e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        };

        public BranchDetector(ItemDetections branchDetections) {
            this.branchDetections = branchDetections;
        }

        Supplier<Pair<PlanRepositoryDefinition, Boolean>> defaultRepositoryAndInitialisationFlagSupplier(ImmutableChain chain) {
            return () -> {
                boolean requiresInitialisation = BranchDetectionServiceImpl.this.checkInitialiseBranchesFlagNoLock(chain);
                return Pair.make((Object)PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain), (Object)requiresInitialisation);
            };
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                BambooPluginUtils.callUnsafeCode(this.detectionLoop);
            }
        }
    }
}

